/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import com.scurrilous.circe.checksum.Crc32cIntChecksum;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.ConsumerCryptoFailureAction;
import org.apache.pulsar.client.api.ConsumerStats;
import org.apache.pulsar.client.api.DeadLetterPolicy;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionInitialPosition;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.AcknowledgmentsGroupingTracker;
import org.apache.pulsar.client.impl.Backoff;
import org.apache.pulsar.client.impl.BatchMessageAcker;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.ConnectionHandler;
import org.apache.pulsar.client.impl.ConsumerBase;
import org.apache.pulsar.client.impl.ConsumerInterceptors;
import org.apache.pulsar.client.impl.ConsumerStatsDisabled;
import org.apache.pulsar.client.impl.ConsumerStatsRecorder;
import org.apache.pulsar.client.impl.ConsumerStatsRecorderImpl;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.MessageCrypto;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.NonPersistentAcknowledgmentGroupingTracker;
import org.apache.pulsar.client.impl.PersistentAcknowledgmentsGroupingTracker;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.UnAckedMessageTracker;
import org.apache.pulsar.client.impl.conf.ConsumerConfigurationData;
import org.apache.pulsar.common.api.Commands;
import org.apache.pulsar.common.api.EncryptionContext;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecProvider;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.client.api.v2.Consumer;
import org.apache.pulsar.shade.client.api.v2.Producer;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Iterables;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.Timeout;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerImpl<T>
extends ConsumerBase<T>
implements ConnectionHandler.Connection {
    private static final int MAX_REDELIVER_UNACKNOWLEDGED = 1000;
    final long consumerId;
    private static final AtomicIntegerFieldUpdater<ConsumerImpl> AVAILABLE_PERMITS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ConsumerImpl.class, "availablePermits");
    private volatile int availablePermits = 0;
    private volatile MessageId lastDequeuedMessage = MessageId.earliest;
    private volatile MessageId lastMessageIdInBroker = MessageId.earliest;
    private long subscribeTimeout;
    private final int partitionIndex;
    private final int receiverQueueRefillThreshold;
    private volatile boolean waitingOnReceiveForZeroQueueSize = false;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReadWriteLock zeroQueueLock;
    private final UnAckedMessageTracker unAckedMessageTracker;
    private final AcknowledgmentsGroupingTracker acknowledgmentsGroupingTracker;
    protected final ConsumerStatsRecorder stats;
    private final int priorityLevel;
    private final SubscriptionMode subscriptionMode;
    private volatile BatchMessageIdImpl startMessageId;
    private volatile boolean hasReachedEndOfTopic;
    private final MessageCrypto msgCrypto;
    private final Map<String, String> metadata;
    private final boolean readCompacted;
    private final SubscriptionInitialPosition subscriptionInitialPosition;
    private final ConnectionHandler connectionHandler;
    private final TopicName topicName;
    private final String topicNameWithoutPartition;
    private final Map<MessageIdImpl, List<MessageImpl<T>>> possibleSendToDeadLetterTopicMessages;
    private final DeadLetterPolicy deadLetterPolicy;
    private Producer<T> deadLetterProducer;
    protected volatile boolean paused;
    private static final Logger log = LoggerFactory.getLogger(ConsumerImpl.class);

    ConsumerImpl(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, int partitionIndex, CompletableFuture<Consumer<T>> subscribeFuture, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        this(client, topic, conf, listenerExecutor, partitionIndex, subscribeFuture, SubscriptionMode.Durable, null, schema, interceptors);
    }

    ConsumerImpl(PulsarClientImpl client, String topic, ConsumerConfigurationData<T> conf, ExecutorService listenerExecutor, int partitionIndex, CompletableFuture<Consumer<T>> subscribeFuture, SubscriptionMode subscriptionMode, MessageId startMessageId, Schema<T> schema, ConsumerInterceptors<T> interceptors) {
        super(client, topic, conf, conf.getReceiverQueueSize(), listenerExecutor, subscribeFuture, schema, interceptors);
        this.consumerId = client.newConsumerId();
        this.subscriptionMode = subscriptionMode;
        this.startMessageId = startMessageId != null ? new BatchMessageIdImpl((MessageIdImpl)startMessageId) : null;
        AVAILABLE_PERMITS_UPDATER.set(this, 0);
        this.subscribeTimeout = System.currentTimeMillis() + client.getConfiguration().getOperationTimeoutMs();
        this.partitionIndex = partitionIndex;
        this.receiverQueueRefillThreshold = conf.getReceiverQueueSize() / 2;
        this.priorityLevel = conf.getPriorityLevel();
        this.readCompacted = conf.isReadCompacted();
        this.subscriptionInitialPosition = conf.getSubscriptionInitialPosition();
        this.stats = client.getConfiguration().getStatsIntervalSeconds() > 0L ? new ConsumerStatsRecorderImpl(client, conf, this) : ConsumerStatsDisabled.INSTANCE;
        this.zeroQueueLock = conf.getReceiverQueueSize() <= 1 ? new ReentrantReadWriteLock() : null;
        this.unAckedMessageTracker = conf.getAckTimeoutMillis() != 0L ? (conf.getTickDurationMillis() > 0L ? new UnAckedMessageTracker(client, this, conf.getAckTimeoutMillis(), conf.getTickDurationMillis()) : new UnAckedMessageTracker(client, this, conf.getAckTimeoutMillis())) : UnAckedMessageTracker.UNACKED_MESSAGE_TRACKER_DISABLED;
        this.msgCrypto = conf.getCryptoKeyReader() != null ? new MessageCrypto(String.format("[%s] [%s]", topic, this.subscription), false) : null;
        this.metadata = conf.getProperties().isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(conf.getProperties()));
        this.connectionHandler = new ConnectionHandler(this, new Backoff(100L, TimeUnit.MILLISECONDS, 60L, TimeUnit.SECONDS, 0L, TimeUnit.MILLISECONDS), this);
        this.topicName = TopicName.get(topic);
        this.acknowledgmentsGroupingTracker = this.topicName.isPersistent() ? new PersistentAcknowledgmentsGroupingTracker(this, conf, client.eventLoopGroup()) : NonPersistentAcknowledgmentGroupingTracker.of();
        if (conf.getDeadLetterPolicy() != null) {
            this.possibleSendToDeadLetterTopicMessages = new ConcurrentHashMap<MessageIdImpl, List<MessageImpl<T>>>();
            this.deadLetterPolicy = StringUtils.isNotBlank(conf.getDeadLetterPolicy().getDeadLetterTopic()) ? DeadLetterPolicy.builder().maxRedeliverCount(conf.getDeadLetterPolicy().getMaxRedeliverCount()).deadLetterTopic(conf.getDeadLetterPolicy().getDeadLetterTopic()).build() : DeadLetterPolicy.builder().maxRedeliverCount(conf.getDeadLetterPolicy().getMaxRedeliverCount()).deadLetterTopic(String.format("%s-%s-DLQ", topic, this.subscription)).build();
        } else {
            this.deadLetterPolicy = null;
            this.possibleSendToDeadLetterTopicMessages = null;
        }
        this.topicNameWithoutPartition = this.topicName.getPartitionedTopicName();
        this.grabCnx();
    }

    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    public UnAckedMessageTracker getUnAckedMessageTracker() {
        return this.unAckedMessageTracker;
    }

    @Override
    public CompletableFuture<Void> unsubscribeAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Consumer was already closed"));
        }
        CompletableFuture<Void> unsubscribeFuture = new CompletableFuture<Void>();
        if (this.isConnected()) {
            this.setState(HandlerState.State.Closing);
            long requestId = this.client.newRequestId();
            ByteBuf unsubscribe = Commands.newUnsubscribe(this.consumerId, requestId);
            ClientCnx cnx = this.cnx();
            ((CompletableFuture)cnx.sendRequestWithId(unsubscribe, requestId).thenRun(() -> {
                cnx.removeConsumer(this.consumerId);
                this.unAckedMessageTracker.close();
                if (this.possibleSendToDeadLetterTopicMessages != null) {
                    this.possibleSendToDeadLetterTopicMessages.clear();
                }
                this.client.cleanupConsumer(this);
                log.info("[{}][{}] Successfully unsubscribed from topic", (Object)this.topic, (Object)this.subscription);
                this.setState(HandlerState.State.Closed);
                unsubscribeFuture.complete(null);
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed to unsubscribe: {}", new Object[]{this.topic, this.subscription, e.getCause().getMessage()});
                this.setState(HandlerState.State.Ready);
                unsubscribeFuture.completeExceptionally(e.getCause());
                return null;
            });
        } else {
            unsubscribeFuture.completeExceptionally(new PulsarClientException("Not connected to broker"));
        }
        return unsubscribeFuture;
    }

    @Override
    protected Message<T> internalReceive() throws PulsarClientException {
        if (this.conf.getReceiverQueueSize() == 0) {
            Preconditions.checkArgument(this.zeroQueueLock != null, "Receiver queue size can't be modified");
            this.zeroQueueLock.writeLock().lock();
            try {
                Message<T> message = this.fetchSingleMessageFromBroker();
                return message;
            }
            finally {
                this.zeroQueueLock.writeLock().unlock();
            }
        }
        try {
            Message message = (Message)this.incomingMessages.take();
            this.trackMessage(message);
            Message interceptMsg = this.beforeConsume(message);
            this.messageProcessed(interceptMsg);
            return interceptMsg;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.stats.incrementNumReceiveFailed();
            throw new PulsarClientException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CompletableFuture<Message<T>> internalReceiveAsync() {
        CompletableFuture result = new CompletableFuture();
        Message message = null;
        try {
            this.lock.writeLock().lock();
            message = (Message)this.incomingMessages.poll(0L, TimeUnit.MILLISECONDS);
            if (message == null) {
                this.pendingReceives.add(result);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            result.completeExceptionally(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        if (message == null && this.conf.getReceiverQueueSize() == 0) {
            this.sendFlowPermitsToBroker(this.cnx(), 1);
        } else if (message != null) {
            this.trackMessage(message);
            Message interceptMsg = this.beforeConsume(message);
            this.messageProcessed(interceptMsg);
            result.complete(interceptMsg);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message<T> fetchSingleMessageFromBroker() throws PulsarClientException {
        Preconditions.checkArgument(this.conf.getReceiverQueueSize() == 0);
        if (this.incomingMessages.size() > 0) {
            log.error("The incoming message queue should never be greater than 0 when Queue size is 0");
            this.incomingMessages.clear();
        }
        try {
            Object msgCnx;
            Message message;
            this.waitingOnReceiveForZeroQueueSize = true;
            ConsumerImpl consumerImpl = this;
            synchronized (consumerImpl) {
                if (this.isConnected()) {
                    this.sendFlowPermitsToBroker(this.cnx(), 1);
                }
            }
            while (true) {
                message = (Message)this.incomingMessages.take();
                this.lastDequeuedMessage = message.getMessageId();
                msgCnx = ((MessageImpl)message).getCnx();
                ConsumerImpl consumerImpl2 = this;
                synchronized (consumerImpl2) {
                    if (msgCnx == this.cnx()) {
                        this.waitingOnReceiveForZeroQueueSize = false;
                        break;
                    }
                }
            }
            this.stats.updateNumMsgsReceived(message);
            msgCnx = message;
            return msgCnx;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.stats.incrementNumReceiveFailed();
            throw new PulsarClientException(e);
        }
        finally {
            this.waitingOnReceiveForZeroQueueSize = false;
            this.incomingMessages.clear();
        }
    }

    @Override
    protected Message<T> internalReceive(int timeout, TimeUnit unit) throws PulsarClientException {
        try {
            Message message = (Message)this.incomingMessages.poll(timeout, unit);
            this.trackMessage(message);
            Message interceptMsg = this.beforeConsume(message);
            if (interceptMsg != null) {
                this.messageProcessed(interceptMsg);
            }
            return interceptMsg;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            HandlerState.State state = this.getState();
            if (state != HandlerState.State.Closing && state != HandlerState.State.Closed) {
                this.stats.incrementNumReceiveFailed();
                throw new PulsarClientException(e);
            }
            return null;
        }
    }

    boolean markAckForBatchMessage(BatchMessageIdImpl batchMessageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties) {
        boolean isAllMsgsAcked = ackType == PulsarApi.CommandAck.AckType.Individual ? batchMessageId.ackIndividual() : batchMessageId.ackCumulative();
        int outstandingAcks = 0;
        if (log.isDebugEnabled()) {
            outstandingAcks = batchMessageId.getOutstandingAcksInSameBatch();
        }
        int batchSize = batchMessageId.getBatchSize();
        if (isAllMsgsAcked) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] can ack message to broker {}, acktype {}, cardinality {}, length {}", new Object[]{this.subscription, this.consumerName, batchMessageId, ackType, outstandingAcks, batchSize});
            }
            return true;
        }
        if (PulsarApi.CommandAck.AckType.Cumulative == ackType && !batchMessageId.getAcker().isPrevBatchCumulativelyAcked()) {
            this.sendAcknowledge(batchMessageId.prevBatchMessageId(), PulsarApi.CommandAck.AckType.Cumulative, properties);
            batchMessageId.getAcker().setPrevBatchCumulativelyAcked(true);
        } else {
            this.onAcknowledge(batchMessageId, null);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] cannot ack message to broker {}, acktype {}, pending acks - {}", new Object[]{this.subscription, this.consumerName, batchMessageId, ackType, outstandingAcks});
        }
        return false;
    }

    @Override
    protected CompletableFuture<Void> doAcknowledge(MessageId messageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties) {
        Preconditions.checkArgument(messageId instanceof MessageIdImpl);
        if (this.getState() != HandlerState.State.Ready && this.getState() != HandlerState.State.Connecting) {
            this.stats.incrementNumAcksFailed();
            PulsarClientException exception = new PulsarClientException("Consumer not ready. State: " + (Object)((Object)this.getState()));
            if (PulsarApi.CommandAck.AckType.Individual.equals((Object)ackType)) {
                this.onAcknowledge(messageId, exception);
            } else if (PulsarApi.CommandAck.AckType.Cumulative.equals((Object)ackType)) {
                this.onAcknowledgeCumulative(messageId, exception);
            }
            return FutureUtil.failedFuture(exception);
        }
        if (messageId instanceof BatchMessageIdImpl) {
            if (this.markAckForBatchMessage((BatchMessageIdImpl)messageId, ackType, properties)) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] acknowledging message - {}, acktype {}", new Object[]{this.subscription, this.consumerName, messageId, ackType});
                }
            } else {
                return CompletableFuture.completedFuture(null);
            }
        }
        return this.sendAcknowledge(messageId, ackType, properties);
    }

    private CompletableFuture<Void> sendAcknowledge(MessageId messageId, PulsarApi.CommandAck.AckType ackType, Map<String, Long> properties) {
        MessageIdImpl msgId = (MessageIdImpl)messageId;
        if (ackType == PulsarApi.CommandAck.AckType.Individual) {
            if (messageId instanceof BatchMessageIdImpl) {
                BatchMessageIdImpl batchMessageId = (BatchMessageIdImpl)messageId;
                this.stats.incrementNumAcksSent(batchMessageId.getBatchSize());
                this.unAckedMessageTracker.remove(new MessageIdImpl(batchMessageId.getLedgerId(), batchMessageId.getEntryId(), batchMessageId.getPartitionIndex()));
                if (this.possibleSendToDeadLetterTopicMessages != null) {
                    this.possibleSendToDeadLetterTopicMessages.remove(new MessageIdImpl(batchMessageId.getLedgerId(), batchMessageId.getEntryId(), batchMessageId.getPartitionIndex()));
                }
            } else {
                this.unAckedMessageTracker.remove(msgId);
                if (this.possibleSendToDeadLetterTopicMessages != null) {
                    this.possibleSendToDeadLetterTopicMessages.remove(msgId);
                }
                this.stats.incrementNumAcksSent(1L);
            }
            this.onAcknowledge(messageId, null);
        } else if (ackType == PulsarApi.CommandAck.AckType.Cumulative) {
            this.onAcknowledgeCumulative(messageId, null);
            this.stats.incrementNumAcksSent(this.unAckedMessageTracker.removeMessagesTill(msgId));
        }
        this.acknowledgmentsGroupingTracker.addAcknowledgment(msgId, ackType, properties);
        return CompletableFuture.completedFuture(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionOpened(ClientCnx cnx) {
        PulsarApi.MessageIdData startMessageIdData;
        boolean isDurable;
        int currentSize;
        this.setClientCnx(cnx);
        cnx.registerConsumer(this.consumerId, this);
        log.info("[{}][{}] Subscribing to topic on cnx {}", new Object[]{this.topic, this.subscription, cnx.ctx().channel()});
        long requestId = this.client.newRequestId();
        ConsumerImpl consumerImpl = this;
        synchronized (consumerImpl) {
            currentSize = this.incomingMessages.size();
            this.startMessageId = this.clearReceiverQueue();
            if (this.possibleSendToDeadLetterTopicMessages != null) {
                this.possibleSendToDeadLetterTopicMessages.clear();
            }
        }
        boolean bl = isDurable = this.subscriptionMode == SubscriptionMode.Durable;
        if (isDurable) {
            startMessageIdData = null;
        } else {
            PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
            builder.setLedgerId(this.startMessageId.getLedgerId());
            builder.setEntryId(this.startMessageId.getEntryId());
            if (this.startMessageId instanceof BatchMessageIdImpl) {
                builder.setBatchIndex(this.startMessageId.getBatchIndex());
            }
            startMessageIdData = builder.build();
            builder.recycle();
        }
        SchemaInfo si = this.schema.getSchemaInfo();
        if (si != null && (SchemaType.BYTES == si.getType() || SchemaType.NONE == si.getType())) {
            si = null;
        }
        ByteBuf request = Commands.newSubscribe(this.topic, this.subscription, this.consumerId, requestId, this.getSubType(), this.priorityLevel, this.consumerName, isDurable, startMessageIdData, this.metadata, this.readCompacted, PulsarApi.CommandSubscribe.InitialPosition.valueOf(this.subscriptionInitialPosition.getValue()), si);
        if (startMessageIdData != null) {
            startMessageIdData.recycle();
        }
        ((CompletableFuture)cnx.sendRequestWithId(request, requestId).thenRun(() -> {
            ConsumerImpl consumerImpl = this;
            synchronized (consumerImpl) {
                if (this.changeToReadyState()) {
                    log.info("[{}][{}] Subscribed to topic on {} -- consumer: {}", new Object[]{this.topic, this.subscription, cnx.channel().remoteAddress(), this.consumerId});
                    AVAILABLE_PERMITS_UPDATER.set(this, 0);
                    if (this.waitingOnReceiveForZeroQueueSize || this.conf.getReceiverQueueSize() == 0 && (currentSize > 0 || this.listener != null)) {
                        this.sendFlowPermitsToBroker(cnx, 1);
                    }
                } else {
                    this.setState(HandlerState.State.Closed);
                    cnx.removeConsumer(this.consumerId);
                    cnx.channel().close();
                    return;
                }
            }
            this.resetBackoff();
            boolean firstTimeConnect = this.subscribeFuture.complete(this);
            if (!(firstTimeConnect && this.partitionIndex > -1 && isDurable || this.conf.getReceiverQueueSize() == 0)) {
                this.sendFlowPermitsToBroker(cnx, this.conf.getReceiverQueueSize());
            }
        })).exceptionally(e -> {
            cnx.removeConsumer(this.consumerId);
            if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
                cnx.channel().close();
                return null;
            }
            log.warn("[{}][{}] Failed to subscribe to topic on {}", new Object[]{this.topic, this.subscription, cnx.channel().remoteAddress()});
            if (e.getCause() instanceof PulsarClientException && this.getConnectionHandler().isRetriableError((PulsarClientException)e.getCause()) && System.currentTimeMillis() < this.subscribeTimeout) {
                this.reconnectLater(e.getCause());
                return null;
            }
            if (!this.subscribeFuture.isDone()) {
                this.setState(HandlerState.State.Failed);
                this.subscribeFuture.completeExceptionally((Throwable)e);
                this.client.cleanupConsumer(this);
            } else {
                this.reconnectLater(e.getCause());
            }
            return null;
        });
    }

    private BatchMessageIdImpl clearReceiverQueue() {
        ArrayList currentMessageQueue = new ArrayList(this.incomingMessages.size());
        this.incomingMessages.drainTo(currentMessageQueue);
        if (!currentMessageQueue.isEmpty()) {
            MessageIdImpl nextMessageInQueue = (MessageIdImpl)((Message)currentMessageQueue.get(0)).getMessageId();
            BatchMessageIdImpl previousMessage = nextMessageInQueue instanceof BatchMessageIdImpl ? new BatchMessageIdImpl(nextMessageInQueue.getLedgerId(), nextMessageInQueue.getEntryId(), nextMessageInQueue.getPartitionIndex(), ((BatchMessageIdImpl)nextMessageInQueue).getBatchIndex() - 1) : new BatchMessageIdImpl(nextMessageInQueue.getLedgerId(), nextMessageInQueue.getEntryId() - 1L, nextMessageInQueue.getPartitionIndex(), -1);
            return previousMessage;
        }
        if (!this.lastDequeuedMessage.equals(MessageId.earliest)) {
            return new BatchMessageIdImpl((MessageIdImpl)this.lastDequeuedMessage);
        }
        return this.startMessageId;
    }

    void sendFlowPermitsToBroker(ClientCnx cnx, int numMessages) {
        if (cnx != null) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] Adding {} additional permits", new Object[]{this.topic, this.subscription, numMessages});
            }
            cnx.ctx().writeAndFlush(Commands.newFlow(this.consumerId, numMessages), cnx.ctx().voidPromise());
        }
    }

    @Override
    public void connectionFailed(PulsarClientException exception) {
        if (System.currentTimeMillis() > this.subscribeTimeout && this.subscribeFuture.completeExceptionally(exception)) {
            this.setState(HandlerState.State.Failed);
            log.info("[{}] Consumer creation failed for consumer {}", (Object)this.topic, (Object)this.consumerId);
            this.client.cleanupConsumer(this);
        }
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        if (!this.shouldTearDown()) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            this.unAckedMessageTracker.close();
            if (this.possibleSendToDeadLetterTopicMessages != null) {
                this.possibleSendToDeadLetterTopicMessages.clear();
            }
            return CompletableFuture.completedFuture(null);
        }
        if (!this.isConnected()) {
            log.info("[{}] [{}] Closed Consumer (not connected)", (Object)this.topic, (Object)this.subscription);
            this.setState(HandlerState.State.Closed);
            this.unAckedMessageTracker.close();
            if (this.possibleSendToDeadLetterTopicMessages != null) {
                this.possibleSendToDeadLetterTopicMessages.clear();
            }
            this.client.cleanupConsumer(this);
            return CompletableFuture.completedFuture(null);
        }
        this.stats.getStatTimeout().ifPresent(Timeout::cancel);
        this.setState(HandlerState.State.Closing);
        this.acknowledgmentsGroupingTracker.close();
        long requestId = this.client.newRequestId();
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        ClientCnx cnx = this.cnx();
        if (null == cnx) {
            this.cleanupAtClose(closeFuture);
        } else {
            ByteBuf cmd = Commands.newCloseConsumer(this.consumerId, requestId);
            cnx.sendRequestWithId(cmd, requestId).handle((v, exception) -> {
                cnx.removeConsumer(this.consumerId);
                if (exception == null || !cnx.ctx().channel().isActive()) {
                    this.cleanupAtClose(closeFuture);
                } else {
                    closeFuture.completeExceptionally((Throwable)exception);
                }
                return null;
            });
        }
        return closeFuture;
    }

    private void cleanupAtClose(CompletableFuture<Void> closeFuture) {
        log.info("[{}] [{}] Closed consumer", (Object)this.topic, (Object)this.subscription);
        this.setState(HandlerState.State.Closed);
        this.unAckedMessageTracker.close();
        if (this.possibleSendToDeadLetterTopicMessages != null) {
            this.possibleSendToDeadLetterTopicMessages.clear();
        }
        closeFuture.complete(null);
        this.client.cleanupConsumer(this);
        this.failPendingReceive();
    }

    private void failPendingReceive() {
        this.lock.readLock().lock();
        try {
            if (this.listenerExecutor != null && !this.listenerExecutor.isShutdown()) {
                CompletableFuture receiveFuture;
                while (!this.pendingReceives.isEmpty() && (receiveFuture = (CompletableFuture)this.pendingReceives.poll()) != null) {
                    receiveFuture.completeExceptionally(new PulsarClientException.AlreadyClosedException("Consumer is already closed"));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    void activeConsumerChanged(boolean isActive) {
        if (this.consumerEventListener == null) {
            return;
        }
        this.listenerExecutor.execute(() -> {
            if (isActive) {
                this.consumerEventListener.becameActive(this, this.partitionIndex);
            } else {
                this.consumerEventListener.becameInactive(this, this.partitionIndex);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void messageReceived(PulsarApi.MessageIdData messageId, int redeliveryCount, ByteBuf headersAndPayload, ClientCnx cnx) {
        if (ConsumerImpl.log.isDebugEnabled()) {
            ConsumerImpl.log.debug("[{}][{}] Received message: {}/{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId()});
        }
        msgMetadata = null;
        payload = headersAndPayload;
        if (!this.verifyChecksum(headersAndPayload, messageId)) {
            this.discardCorruptedMessage(messageId, cnx, PulsarApi.CommandAck.ValidationError.ChecksumMismatch);
            return;
        }
        try {
            msgMetadata = Commands.parseMessageMetadata(payload);
        }
        catch (Throwable t) {
            this.discardCorruptedMessage(messageId, cnx, PulsarApi.CommandAck.ValidationError.ChecksumMismatch);
            return;
        }
        numMessages = msgMetadata.getNumMessagesInBatch();
        msgId = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        if (this.acknowledgmentsGroupingTracker.isDuplicate(msgId)) {
            if (ConsumerImpl.log.isDebugEnabled()) {
                ConsumerImpl.log.debug("[{}][{}] Ignoring message as it was already being acked earlier by same consumer {}/{}", new Object[]{this.topic, this.subscription, msgId});
            }
            this.increaseAvailablePermits(cnx, numMessages);
            return;
        }
        decryptedPayload = this.decryptPayloadIfNeeded(messageId, msgMetadata, payload, cnx);
        isMessageUndecryptable = this.isMessageUndecryptable(msgMetadata);
        if (decryptedPayload == null) {
            return;
        }
        uncompressedPayload = isMessageUndecryptable != false ? decryptedPayload.retain() : this.uncompressPayloadIfNeeded(messageId, msgMetadata, decryptedPayload, cnx);
        decryptedPayload.release();
        if (uncompressedPayload == null) {
            return;
        }
        if (isMessageUndecryptable || numMessages == 1 && !msgMetadata.hasNumMessagesInBatch()) {
            message = new MessageImpl<T>(this.topicName.toString(), msgId, msgMetadata, uncompressedPayload, this.createEncryptionContext(msgMetadata), cnx, this.schema, redeliveryCount);
            uncompressedPayload.release();
            msgMetadata.recycle();
            this.lock.readLock().lock();
            try {
                if (this.deadLetterPolicy != null && this.possibleSendToDeadLetterTopicMessages != null && redeliveryCount >= this.deadLetterPolicy.getMaxRedeliverCount()) {
                    this.possibleSendToDeadLetterTopicMessages.put((MessageIdImpl)message.getMessageId(), Collections.singletonList(message));
                }
                if (!this.pendingReceives.isEmpty()) {
                    this.trackMessage(message);
                    this.notifyPendingReceivedCallback(message, null);
                }
                if (this.conf.getReceiverQueueSize() != 0 || this.waitingOnReceiveForZeroQueueSize) {
                    this.incomingMessages.add(message);
                }
                if (this.conf.getReceiverQueueSize() != 0 || this.listener == null) ** GOTO lbl63
                this.triggerZeroQueueSizeListener(message);
            }
            finally {
                this.lock.readLock().unlock();
            }
        } else {
            if (this.conf.getReceiverQueueSize() == 0) {
                ConsumerImpl.log.warn("Closing consumer [{}]-[{}] due to unsupported received batch-message with zero receiver queue size", (Object)this.subscription, (Object)this.consumerName);
                this.closeAsync().handle((BiFunction<Void, Throwable, Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$messageReceived$6(java.lang.Void java.lang.Throwable ), (Ljava/lang/Void;Ljava/lang/Throwable;)Ljava/lang/Object;)((ConsumerImpl)this));
            } else {
                this.receiveIndividualMessagesFromBatch(msgMetadata, redeliveryCount, uncompressedPayload, messageId, cnx);
            }
            uncompressedPayload.release();
            msgMetadata.recycle();
        }
lbl63:
        // 5 sources

        if (this.listener != null && this.conf.getReceiverQueueSize() != 0) {
            this.listenerExecutor.execute((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$messageReceived$7(int ), ()V)((ConsumerImpl)this, (int)numMessages));
        }
    }

    void notifyPendingReceivedCallback(Message<T> message, Exception exception) {
        if (this.pendingReceives.isEmpty()) {
            return;
        }
        CompletableFuture receivedFuture = (CompletableFuture)this.pendingReceives.poll();
        if (receivedFuture == null) {
            return;
        }
        if (exception != null) {
            this.listenerExecutor.execute(() -> receivedFuture.completeExceptionally(exception));
            return;
        }
        if (message == null) {
            IllegalStateException e = new IllegalStateException("received message can't be null");
            this.listenerExecutor.execute(() -> receivedFuture.completeExceptionally(e));
            return;
        }
        if (this.conf.getReceiverQueueSize() == 0) {
            this.interceptAndComplete(message, receivedFuture);
            return;
        }
        this.messageProcessed(message);
        this.interceptAndComplete(message, receivedFuture);
    }

    private void interceptAndComplete(Message<T> message, CompletableFuture<Message<T>> receivedFuture) {
        Message interceptMessage = this.beforeConsume(message);
        this.listenerExecutor.execute(() -> receivedFuture.complete(interceptMessage));
    }

    private void triggerZeroQueueSizeListener(Message<T> message) {
        Preconditions.checkArgument(this.conf.getReceiverQueueSize() == 0);
        Preconditions.checkNotNull(this.listener, "listener can't be null");
        Preconditions.checkNotNull(message, "unqueued message can't be null");
        this.listenerExecutor.execute(() -> {
            this.stats.updateNumMsgsReceived(message);
            try {
                if (log.isDebugEnabled()) {
                    log.debug("[{}][{}] Calling message listener for unqueued message {}", new Object[]{this.topic, this.subscription, message.getMessageId()});
                }
                this.listener.received(this, message);
            }
            catch (Throwable t) {
                log.error("[{}][{}] Message listener error in processing unqueued message: {}", new Object[]{this.topic, this.subscription, message.getMessageId(), t});
            }
            this.increaseAvailablePermits(this.cnx());
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveIndividualMessagesFromBatch(PulsarApi.MessageMetadata msgMetadata, int redeliveryCount, ByteBuf uncompressedPayload, PulsarApi.MessageIdData messageId, ClientCnx cnx) {
        int batchSize = msgMetadata.getNumMessagesInBatch();
        MessageIdImpl batchMessage = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        BatchMessageAcker acker = BatchMessageAcker.newAcker(batchSize);
        ArrayList possibleToDeadLetter = null;
        if (this.deadLetterPolicy != null && redeliveryCount >= this.deadLetterPolicy.getMaxRedeliverCount()) {
            possibleToDeadLetter = new ArrayList();
        }
        int skippedMessages = 0;
        try {
            for (int i = 0; i < batchSize; ++i) {
                if (log.isDebugEnabled()) {
                    log.debug("[{}] [{}] processing message num - {} in batch", new Object[]{this.subscription, this.consumerName, i});
                }
                PulsarApi.SingleMessageMetadata.Builder singleMessageMetadataBuilder = PulsarApi.SingleMessageMetadata.newBuilder();
                ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch(uncompressedPayload, singleMessageMetadataBuilder, i, batchSize);
                if (this.subscriptionMode == SubscriptionMode.NonDurable && this.startMessageId != null && messageId.getLedgerId() == this.startMessageId.getLedgerId() && messageId.getEntryId() == this.startMessageId.getEntryId() && i <= this.startMessageId.getBatchIndex()) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] [{}] Ignoring message from before the startMessageId", (Object)this.subscription, (Object)this.consumerName);
                    }
                    ++skippedMessages;
                    continue;
                }
                if (singleMessageMetadataBuilder.getCompactedOut()) {
                    singleMessagePayload.release();
                    singleMessageMetadataBuilder.recycle();
                    ++skippedMessages;
                    continue;
                }
                BatchMessageIdImpl batchMessageIdImpl = new BatchMessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex(), i, acker);
                MessageImpl message = new MessageImpl(this.topicName.toString(), batchMessageIdImpl, msgMetadata, singleMessageMetadataBuilder.build(), singleMessagePayload, this.createEncryptionContext(msgMetadata), cnx, this.schema, redeliveryCount);
                if (possibleToDeadLetter != null) {
                    possibleToDeadLetter.add(message);
                }
                this.lock.readLock().lock();
                try {
                    if (this.pendingReceives.isEmpty()) {
                        this.incomingMessages.add(message);
                    } else {
                        this.notifyPendingReceivedCallback(message, null);
                    }
                }
                finally {
                    this.lock.readLock().unlock();
                }
                singleMessagePayload.release();
                singleMessageMetadataBuilder.recycle();
            }
        }
        catch (IOException e) {
            log.warn("[{}] [{}] unable to obtain message in batch", (Object)this.subscription, (Object)this.consumerName);
            this.discardCorruptedMessage(messageId, cnx, PulsarApi.CommandAck.ValidationError.BatchDeSerializeError);
        }
        if (possibleToDeadLetter != null && this.possibleSendToDeadLetterTopicMessages != null) {
            this.possibleSendToDeadLetterTopicMessages.put(batchMessage, possibleToDeadLetter);
        }
        if (log.isDebugEnabled()) {
            log.debug("[{}] [{}] enqueued messages in batch. queue size - {}, available queue size - {}", new Object[]{this.subscription, this.consumerName, this.incomingMessages.size(), this.incomingMessages.remainingCapacity()});
        }
        if (skippedMessages > 0) {
            this.increaseAvailablePermits(cnx, skippedMessages);
        }
    }

    protected synchronized void messageProcessed(Message<?> msg) {
        ClientCnx currentCnx = this.cnx();
        ClientCnx msgCnx = ((MessageImpl)msg).getCnx();
        this.lastDequeuedMessage = msg.getMessageId();
        if (msgCnx != currentCnx) {
            return;
        }
        this.increaseAvailablePermits(currentCnx);
        this.stats.updateNumMsgsReceived(msg);
        if (this.conf.getAckTimeoutMillis() != 0L) {
            MessageIdImpl id = (MessageIdImpl)msg.getMessageId();
            if (id instanceof BatchMessageIdImpl) {
                id = new MessageIdImpl(id.getLedgerId(), id.getEntryId(), this.getPartitionIndex());
            }
            if (this.partitionIndex != -1) {
                this.unAckedMessageTracker.remove(id);
            } else {
                this.unAckedMessageTracker.add(id);
            }
        }
    }

    protected void trackMessage(Message<?> msg) {
        if (msg != null) {
            MessageId messageId = msg.getMessageId();
            if (this.conf.getAckTimeoutMillis() > 0L && messageId instanceof MessageIdImpl) {
                MessageIdImpl id = (MessageIdImpl)messageId;
                if (id instanceof BatchMessageIdImpl) {
                    id = new MessageIdImpl(id.getLedgerId(), id.getEntryId(), this.getPartitionIndex());
                }
                this.unAckedMessageTracker.add(id);
            }
        }
    }

    void increaseAvailablePermits(ClientCnx currentCnx) {
        this.increaseAvailablePermits(currentCnx, 1);
    }

    private void increaseAvailablePermits(ClientCnx currentCnx, int delta) {
        int available = AVAILABLE_PERMITS_UPDATER.addAndGet(this, delta);
        while (available >= this.receiverQueueRefillThreshold && !this.paused) {
            if (AVAILABLE_PERMITS_UPDATER.compareAndSet(this, available, 0)) {
                this.sendFlowPermitsToBroker(currentCnx, available);
                break;
            }
            available = AVAILABLE_PERMITS_UPDATER.get(this);
        }
    }

    @Override
    public void pause() {
        this.paused = true;
    }

    @Override
    public void resume() {
        if (this.paused) {
            this.paused = false;
            this.increaseAvailablePermits(this.cnx(), 0);
        }
    }

    private ByteBuf decryptPayloadIfNeeded(PulsarApi.MessageIdData messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, ClientCnx currentCnx) {
        ByteBuf decryptedData;
        if (msgMetadata.getEncryptionKeysCount() == 0) {
            return payload.retain();
        }
        if (this.conf.getCryptoKeyReader() == null) {
            switch (this.conf.getCryptoFailureAction()) {
                case CONSUME: {
                    log.warn("[{}][{}][{}] CryptoKeyReader interface is not implemented. Consuming encrypted message.", new Object[]{this.topic, this.subscription, this.consumerName});
                    return payload.retain();
                }
                case DISCARD: {
                    log.warn("[{}][{}][{}] Skipping decryption since CryptoKeyReader interface is not implemented and config is set to discard", new Object[]{this.topic, this.subscription, this.consumerName});
                    this.discardMessage(messageId, currentCnx, PulsarApi.CommandAck.ValidationError.DecryptionError);
                    return null;
                }
                case FAIL: {
                    MessageIdImpl m = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.partitionIndex);
                    log.error("[{}][{}][{}][{}] Message delivery failed since CryptoKeyReader interface is not implemented to consume encrypted message", new Object[]{this.topic, this.subscription, this.consumerName, m});
                    this.unAckedMessageTracker.add(m);
                    return null;
                }
            }
        }
        if ((decryptedData = this.msgCrypto.decrypt(msgMetadata, payload, this.conf.getCryptoKeyReader())) != null) {
            return decryptedData;
        }
        switch (this.conf.getCryptoFailureAction()) {
            case CONSUME: {
                log.warn("[{}][{}][{}][{}] Decryption failed. Consuming encrypted message since config is set to consume.", new Object[]{this.topic, this.subscription, this.consumerName, messageId});
                return payload.retain();
            }
            case DISCARD: {
                log.warn("[{}][{}][{}][{}] Discarding message since decryption failed and config is set to discard", new Object[]{this.topic, this.subscription, this.consumerName, messageId});
                this.discardMessage(messageId, currentCnx, PulsarApi.CommandAck.ValidationError.DecryptionError);
                return null;
            }
            case FAIL: {
                MessageIdImpl m = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.partitionIndex);
                log.error("[{}][{}][{}][{}] Message delivery failed since unable to decrypt incoming message", new Object[]{this.topic, this.subscription, this.consumerName, m});
                this.unAckedMessageTracker.add(m);
                return null;
            }
        }
        return null;
    }

    private ByteBuf uncompressPayloadIfNeeded(PulsarApi.MessageIdData messageId, PulsarApi.MessageMetadata msgMetadata, ByteBuf payload, ClientCnx currentCnx) {
        PulsarApi.CompressionType compressionType = msgMetadata.getCompression();
        CompressionCodec codec = CompressionCodecProvider.getCompressionCodec(compressionType);
        int uncompressedSize = msgMetadata.getUncompressedSize();
        int payloadSize = payload.readableBytes();
        if (payloadSize > 5232640) {
            log.error("[{}][{}] Got corrupted payload message size {} at {}", new Object[]{this.topic, this.subscription, payloadSize, messageId});
            this.discardCorruptedMessage(messageId, currentCnx, PulsarApi.CommandAck.ValidationError.UncompressedSizeCorruption);
            return null;
        }
        try {
            ByteBuf uncompressedPayload = codec.decode(payload, uncompressedSize);
            return uncompressedPayload;
        }
        catch (IOException e) {
            log.error("[{}][{}] Failed to decompress message with {} at {}: {}", new Object[]{this.topic, this.subscription, compressionType, messageId, e.getMessage(), e});
            this.discardCorruptedMessage(messageId, currentCnx, PulsarApi.CommandAck.ValidationError.DecompressionError);
            return null;
        }
    }

    private boolean verifyChecksum(ByteBuf headersAndPayload, PulsarApi.MessageIdData messageId) {
        int computedChecksum;
        int checksum;
        if (Commands.hasChecksum(headersAndPayload) && (checksum = Commands.readChecksum(headersAndPayload)) != (computedChecksum = Crc32cIntChecksum.computeChecksum(headersAndPayload))) {
            log.error("[{}][{}] Checksum mismatch for message at {}:{}. Received checksum: 0x{}, Computed checksum: 0x{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId(), Long.toHexString(checksum), Integer.toHexString(computedChecksum)});
            return false;
        }
        return true;
    }

    private void discardCorruptedMessage(PulsarApi.MessageIdData messageId, ClientCnx currentCnx, PulsarApi.CommandAck.ValidationError validationError) {
        log.error("[{}][{}] Discarding corrupted message at {}:{}", new Object[]{this.topic, this.subscription, messageId.getLedgerId(), messageId.getEntryId()});
        this.discardMessage(messageId, currentCnx, validationError);
    }

    private void discardMessage(PulsarApi.MessageIdData messageId, ClientCnx currentCnx, PulsarApi.CommandAck.ValidationError validationError) {
        ByteBuf cmd = Commands.newAck(this.consumerId, messageId.getLedgerId(), messageId.getEntryId(), PulsarApi.CommandAck.AckType.Individual, validationError, Collections.emptyMap());
        currentCnx.ctx().writeAndFlush(cmd, currentCnx.ctx().voidPromise());
        this.increaseAvailablePermits(currentCnx);
        this.stats.incrementNumReceiveFailed();
    }

    @Override
    String getHandlerName() {
        return this.subscription;
    }

    @Override
    public boolean isConnected() {
        return this.getClientCnx() != null && this.getState() == HandlerState.State.Ready;
    }

    int getPartitionIndex() {
        return this.partitionIndex;
    }

    @Override
    public int getAvailablePermits() {
        return AVAILABLE_PERMITS_UPDATER.get(this);
    }

    @Override
    public int numMessagesInQueue() {
        return this.incomingMessages.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redeliverUnacknowledgedMessages() {
        ClientCnx cnx = this.cnx();
        if (this.isConnected() && cnx.getRemoteEndpointProtocolVersion() >= PulsarApi.ProtocolVersion.v2.getNumber()) {
            int currentSize = 0;
            ConsumerImpl consumerImpl = this;
            synchronized (consumerImpl) {
                currentSize = this.incomingMessages.size();
                this.incomingMessages.clear();
                this.unAckedMessageTracker.clear();
            }
            cnx.ctx().writeAndFlush(Commands.newRedeliverUnacknowledgedMessages(this.consumerId), cnx.ctx().voidPromise());
            if (currentSize > 0) {
                this.increaseAvailablePermits(cnx, currentSize);
            }
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] [{}] Redeliver unacked messages and send {} permits", new Object[]{this.subscription, this.topic, this.consumerName, currentSize});
            }
            return;
        }
        if (cnx == null || this.getState() == HandlerState.State.Connecting) {
            log.warn("[{}] Client Connection needs to be established for redelivery of unacknowledged messages", (Object)this);
        } else {
            log.warn("[{}] Reconnecting the client to redeliver the messages.", (Object)this);
            cnx.ctx().close();
        }
    }

    @Override
    public void redeliverUnacknowledgedMessages(Set<MessageId> messageIds) {
        Preconditions.checkArgument(messageIds.stream().findFirst().get() instanceof MessageIdImpl);
        if (this.conf.getSubscriptionType() != SubscriptionType.Shared) {
            this.redeliverUnacknowledgedMessages();
            return;
        }
        ClientCnx cnx = this.cnx();
        if (this.isConnected() && cnx.getRemoteEndpointProtocolVersion() >= PulsarApi.ProtocolVersion.v2.getNumber()) {
            int messagesFromQueue = this.removeExpiredMessagesFromQueue(messageIds);
            Iterable<List<List>> batches = Iterables.partition(messageIds.stream().map(messageId -> (MessageIdImpl)messageId).collect(Collectors.toSet()), 1000);
            PulsarApi.MessageIdData.Builder builder = PulsarApi.MessageIdData.newBuilder();
            batches.forEach(ids -> {
                List<PulsarApi.MessageIdData> messageIdDatas = ids.stream().map(messageId -> {
                    this.processPossibleToDLQ((MessageIdImpl)messageId);
                    builder.setPartition(messageId.getPartitionIndex());
                    builder.setLedgerId(messageId.getLedgerId());
                    builder.setEntryId(messageId.getEntryId());
                    return builder.build();
                }).collect(Collectors.toList());
                ByteBuf cmd = Commands.newRedeliverUnacknowledgedMessages(this.consumerId, messageIdDatas);
                cnx.ctx().writeAndFlush(cmd, cnx.ctx().voidPromise());
                messageIdDatas.forEach(PulsarApi.MessageIdData::recycle);
            });
            if (messagesFromQueue > 0) {
                this.increaseAvailablePermits(cnx, messagesFromQueue);
            }
            builder.recycle();
            if (log.isDebugEnabled()) {
                log.debug("[{}] [{}] [{}] Redeliver unacked messages and increase {} permits", new Object[]{this.subscription, this.topic, this.consumerName, messagesFromQueue});
            }
            return;
        }
        if (cnx == null || this.getState() == HandlerState.State.Connecting) {
            log.warn("[{}] Client Connection needs to be established for redelivery of unacknowledged messages", (Object)this);
        } else {
            log.warn("[{}] Reconnecting the client to redeliver the messages.", (Object)this);
            cnx.ctx().close();
        }
    }

    private void processPossibleToDLQ(MessageIdImpl messageId) {
        List<MessageImpl<T>> deadLetterMessages = null;
        if (this.possibleSendToDeadLetterTopicMessages != null) {
            deadLetterMessages = messageId instanceof BatchMessageIdImpl ? this.possibleSendToDeadLetterTopicMessages.get(new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex())) : this.possibleSendToDeadLetterTopicMessages.get(messageId);
        }
        if (deadLetterMessages != null) {
            if (this.deadLetterProducer == null) {
                try {
                    this.deadLetterProducer = this.client.newProducer(this.schema).topic(this.deadLetterPolicy.getDeadLetterTopic()).blockIfQueueFull(false).create();
                }
                catch (Exception e) {
                    log.error("Create dead letter producer exception with topic: {}", (Object)this.deadLetterPolicy.getDeadLetterTopic(), (Object)e);
                }
            }
            if (this.deadLetterProducer != null) {
                try {
                    for (MessageImpl<T> message : deadLetterMessages) {
                        this.deadLetterProducer.newMessage().value(message.getValue()).properties(message.getProperties()).send();
                    }
                    this.acknowledge(messageId);
                }
                catch (Exception e) {
                    log.error("Send to dead letter topic exception with topic: {}, messageId: {}", new Object[]{this.deadLetterProducer.getTopic(), messageId, e});
                }
            }
        }
    }

    @Override
    public void seek(MessageId messageId) throws PulsarClientException {
        try {
            this.seekAsync(messageId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PulsarClientException(e);
        }
    }

    @Override
    public CompletableFuture<Void> seekAsync(MessageId messageId) {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Consumer was already closed"));
        }
        if (!this.isConnected()) {
            return FutureUtil.failedFuture(new PulsarClientException("Not connected to broker"));
        }
        CompletableFuture<Void> seekFuture = new CompletableFuture<Void>();
        long requestId = this.client.newRequestId();
        MessageIdImpl msgId = (MessageIdImpl)messageId;
        ByteBuf seek = Commands.newSeek(this.consumerId, requestId, msgId.getLedgerId(), msgId.getEntryId());
        ClientCnx cnx = this.cnx();
        log.info("[{}][{}] Seek subscription to message id {}", new Object[]{this.topic, this.subscription, messageId});
        ((CompletableFuture)cnx.sendRequestWithId(seek, requestId).thenRun(() -> {
            log.info("[{}][{}] Successfully reset subscription to message id {}", new Object[]{this.topic, this.subscription, messageId});
            seekFuture.complete(null);
        })).exceptionally(e -> {
            log.error("[{}][{}] Failed to reset subscription: {}", new Object[]{this.topic, this.subscription, e.getCause().getMessage()});
            seekFuture.completeExceptionally(e.getCause());
            return null;
        });
        return seekFuture;
    }

    public boolean hasMessageAvailable() throws PulsarClientException {
        try {
            if (this.hasMoreMessages(this.lastMessageIdInBroker, this.lastDequeuedMessage)) {
                return true;
            }
            return this.hasMessageAvailableAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PulsarClientException(e);
        }
    }

    public CompletableFuture<Boolean> hasMessageAvailableAsync() {
        CompletableFuture<Boolean> booleanFuture = new CompletableFuture<Boolean>();
        if (this.hasMoreMessages(this.lastMessageIdInBroker, this.lastDequeuedMessage)) {
            booleanFuture.complete(true);
        } else {
            ((CompletableFuture)this.getLastMessageIdAsync().thenAccept(messageId -> {
                this.lastMessageIdInBroker = messageId;
                if (this.hasMoreMessages(this.lastMessageIdInBroker, this.lastDequeuedMessage)) {
                    booleanFuture.complete(true);
                } else {
                    booleanFuture.complete(false);
                }
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                booleanFuture.completeExceptionally(e.getCause());
                return null;
            });
        }
        return booleanFuture;
    }

    private boolean hasMoreMessages(MessageId lastMessageIdInBroker, MessageId lastDequeuedMessage) {
        if (lastMessageIdInBroker.compareTo(lastDequeuedMessage) > 0 && ((MessageIdImpl)lastMessageIdInBroker).getEntryId() != -1L) {
            return true;
        }
        return lastMessageIdInBroker.compareTo(lastDequeuedMessage) == 0 && this.incomingMessages.size() > 0;
    }

    CompletableFuture<MessageId> getLastMessageIdAsync() {
        if (this.getState() == HandlerState.State.Closing || this.getState() == HandlerState.State.Closed) {
            return FutureUtil.failedFuture(new PulsarClientException.AlreadyClosedException("Consumer was already closed"));
        }
        AtomicLong opTimeoutMs = new AtomicLong(this.client.getConfiguration().getOperationTimeoutMs());
        Backoff backoff = new Backoff(100L, TimeUnit.MILLISECONDS, opTimeoutMs.get() * 2L, TimeUnit.MILLISECONDS, 0L, TimeUnit.MILLISECONDS);
        CompletableFuture<MessageId> getLastMessageIdFuture = new CompletableFuture<MessageId>();
        this.internalGetLastMessageIdAsync(backoff, opTimeoutMs, getLastMessageIdFuture);
        return getLastMessageIdFuture;
    }

    private void internalGetLastMessageIdAsync(Backoff backoff, AtomicLong remainingTime, CompletableFuture<MessageId> future) {
        ClientCnx cnx = this.cnx();
        if (this.isConnected() && cnx != null) {
            if (!Commands.peerSupportsGetLastMessageId(cnx.getRemoteEndpointProtocolVersion())) {
                future.completeExceptionally(new PulsarClientException.NotSupportedException("GetLastMessageId Not supported for ProtocolVersion: " + cnx.getRemoteEndpointProtocolVersion()));
            }
            long requestId = this.client.newRequestId();
            ByteBuf getLastIdCmd = Commands.newGetLastMessageId(this.consumerId, requestId);
            log.info("[{}][{}] Get topic last message Id", (Object)this.topic, (Object)this.subscription);
            ((CompletableFuture)cnx.sendGetLastMessageId(getLastIdCmd, requestId).thenAccept(result -> {
                log.info("[{}][{}] Successfully getLastMessageId {}:{}", new Object[]{this.topic, this.subscription, result.getLedgerId(), result.getEntryId()});
                future.complete(new MessageIdImpl(result.getLedgerId(), result.getEntryId(), result.getPartition()));
            })).exceptionally(e -> {
                log.error("[{}][{}] Failed getLastMessageId command", (Object)this.topic, (Object)this.subscription);
                future.completeExceptionally(e.getCause());
                return null;
            });
        } else {
            long nextDelay = Math.min(backoff.next(), remainingTime.get());
            if (nextDelay <= 0L) {
                future.completeExceptionally(new PulsarClientException.TimeoutException("Could not getLastMessageId within configured timeout."));
                return;
            }
            ((ScheduledExecutorService)this.listenerExecutor).schedule(() -> {
                log.warn("[{}] [{}] Could not get connection while getLastMessageId -- Will try again in {} ms", new Object[]{this.topic, this.getHandlerName(), nextDelay});
                remainingTime.addAndGet(-nextDelay);
                this.internalGetLastMessageIdAsync(backoff, remainingTime, future);
            }, nextDelay, TimeUnit.MILLISECONDS);
        }
    }

    private MessageIdImpl getMessageIdImpl(Message<?> msg) {
        MessageIdImpl messageId = (MessageIdImpl)msg.getMessageId();
        if (messageId instanceof BatchMessageIdImpl) {
            messageId = new MessageIdImpl(messageId.getLedgerId(), messageId.getEntryId(), this.getPartitionIndex());
        }
        return messageId;
    }

    private boolean isMessageUndecryptable(PulsarApi.MessageMetadata msgMetadata) {
        return msgMetadata.getEncryptionKeysCount() > 0 && this.conf.getCryptoKeyReader() == null && this.conf.getCryptoFailureAction() == ConsumerCryptoFailureAction.CONSUME;
    }

    private Optional<EncryptionContext> createEncryptionContext(PulsarApi.MessageMetadata msgMetadata) {
        EncryptionContext encryptionCtx = null;
        if (msgMetadata.getEncryptionKeysCount() > 0) {
            encryptionCtx = new EncryptionContext();
            Map<String, EncryptionContext.EncryptionKey> keys = msgMetadata.getEncryptionKeysList().stream().collect(Collectors.toMap(PulsarApi.EncryptionKeys::getKey, e -> new EncryptionContext.EncryptionKey(e.getValue().toByteArray(), e.getMetadataList() != null ? e.getMetadataList().stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue)) : null)));
            byte[] encParam = new byte[12];
            msgMetadata.getEncryptionParam().copyTo(encParam, 0);
            Optional<Object> batchSize = Optional.ofNullable(msgMetadata.hasNumMessagesInBatch() ? Integer.valueOf(msgMetadata.getNumMessagesInBatch()) : null);
            encryptionCtx.setKeys(keys);
            encryptionCtx.setParam(encParam);
            encryptionCtx.setAlgorithm(msgMetadata.getEncryptionAlgo());
            encryptionCtx.setCompressionType(CompressionCodecProvider.convertFromWireProtocol(msgMetadata.getCompression()));
            encryptionCtx.setUncompressedMessageSize(msgMetadata.getUncompressedSize());
            encryptionCtx.setBatchSize(batchSize);
        }
        return Optional.ofNullable(encryptionCtx);
    }

    private int removeExpiredMessagesFromQueue(Set<MessageId> messageIds) {
        int messagesFromQueue = 0;
        Message peek = (Message)this.incomingMessages.peek();
        if (peek != null) {
            MessageIdImpl messageId = this.getMessageIdImpl(peek);
            if (!messageIds.contains(messageId)) {
                return 0;
            }
            Message message = (Message)this.incomingMessages.poll();
            while (message != null) {
                ++messagesFromQueue;
                MessageIdImpl id = this.getMessageIdImpl(message);
                if (!messageIds.contains(id)) {
                    messageIds.add(id);
                    break;
                }
                message = (Message)this.incomingMessages.poll();
            }
        }
        return messagesFromQueue;
    }

    @Override
    public ConsumerStats getStats() {
        return this.stats;
    }

    void setTerminated() {
        log.info("[{}] [{}] [{}] Consumer has reached the end of topic", new Object[]{this.subscription, this.topic, this.consumerName});
        this.hasReachedEndOfTopic = true;
        if (this.listener != null) {
            this.listener.reachedEndOfTopic(this);
        }
    }

    @Override
    public boolean hasReachedEndOfTopic() {
        return this.hasReachedEndOfTopic;
    }

    public int hashCode() {
        return Objects.hash(this.topic, this.subscription, this.consumerName);
    }

    ClientCnx cnx() {
        return this.connectionHandler.cnx();
    }

    void resetBackoff() {
        this.connectionHandler.resetBackoff();
    }

    void connectionClosed(ClientCnx cnx) {
        this.connectionHandler.connectionClosed(cnx);
    }

    @VisibleForTesting
    public ClientCnx getClientCnx() {
        return this.connectionHandler.getClientCnx();
    }

    void setClientCnx(ClientCnx clientCnx) {
        this.connectionHandler.setClientCnx(clientCnx);
    }

    void reconnectLater(Throwable exception) {
        this.connectionHandler.reconnectLater(exception);
    }

    void grabCnx() {
        this.connectionHandler.grabCnx();
    }

    public String getTopicNameWithoutPartition() {
        return this.topicNameWithoutPartition;
    }

    private /* synthetic */ void lambda$messageReceived$7(int numMessages) {
        for (int i = 0; i < numMessages; ++i) {
            try {
                Message<T> msg = this.internalReceive(0, TimeUnit.MILLISECONDS);
                if (msg == null) {
                    if (!log.isDebugEnabled()) break;
                    log.debug("[{}] [{}] Message has been cleared from the queue", (Object)this.topic, (Object)this.subscription);
                    break;
                }
                try {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}][{}] Calling message listener for message {}", new Object[]{this.topic, this.subscription, msg.getMessageId()});
                    }
                    this.listener.received(this, msg);
                }
                catch (Throwable t) {
                    log.error("[{}][{}] Message listener error in processing message: {}", new Object[]{this.topic, this.subscription, msg.getMessageId(), t});
                }
                continue;
            }
            catch (PulsarClientException e) {
                log.warn("[{}] [{}] Failed to dequeue the message for listener", new Object[]{this.topic, this.subscription, e});
                return;
            }
        }
    }

    private /* synthetic */ Object lambda$messageReceived$6(Void ok, Throwable e) {
        this.notifyPendingReceivedCallback(null, new PulsarClientException.InvalidMessageException(String.format("Unsupported Batch message with 0 size receiver queue for [%s]-[%s] ", this.subscription, this.consumerName)));
        return null;
    }

    static enum SubscriptionMode {
        Durable,
        NonDurable;

    }
}

