/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.ProducerInterceptor;
import org.apache.pulsar.shade.client.api.v2.Producer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProducerInterceptors<T>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(ProducerInterceptors.class);
    private final List<ProducerInterceptor<T>> interceptors;

    public ProducerInterceptors(List<ProducerInterceptor<T>> interceptors) {
        this.interceptors = interceptors;
    }

    public Message<T> beforeSend(Producer<T> producer, Message<T> message) {
        Message<T> interceptorMessage = message;
        for (int i = 0; i < this.interceptors.size(); ++i) {
            try {
                interceptorMessage = this.interceptors.get(i).beforeSend(producer, interceptorMessage);
                continue;
            }
            catch (Exception e) {
                if (message != null && producer != null) {
                    log.warn("Error executing interceptor beforeSend callback for messageId: {}, topicName:{} ", new Object[]{message.getMessageId(), producer.getTopic(), e});
                    continue;
                }
                log.warn("Error Error executing interceptor beforeSend callback ", (Throwable)e);
            }
        }
        return interceptorMessage;
    }

    public void onSendAcknowledgement(Producer<T> producer, Message<T> message, MessageId msgId, Throwable exception) {
        for (int i = 0; i < this.interceptors.size(); ++i) {
            try {
                this.interceptors.get(i).onSendAcknowledgement(producer, message, msgId, exception);
                continue;
            }
            catch (Exception e) {
                log.warn("Error executing interceptor onSendAcknowledgement callback ", (Throwable)e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (int i = 0; i < this.interceptors.size(); ++i) {
            try {
                this.interceptors.get(i).close();
                continue;
            }
            catch (Exception e) {
                log.error("Fail to close producer interceptor ", (Throwable)e);
            }
        }
    }
}

