/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.security.cert.X509Certificate;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.impl.ClientCnx;
import org.apache.pulsar.client.impl.conf.ClientConfigurationData;
import org.apache.pulsar.common.api.ByteBufPair;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.shade.io.netty.channel.ChannelHandler;
import org.apache.pulsar.shade.io.netty.channel.ChannelInitializer;
import org.apache.pulsar.shade.io.netty.channel.socket.SocketChannel;
import org.apache.pulsar.shade.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;

public class PulsarChannelInitializer
extends ChannelInitializer<SocketChannel> {
    public static final String TLS_HANDLER = "tls";
    private final Supplier<ClientCnx> clientCnxSupplier;
    private final SslContext sslCtx;

    public PulsarChannelInitializer(ClientConfigurationData conf, Supplier<ClientCnx> clientCnxSupplier) throws Exception {
        AuthenticationDataProvider authData;
        this.clientCnxSupplier = clientCnxSupplier;
        this.sslCtx = conf.isUseTls() ? ((authData = conf.getAuthentication().getAuthData()).hasDataForTls() ? SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath(), (X509Certificate[])authData.getTlsCertificates(), authData.getTlsPrivateKey()) : SecurityUtility.createNettySslContextForClient(conf.isTlsAllowInsecureConnection(), conf.getTlsTrustCertsFilePath())) : null;
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        if (this.sslCtx != null) {
            ch.pipeline().addLast(TLS_HANDLER, (ChannelHandler)this.sslCtx.newHandler(ch.alloc()));
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.COPYING_ENCODER);
        } else {
            ch.pipeline().addLast("ByteBufPairEncoder", (ChannelHandler)ByteBufPair.ENCODER);
        }
        ch.pipeline().addLast("frameDecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(0x500000, 0, 4, 0, 4));
        ch.pipeline().addLast("handler", (ChannelHandler)this.clientCnxSupplier.get());
    }
}

