/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.StructSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.avro.Conversions;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.data.TimeConversions;
import org.apache.pulsar.shade.org.apache.avro.io.BinaryDecoder;
import org.apache.pulsar.shade.org.apache.avro.io.BinaryEncoder;
import org.apache.pulsar.shade.org.apache.avro.io.DecoderFactory;
import org.apache.pulsar.shade.org.apache.avro.io.EncoderFactory;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectDatumReader;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectDatumWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema<T>
extends StructSchema<T> {
    private static final Logger log = LoggerFactory.getLogger(AvroSchema.class);
    private ReflectDatumWriter<T> datumWriter;
    private ReflectDatumReader<T> reader;
    private BinaryEncoder encoder;
    private ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
    private static final ThreadLocal<BinaryDecoder> decoders = new ThreadLocal();

    private AvroSchema(Schema schema, SchemaDefinition schemaDefinition) {
        super(SchemaType.AVRO, schema, schemaDefinition.getProperties());
        this.encoder = EncoderFactory.get().binaryEncoder(this.byteArrayOutputStream, this.encoder);
        this.datumWriter = new ReflectDatumWriter(this.schema);
        this.reader = new ReflectDatumReader(this.schema);
    }

    @Override
    public synchronized byte[] encode(T message) {
        try {
            this.datumWriter.write(message, this.encoder);
            this.encoder.flush();
            byte[] byArray = this.byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new SchemaSerializationException(e);
        }
        finally {
            this.byteArrayOutputStream.reset();
        }
    }

    @Override
    public T decode(byte[] bytes) {
        try {
            BinaryDecoder decoderFromCache = decoders.get();
            BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(bytes, decoderFromCache);
            if (decoderFromCache == null) {
                decoders.set(decoder);
            }
            return this.reader.read(null, DecoderFactory.get().binaryDecoder(bytes, decoder));
        }
        catch (IOException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public static <T> AvroSchema<T> of(SchemaDefinition<T> schemaDefinition) {
        return schemaDefinition.getJsonDef() == null ? new AvroSchema<T>(AvroSchema.createAvroSchema(schemaDefinition), schemaDefinition) : new AvroSchema<T>(AvroSchema.parseAvroSchema(schemaDefinition.getJsonDef()), schemaDefinition);
    }

    public static <T> AvroSchema<T> of(Class<T> pojo) {
        return AvroSchema.of(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> AvroSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        SchemaDefinition schemaDefinition = SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build();
        return new AvroSchema<T>(AvroSchema.createAvroSchema(schemaDefinition), schemaDefinition);
    }

    static {
        ReflectData.AllowNull reflectDataAllowNull = ReflectData.AllowNull.get();
        reflectDataAllowNull.addLogicalTypeConversion(new Conversions.DecimalConversion());
        reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.DateConversion());
        reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.LossyTimeMicrosConversion());
        reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.LossyTimestampMicrosConversion());
        reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
        reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.TimestampMicrosConversion());
        reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.TimestampConversion());
        reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.TimeConversion());
        ReflectData reflectDataNotAllowNull = ReflectData.get();
        reflectDataNotAllowNull.addLogicalTypeConversion(new Conversions.DecimalConversion());
        reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.DateConversion());
        reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.TimestampConversion());
        reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.LossyTimeMicrosConversion());
        reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.LossyTimestampMicrosConversion());
        reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
        reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.TimestampMicrosConversion());
        reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.TimeConversion());
    }
}

