/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class BooleanSchema
implements Schema<Boolean> {
    private static final BooleanSchema INSTANCE = new BooleanSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("Boolean").setType(SchemaType.BOOLEAN).setSchema(new byte[0]);

    public static BooleanSchema of() {
        return INSTANCE;
    }

    @Override
    public void validate(byte[] message) {
        if (message.length != 1) {
            throw new SchemaSerializationException("Size of data received by BooleanSchema is not 1");
        }
    }

    @Override
    public byte[] encode(Boolean message) {
        if (null == message) {
            return null;
        }
        return new byte[]{(byte)(message != false ? 1 : 0)};
    }

    @Override
    public Boolean decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        return bytes[0] != 0;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

