/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.impl.schema.StructSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchema;
import org.apache.pulsar.shade.com.fasterxml.jackson.module.jsonSchema.JsonSchemaGenerator;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSONSchema<T>
extends StructSchema<T> {
    private static final Logger log = LoggerFactory.getLogger(JSONSchema.class);
    private static final ThreadLocal<ObjectMapper> JSON_MAPPER = ThreadLocal.withInitial(() -> {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    });
    private final Class<T> pojo;
    private final ObjectMapper objectMapper;

    private JSONSchema(Schema schema, SchemaDefinition<T> schemaDefinition) {
        super(SchemaType.JSON, schema, schemaDefinition.getProperties());
        this.pojo = schemaDefinition.getPojo();
        this.objectMapper = JSON_MAPPER.get();
    }

    @Override
    public byte[] encode(T message) throws SchemaSerializationException {
        try {
            return this.objectMapper.writeValueAsBytes(message);
        }
        catch (JsonProcessingException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public T decode(byte[] bytes) {
        try {
            return this.objectMapper.readValue(bytes, this.pojo);
        }
        catch (IOException e) {
            throw new SchemaSerializationException(e);
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public SchemaInfo getBackwardsCompatibleJsonSchemaInfo() {
        SchemaInfo backwardsCompatibleSchemaInfo;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            JsonSchemaGenerator schemaGen = new JsonSchemaGenerator(objectMapper);
            JsonSchema jsonBackwardsCompatibleSchema = schemaGen.generateSchema(this.pojo);
            backwardsCompatibleSchemaInfo = new SchemaInfo();
            backwardsCompatibleSchemaInfo.setName("");
            backwardsCompatibleSchemaInfo.setProperties(this.schemaInfo.getProperties());
            backwardsCompatibleSchemaInfo.setType(SchemaType.JSON);
            backwardsCompatibleSchemaInfo.setSchema(objectMapper.writeValueAsBytes(jsonBackwardsCompatibleSchema));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
        return backwardsCompatibleSchemaInfo;
    }

    public static <T> JSONSchema<T> of(SchemaDefinition<T> schemaDefinition) {
        String jsonDef = schemaDefinition.getJsonDef();
        return jsonDef == null ? new JSONSchema<T>(JSONSchema.createAvroSchema(schemaDefinition), schemaDefinition) : new JSONSchema<T>(JSONSchema.parseAvroSchema(jsonDef), schemaDefinition);
    }

    public static <T> JSONSchema<T> of(Class<T> pojo) {
        return JSONSchema.of(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> JSONSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        return JSONSchema.of(SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build());
    }
}

