/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.ByteBuffer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class KeyValueSchema<K, V>
implements Schema<KeyValue<K, V>> {
    private final Schema<K> keySchema;
    private final Schema<V> valueSchema;
    private final SchemaInfo schemaInfo;
    private static final Schema<KeyValue<byte[], byte[]>> KV_BYTES = new KeyValueSchema<byte[], byte[]>(BytesSchema.of(), BytesSchema.of());

    public static <K, V> Schema<KeyValue<K, V>> of(Class<K> key, Class<V> value, SchemaType type) {
        Preconditions.checkArgument(SchemaType.JSON == type || SchemaType.AVRO == type);
        if (SchemaType.JSON == type) {
            return new KeyValueSchema<K, V>(JSONSchema.of(key), JSONSchema.of(value));
        }
        return new KeyValueSchema<K, V>(AvroSchema.of(key), AvroSchema.of(value));
    }

    public static <K, V> Schema<KeyValue<K, V>> of(Schema<K> keySchema, Schema<V> valueSchema) {
        return new KeyValueSchema<K, V>(keySchema, valueSchema);
    }

    public static Schema<KeyValue<byte[], byte[]>> kvBytes() {
        return KV_BYTES;
    }

    private KeyValueSchema(Schema<K> keySchema, Schema<V> valueSchema) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.schemaInfo = new SchemaInfo().setName("KeyValue").setType(SchemaType.KEY_VALUE);
        byte[] keySchemaInfo = keySchema.getSchemaInfo().getSchema();
        byte[] valueSchemaInfo = valueSchema.getSchemaInfo().getSchema();
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + keySchemaInfo.length + 4 + valueSchemaInfo.length);
        byteBuffer.putInt(keySchemaInfo.length).put(keySchemaInfo).putInt(valueSchemaInfo.length).put(valueSchemaInfo);
        this.schemaInfo.setSchema(byteBuffer.array());
    }

    @Override
    public byte[] encode(KeyValue<K, V> message) {
        byte[] keyBytes = this.keySchema.encode(message.getKey());
        byte[] valueBytes = this.valueSchema.encode(message.getValue());
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + keyBytes.length + 4 + valueBytes.length);
        byteBuffer.putInt(keyBytes.length).put(keyBytes).putInt(valueBytes.length).put(valueBytes);
        return byteBuffer.array();
    }

    @Override
    public KeyValue<K, V> decode(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        int keyLength = byteBuffer.getInt();
        byte[] keyBytes = new byte[keyLength];
        byteBuffer.get(keyBytes);
        int valueLength = byteBuffer.getInt();
        byte[] valueBytes = new byte[valueLength];
        byteBuffer.get(valueBytes);
        return new KeyValue<K, V>(this.keySchema.decode(keyBytes), this.valueSchema.decode(valueBytes));
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public Schema<K> getKeySchema() {
        return this.keySchema;
    }

    public Schema<V> getValueSchema() {
        return this.valueSchema;
    }
}

