/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.ByteBufUtil;

final class SchemaUtils {
    private static final Map<SchemaType, List<Class>> SCHEMA_TYPE_CLASSES = new HashMap<SchemaType, List<Class>>();
    private static final Map<Class<?>, SchemaType> JAVA_CLASS_SCHEMA_TYPES = new HashMap();

    private SchemaUtils() {
    }

    public static void validateFieldSchema(String name, SchemaType type, Object val) {
        if (null == val) {
            return;
        }
        List<Class> expectedClasses = SCHEMA_TYPE_CLASSES.get((Object)type);
        if (null == expectedClasses) {
            throw new RuntimeException("Invalid Java object for schema type " + (Object)((Object)type) + " : " + val.getClass() + " for field : \"" + name + "\"");
        }
        boolean foundMatch = false;
        for (Class expectedCls : expectedClasses) {
            if (!expectedCls.isInstance(val)) continue;
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            throw new RuntimeException("Invalid Java object for schema type " + (Object)((Object)type) + " : " + val.getClass() + " for field : \"" + name + "\"");
        }
        switch (type) {
            case INT8: 
            case INT16: 
            case PROTOBUF: 
            case AVRO: 
            case AUTO_CONSUME: 
            case AUTO_PUBLISH: 
            case AUTO: 
            case KEY_VALUE: 
            case JSON: 
            case NONE: {
                throw new RuntimeException("Currently " + type.name() + " is not supported");
            }
        }
    }

    public static Object toAvroObject(Object value) {
        if (value != null) {
            if (value instanceof ByteBuffer) {
                ByteBuffer bb = (ByteBuffer)value;
                byte[] bytes = new byte[bb.remaining()];
                bb.duplicate().get(bytes);
                return bytes;
            }
            if (value instanceof ByteBuf) {
                return ByteBufUtil.getBytes((ByteBuf)value);
            }
            return value;
        }
        return null;
    }

    static {
        SCHEMA_TYPE_CLASSES.put(SchemaType.INT8, Arrays.asList(Byte.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.INT16, Arrays.asList(Short.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.INT32, Arrays.asList(Integer.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.INT64, Arrays.asList(Long.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.FLOAT, Arrays.asList(Float.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.DOUBLE, Arrays.asList(Double.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.BOOLEAN, Arrays.asList(Boolean.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.STRING, Arrays.asList(String.class));
        SCHEMA_TYPE_CLASSES.put(SchemaType.BYTES, Arrays.asList(byte[].class, ByteBuffer.class, ByteBuf.class));
        SCHEMA_TYPE_CLASSES.forEach((type, classes) -> classes.forEach(clz -> JAVA_CLASS_SCHEMA_TYPES.put((Class<?>)clz, (SchemaType)((Object)type))));
    }
}

