/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema.generic;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericAvroRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericJsonRecord;
import org.apache.pulsar.client.impl.schema.generic.GenericSchemaImpl;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.JsonNode;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

class GenericJsonSchema
extends GenericSchemaImpl {
    private final ObjectMapper objectMapper = new ObjectMapper();

    public GenericJsonSchema(SchemaInfo schemaInfo) {
        super(schemaInfo);
    }

    @Override
    public byte[] encode(GenericRecord message) {
        Preconditions.checkArgument(message instanceof GenericAvroRecord);
        GenericJsonRecord gjr = (GenericJsonRecord)message;
        try {
            return this.objectMapper.writeValueAsBytes(gjr.getJsonNode().toString());
        }
        catch (IOException ioe) {
            throw new SchemaSerializationException(ioe);
        }
    }

    @Override
    public GenericRecord decode(byte[] bytes, byte[] schemaVersion) {
        try {
            JsonNode jn = this.objectMapper.readTree(new String(bytes, StandardCharsets.UTF_8));
            return new GenericJsonRecord(schemaVersion, this.fields, jn);
        }
        catch (IOException ioe) {
            throw new SchemaSerializationException(ioe);
        }
    }
}

