/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.api.raw;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.api.raw.RawMessage;
import org.apache.pulsar.common.api.raw.RawMessageId;
import org.apache.pulsar.common.api.raw.RawMessageIdImpl;
import org.apache.pulsar.common.api.raw.ReferenceCountedObject;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.util.Recycler;

public class RawMessageImpl
implements RawMessage {
    private final RawMessageIdImpl messageId = new RawMessageIdImpl();
    private ReferenceCountedObject<PulsarApi.MessageMetadata> msgMetadata;
    private PulsarApi.SingleMessageMetadata.Builder singleMessageMetadata;
    private ByteBuf payload;
    private static final Recycler<RawMessageImpl> RECYCLER = new Recycler<RawMessageImpl>(){

        @Override
        protected RawMessageImpl newObject(Recycler.Handle<RawMessageImpl> handle) {
            return new RawMessageImpl(handle);
        }
    };
    private final Recycler.Handle<RawMessageImpl> handle;

    private RawMessageImpl(Recycler.Handle<RawMessageImpl> handle) {
        this.handle = handle;
    }

    @Override
    public void release() {
        this.msgMetadata.release();
        this.msgMetadata = null;
        if (this.singleMessageMetadata != null) {
            this.singleMessageMetadata.recycle();
            this.singleMessageMetadata = null;
        }
        this.payload.release();
        this.handle.recycle(this);
    }

    public static RawMessage get(ReferenceCountedObject<PulsarApi.MessageMetadata> msgMetadata, PulsarApi.SingleMessageMetadata.Builder singleMessageMetadata, ByteBuf payload, long ledgerId, long entryId, long batchIndex) {
        RawMessageImpl msg = RECYCLER.get();
        msg.msgMetadata = msgMetadata;
        msg.msgMetadata.retain();
        msg.singleMessageMetadata = singleMessageMetadata;
        msg.messageId.ledgerId = ledgerId;
        msg.messageId.entryId = entryId;
        msg.messageId.batchIndex = batchIndex;
        msg.payload = payload;
        return msg;
    }

    @Override
    public Map<String, String> getProperties() {
        if (this.singleMessageMetadata != null && this.singleMessageMetadata.getPropertiesCount() > 0) {
            return this.singleMessageMetadata.getPropertiesList().stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue));
        }
        if (this.msgMetadata.get().getPropertiesCount() > 0) {
            return this.msgMetadata.get().getPropertiesList().stream().collect(Collectors.toMap(PulsarApi.KeyValue::getKey, PulsarApi.KeyValue::getValue));
        }
        return Collections.emptyMap();
    }

    @Override
    public ByteBuf getData() {
        return this.payload;
    }

    @Override
    public RawMessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public long getPublishTime() {
        return this.msgMetadata.get().getPublishTime();
    }

    @Override
    public long getEventTime() {
        if (this.singleMessageMetadata != null && this.singleMessageMetadata.hasEventTime()) {
            return this.singleMessageMetadata.getEventTime();
        }
        if (this.msgMetadata.get().hasEventTime()) {
            return this.msgMetadata.get().getEventTime();
        }
        return 0L;
    }

    @Override
    public long getSequenceId() {
        return this.msgMetadata.get().getSequenceId() + this.messageId.batchIndex;
    }

    @Override
    public String getProducerName() {
        return this.msgMetadata.get().getProducerName();
    }

    @Override
    public Optional<String> getKey() {
        if (this.singleMessageMetadata != null && this.singleMessageMetadata.hasPartitionKey()) {
            return Optional.of(this.singleMessageMetadata.getPartitionKey());
        }
        if (this.msgMetadata.get().hasPartitionKey()) {
            return Optional.of(this.msgMetadata.get().getPartitionKey());
        }
        return Optional.empty();
    }
}

