/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.compression;

import java.util.EnumMap;
import org.apache.pulsar.client.api.CompressionType;
import org.apache.pulsar.common.api.proto.PulsarApi;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.common.compression.CompressionCodecLZ4;
import org.apache.pulsar.common.compression.CompressionCodecNone;
import org.apache.pulsar.common.compression.CompressionCodecZLib;
import org.apache.pulsar.common.compression.CompressionCodecZstd;

public final class CompressionCodecProvider {
    private static final EnumMap<PulsarApi.CompressionType, CompressionCodec> codecs = new EnumMap(PulsarApi.CompressionType.class);

    public static CompressionCodec getCompressionCodec(PulsarApi.CompressionType type) {
        return codecs.get((Object)type);
    }

    public static CompressionCodec getCompressionCodec(CompressionType type) {
        return codecs.get((Object)CompressionCodecProvider.convertToWireProtocol(type));
    }

    public static PulsarApi.CompressionType convertToWireProtocol(CompressionType compressionType) {
        switch (compressionType) {
            case NONE: {
                return PulsarApi.CompressionType.NONE;
            }
            case LZ4: {
                return PulsarApi.CompressionType.LZ4;
            }
            case ZLIB: {
                return PulsarApi.CompressionType.ZLIB;
            }
            case ZSTD: {
                return PulsarApi.CompressionType.ZSTD;
            }
        }
        throw new RuntimeException("Invalid compression type");
    }

    public static CompressionType convertFromWireProtocol(PulsarApi.CompressionType compressionType) {
        switch (compressionType) {
            case NONE: {
                return CompressionType.NONE;
            }
            case LZ4: {
                return CompressionType.LZ4;
            }
            case ZLIB: {
                return CompressionType.ZLIB;
            }
            case ZSTD: {
                return CompressionType.ZSTD;
            }
        }
        throw new RuntimeException("Invalid compression type");
    }

    private CompressionCodecProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        codecs.put(PulsarApi.CompressionType.NONE, new CompressionCodecNone());
        codecs.put(PulsarApi.CompressionType.LZ4, new CompressionCodecLZ4());
        codecs.put(PulsarApi.CompressionType.ZLIB, new CompressionCodecZLib());
        codecs.put(PulsarApi.CompressionType.ZSTD, new CompressionCodecZstd());
    }
}

