/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.compression;

import com.github.luben.zstd.Zstd;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pulsar.common.compression.CompressionCodec;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.PooledByteBufAllocator;

public class CompressionCodecZstd
implements CompressionCodec {
    private static final int ZSTD_COMPRESSION_LEVEL = 3;

    @Override
    public ByteBuf encode(ByteBuf source) {
        int compressedLength;
        int uncompressedLength = source.readableBytes();
        int maxLength = (int)Zstd.compressBound((long)uncompressedLength);
        ByteBuf target = PooledByteBufAllocator.DEFAULT.directBuffer(maxLength, maxLength);
        if (source.hasMemoryAddress()) {
            compressedLength = (int)Zstd.compressUnsafe((long)target.memoryAddress(), (long)maxLength, (long)(source.memoryAddress() + (long)source.readerIndex()), (long)uncompressedLength, (int)3);
        } else {
            ByteBuffer sourceNio = source.nioBuffer(source.readerIndex(), source.readableBytes());
            ByteBuffer targetNio = target.nioBuffer(0, maxLength);
            compressedLength = Zstd.compress((ByteBuffer)targetNio, (ByteBuffer)sourceNio, (int)3);
        }
        target.writerIndex(compressedLength);
        return target;
    }

    @Override
    public ByteBuf decode(ByteBuf encoded, int uncompressedLength) throws IOException {
        ByteBuf uncompressed = PooledByteBufAllocator.DEFAULT.directBuffer(uncompressedLength, uncompressedLength);
        if (encoded.hasMemoryAddress()) {
            Zstd.decompressUnsafe((long)uncompressed.memoryAddress(), (long)uncompressedLength, (long)(encoded.memoryAddress() + (long)encoded.readerIndex()), (long)encoded.readableBytes());
        } else {
            ByteBuffer uncompressedNio = uncompressed.nioBuffer(0, uncompressedLength);
            ByteBuffer encodedNio = encoded.nioBuffer(encoded.readerIndex(), encoded.readableBytes());
            Zstd.decompress((ByteBuffer)uncompressedNio, (ByteBuffer)encodedNio);
        }
        uncompressed.writerIndex(uncompressedLength);
        return uncompressed;
    }
}

