/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.io;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.pulsar.common.functions.ConsumerConfig;
import org.apache.pulsar.common.functions.FunctionConfig;
import org.apache.pulsar.common.functions.Resources;

public class SinkConfig {
    private String tenant;
    private String namespace;
    private String name;
    private String className;
    private String sourceSubscriptionName;
    private Collection<String> inputs;
    private Map<String, String> topicToSerdeClassName;
    private String topicsPattern;
    private Map<String, String> topicToSchemaType;
    private Map<String, ConsumerConfig> inputSpecs = new TreeMap<String, ConsumerConfig>();
    private Map<String, Object> configs;
    private Map<String, Object> secrets;
    private Integer parallelism;
    private FunctionConfig.ProcessingGuarantees processingGuarantees;
    private Boolean retainOrdering;
    private Resources resources;
    private Boolean autoAck;
    private Long timeoutMs;
    private String archive;
    private Boolean cleanupSubscription;
    private String runtimeFlags;

    public static SinkConfigBuilder builder() {
        return new SinkConfigBuilder();
    }

    public SinkConfigBuilder toBuilder() {
        return new SinkConfigBuilder().tenant(this.tenant).namespace(this.namespace).name(this.name).className(this.className).sourceSubscriptionName(this.sourceSubscriptionName).inputs(this.inputs).topicToSerdeClassName(this.topicToSerdeClassName).topicsPattern(this.topicsPattern).topicToSchemaType(this.topicToSchemaType).inputSpecs(this.inputSpecs).configs(this.configs).secrets(this.secrets).parallelism(this.parallelism).processingGuarantees(this.processingGuarantees).retainOrdering(this.retainOrdering).resources(this.resources).autoAck(this.autoAck).timeoutMs(this.timeoutMs).archive(this.archive).cleanupSubscription(this.cleanupSubscription).runtimeFlags(this.runtimeFlags);
    }

    public String getTenant() {
        return this.tenant;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getSourceSubscriptionName() {
        return this.sourceSubscriptionName;
    }

    public Collection<String> getInputs() {
        return this.inputs;
    }

    public Map<String, String> getTopicToSerdeClassName() {
        return this.topicToSerdeClassName;
    }

    public String getTopicsPattern() {
        return this.topicsPattern;
    }

    public Map<String, String> getTopicToSchemaType() {
        return this.topicToSchemaType;
    }

    public Map<String, ConsumerConfig> getInputSpecs() {
        return this.inputSpecs;
    }

    public Map<String, Object> getConfigs() {
        return this.configs;
    }

    public Map<String, Object> getSecrets() {
        return this.secrets;
    }

    public Integer getParallelism() {
        return this.parallelism;
    }

    public FunctionConfig.ProcessingGuarantees getProcessingGuarantees() {
        return this.processingGuarantees;
    }

    public Boolean getRetainOrdering() {
        return this.retainOrdering;
    }

    public Resources getResources() {
        return this.resources;
    }

    public Boolean getAutoAck() {
        return this.autoAck;
    }

    public Long getTimeoutMs() {
        return this.timeoutMs;
    }

    public String getArchive() {
        return this.archive;
    }

    public Boolean getCleanupSubscription() {
        return this.cleanupSubscription;
    }

    public String getRuntimeFlags() {
        return this.runtimeFlags;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setSourceSubscriptionName(String sourceSubscriptionName) {
        this.sourceSubscriptionName = sourceSubscriptionName;
    }

    public void setInputs(Collection<String> inputs) {
        this.inputs = inputs;
    }

    public void setTopicToSerdeClassName(Map<String, String> topicToSerdeClassName) {
        this.topicToSerdeClassName = topicToSerdeClassName;
    }

    public void setTopicsPattern(String topicsPattern) {
        this.topicsPattern = topicsPattern;
    }

    public void setTopicToSchemaType(Map<String, String> topicToSchemaType) {
        this.topicToSchemaType = topicToSchemaType;
    }

    public void setInputSpecs(Map<String, ConsumerConfig> inputSpecs) {
        this.inputSpecs = inputSpecs;
    }

    public void setConfigs(Map<String, Object> configs) {
        this.configs = configs;
    }

    public void setSecrets(Map<String, Object> secrets) {
        this.secrets = secrets;
    }

    public void setParallelism(Integer parallelism) {
        this.parallelism = parallelism;
    }

    public void setProcessingGuarantees(FunctionConfig.ProcessingGuarantees processingGuarantees) {
        this.processingGuarantees = processingGuarantees;
    }

    public void setRetainOrdering(Boolean retainOrdering) {
        this.retainOrdering = retainOrdering;
    }

    public void setResources(Resources resources) {
        this.resources = resources;
    }

    public void setAutoAck(Boolean autoAck) {
        this.autoAck = autoAck;
    }

    public void setTimeoutMs(Long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void setArchive(String archive) {
        this.archive = archive;
    }

    public void setCleanupSubscription(Boolean cleanupSubscription) {
        this.cleanupSubscription = cleanupSubscription;
    }

    public void setRuntimeFlags(String runtimeFlags) {
        this.runtimeFlags = runtimeFlags;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkConfig)) {
            return false;
        }
        SinkConfig other = (SinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tenant = this.getTenant();
        String other$tenant = other.getTenant();
        if (this$tenant == null ? other$tenant != null : !this$tenant.equals(other$tenant)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$sourceSubscriptionName = this.getSourceSubscriptionName();
        String other$sourceSubscriptionName = other.getSourceSubscriptionName();
        if (this$sourceSubscriptionName == null ? other$sourceSubscriptionName != null : !this$sourceSubscriptionName.equals(other$sourceSubscriptionName)) {
            return false;
        }
        Collection<String> this$inputs = this.getInputs();
        Collection<String> other$inputs = other.getInputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Map<String, String> this$topicToSerdeClassName = this.getTopicToSerdeClassName();
        Map<String, String> other$topicToSerdeClassName = other.getTopicToSerdeClassName();
        if (this$topicToSerdeClassName == null ? other$topicToSerdeClassName != null : !((Object)this$topicToSerdeClassName).equals(other$topicToSerdeClassName)) {
            return false;
        }
        String this$topicsPattern = this.getTopicsPattern();
        String other$topicsPattern = other.getTopicsPattern();
        if (this$topicsPattern == null ? other$topicsPattern != null : !this$topicsPattern.equals(other$topicsPattern)) {
            return false;
        }
        Map<String, String> this$topicToSchemaType = this.getTopicToSchemaType();
        Map<String, String> other$topicToSchemaType = other.getTopicToSchemaType();
        if (this$topicToSchemaType == null ? other$topicToSchemaType != null : !((Object)this$topicToSchemaType).equals(other$topicToSchemaType)) {
            return false;
        }
        Map<String, ConsumerConfig> this$inputSpecs = this.getInputSpecs();
        Map<String, ConsumerConfig> other$inputSpecs = other.getInputSpecs();
        if (this$inputSpecs == null ? other$inputSpecs != null : !((Object)this$inputSpecs).equals(other$inputSpecs)) {
            return false;
        }
        Map<String, Object> this$configs = this.getConfigs();
        Map<String, Object> other$configs = other.getConfigs();
        if (this$configs == null ? other$configs != null : !((Object)this$configs).equals(other$configs)) {
            return false;
        }
        Map<String, Object> this$secrets = this.getSecrets();
        Map<String, Object> other$secrets = other.getSecrets();
        if (this$secrets == null ? other$secrets != null : !((Object)this$secrets).equals(other$secrets)) {
            return false;
        }
        Integer this$parallelism = this.getParallelism();
        Integer other$parallelism = other.getParallelism();
        if (this$parallelism == null ? other$parallelism != null : !((Object)this$parallelism).equals(other$parallelism)) {
            return false;
        }
        FunctionConfig.ProcessingGuarantees this$processingGuarantees = this.getProcessingGuarantees();
        FunctionConfig.ProcessingGuarantees other$processingGuarantees = other.getProcessingGuarantees();
        if (this$processingGuarantees == null ? other$processingGuarantees != null : !((Object)((Object)this$processingGuarantees)).equals((Object)other$processingGuarantees)) {
            return false;
        }
        Boolean this$retainOrdering = this.getRetainOrdering();
        Boolean other$retainOrdering = other.getRetainOrdering();
        if (this$retainOrdering == null ? other$retainOrdering != null : !((Object)this$retainOrdering).equals(other$retainOrdering)) {
            return false;
        }
        Resources this$resources = this.getResources();
        Resources other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        Boolean this$autoAck = this.getAutoAck();
        Boolean other$autoAck = other.getAutoAck();
        if (this$autoAck == null ? other$autoAck != null : !((Object)this$autoAck).equals(other$autoAck)) {
            return false;
        }
        Long this$timeoutMs = this.getTimeoutMs();
        Long other$timeoutMs = other.getTimeoutMs();
        if (this$timeoutMs == null ? other$timeoutMs != null : !((Object)this$timeoutMs).equals(other$timeoutMs)) {
            return false;
        }
        String this$archive = this.getArchive();
        String other$archive = other.getArchive();
        if (this$archive == null ? other$archive != null : !this$archive.equals(other$archive)) {
            return false;
        }
        Boolean this$cleanupSubscription = this.getCleanupSubscription();
        Boolean other$cleanupSubscription = other.getCleanupSubscription();
        if (this$cleanupSubscription == null ? other$cleanupSubscription != null : !((Object)this$cleanupSubscription).equals(other$cleanupSubscription)) {
            return false;
        }
        String this$runtimeFlags = this.getRuntimeFlags();
        String other$runtimeFlags = other.getRuntimeFlags();
        return !(this$runtimeFlags == null ? other$runtimeFlags != null : !this$runtimeFlags.equals(other$runtimeFlags));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tenant = this.getTenant();
        result = result * 59 + ($tenant == null ? 43 : $tenant.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $sourceSubscriptionName = this.getSourceSubscriptionName();
        result = result * 59 + ($sourceSubscriptionName == null ? 43 : $sourceSubscriptionName.hashCode());
        Collection<String> $inputs = this.getInputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Map<String, String> $topicToSerdeClassName = this.getTopicToSerdeClassName();
        result = result * 59 + ($topicToSerdeClassName == null ? 43 : ((Object)$topicToSerdeClassName).hashCode());
        String $topicsPattern = this.getTopicsPattern();
        result = result * 59 + ($topicsPattern == null ? 43 : $topicsPattern.hashCode());
        Map<String, String> $topicToSchemaType = this.getTopicToSchemaType();
        result = result * 59 + ($topicToSchemaType == null ? 43 : ((Object)$topicToSchemaType).hashCode());
        Map<String, ConsumerConfig> $inputSpecs = this.getInputSpecs();
        result = result * 59 + ($inputSpecs == null ? 43 : ((Object)$inputSpecs).hashCode());
        Map<String, Object> $configs = this.getConfigs();
        result = result * 59 + ($configs == null ? 43 : ((Object)$configs).hashCode());
        Map<String, Object> $secrets = this.getSecrets();
        result = result * 59 + ($secrets == null ? 43 : ((Object)$secrets).hashCode());
        Integer $parallelism = this.getParallelism();
        result = result * 59 + ($parallelism == null ? 43 : ((Object)$parallelism).hashCode());
        FunctionConfig.ProcessingGuarantees $processingGuarantees = this.getProcessingGuarantees();
        result = result * 59 + ($processingGuarantees == null ? 43 : ((Object)((Object)$processingGuarantees)).hashCode());
        Boolean $retainOrdering = this.getRetainOrdering();
        result = result * 59 + ($retainOrdering == null ? 43 : ((Object)$retainOrdering).hashCode());
        Resources $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        Boolean $autoAck = this.getAutoAck();
        result = result * 59 + ($autoAck == null ? 43 : ((Object)$autoAck).hashCode());
        Long $timeoutMs = this.getTimeoutMs();
        result = result * 59 + ($timeoutMs == null ? 43 : ((Object)$timeoutMs).hashCode());
        String $archive = this.getArchive();
        result = result * 59 + ($archive == null ? 43 : $archive.hashCode());
        Boolean $cleanupSubscription = this.getCleanupSubscription();
        result = result * 59 + ($cleanupSubscription == null ? 43 : ((Object)$cleanupSubscription).hashCode());
        String $runtimeFlags = this.getRuntimeFlags();
        result = result * 59 + ($runtimeFlags == null ? 43 : $runtimeFlags.hashCode());
        return result;
    }

    public String toString() {
        return "SinkConfig(tenant=" + this.getTenant() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", className=" + this.getClassName() + ", sourceSubscriptionName=" + this.getSourceSubscriptionName() + ", inputs=" + this.getInputs() + ", topicToSerdeClassName=" + this.getTopicToSerdeClassName() + ", topicsPattern=" + this.getTopicsPattern() + ", topicToSchemaType=" + this.getTopicToSchemaType() + ", inputSpecs=" + this.getInputSpecs() + ", configs=" + this.getConfigs() + ", secrets=" + this.getSecrets() + ", parallelism=" + this.getParallelism() + ", processingGuarantees=" + (Object)((Object)this.getProcessingGuarantees()) + ", retainOrdering=" + this.getRetainOrdering() + ", resources=" + this.getResources() + ", autoAck=" + this.getAutoAck() + ", timeoutMs=" + this.getTimeoutMs() + ", archive=" + this.getArchive() + ", cleanupSubscription=" + this.getCleanupSubscription() + ", runtimeFlags=" + this.getRuntimeFlags() + ")";
    }

    public SinkConfig() {
    }

    public SinkConfig(String tenant, String namespace, String name, String className, String sourceSubscriptionName, Collection<String> inputs, Map<String, String> topicToSerdeClassName, String topicsPattern, Map<String, String> topicToSchemaType, Map<String, ConsumerConfig> inputSpecs, Map<String, Object> configs, Map<String, Object> secrets, Integer parallelism, FunctionConfig.ProcessingGuarantees processingGuarantees, Boolean retainOrdering, Resources resources, Boolean autoAck, Long timeoutMs, String archive, Boolean cleanupSubscription, String runtimeFlags) {
        this.tenant = tenant;
        this.namespace = namespace;
        this.name = name;
        this.className = className;
        this.sourceSubscriptionName = sourceSubscriptionName;
        this.inputs = inputs;
        this.topicToSerdeClassName = topicToSerdeClassName;
        this.topicsPattern = topicsPattern;
        this.topicToSchemaType = topicToSchemaType;
        this.inputSpecs = inputSpecs;
        this.configs = configs;
        this.secrets = secrets;
        this.parallelism = parallelism;
        this.processingGuarantees = processingGuarantees;
        this.retainOrdering = retainOrdering;
        this.resources = resources;
        this.autoAck = autoAck;
        this.timeoutMs = timeoutMs;
        this.archive = archive;
        this.cleanupSubscription = cleanupSubscription;
        this.runtimeFlags = runtimeFlags;
    }

    public static class SinkConfigBuilder {
        private String tenant;
        private String namespace;
        private String name;
        private String className;
        private String sourceSubscriptionName;
        private Collection<String> inputs;
        private Map<String, String> topicToSerdeClassName;
        private String topicsPattern;
        private Map<String, String> topicToSchemaType;
        private Map<String, ConsumerConfig> inputSpecs;
        private Map<String, Object> configs;
        private Map<String, Object> secrets;
        private Integer parallelism;
        private FunctionConfig.ProcessingGuarantees processingGuarantees;
        private Boolean retainOrdering;
        private Resources resources;
        private Boolean autoAck;
        private Long timeoutMs;
        private String archive;
        private Boolean cleanupSubscription;
        private String runtimeFlags;

        SinkConfigBuilder() {
        }

        public SinkConfigBuilder tenant(String tenant) {
            this.tenant = tenant;
            return this;
        }

        public SinkConfigBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public SinkConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SinkConfigBuilder className(String className) {
            this.className = className;
            return this;
        }

        public SinkConfigBuilder sourceSubscriptionName(String sourceSubscriptionName) {
            this.sourceSubscriptionName = sourceSubscriptionName;
            return this;
        }

        public SinkConfigBuilder inputs(Collection<String> inputs) {
            this.inputs = inputs;
            return this;
        }

        public SinkConfigBuilder topicToSerdeClassName(Map<String, String> topicToSerdeClassName) {
            this.topicToSerdeClassName = topicToSerdeClassName;
            return this;
        }

        public SinkConfigBuilder topicsPattern(String topicsPattern) {
            this.topicsPattern = topicsPattern;
            return this;
        }

        public SinkConfigBuilder topicToSchemaType(Map<String, String> topicToSchemaType) {
            this.topicToSchemaType = topicToSchemaType;
            return this;
        }

        public SinkConfigBuilder inputSpecs(Map<String, ConsumerConfig> inputSpecs) {
            this.inputSpecs = inputSpecs;
            return this;
        }

        public SinkConfigBuilder configs(Map<String, Object> configs) {
            this.configs = configs;
            return this;
        }

        public SinkConfigBuilder secrets(Map<String, Object> secrets) {
            this.secrets = secrets;
            return this;
        }

        public SinkConfigBuilder parallelism(Integer parallelism) {
            this.parallelism = parallelism;
            return this;
        }

        public SinkConfigBuilder processingGuarantees(FunctionConfig.ProcessingGuarantees processingGuarantees) {
            this.processingGuarantees = processingGuarantees;
            return this;
        }

        public SinkConfigBuilder retainOrdering(Boolean retainOrdering) {
            this.retainOrdering = retainOrdering;
            return this;
        }

        public SinkConfigBuilder resources(Resources resources) {
            this.resources = resources;
            return this;
        }

        public SinkConfigBuilder autoAck(Boolean autoAck) {
            this.autoAck = autoAck;
            return this;
        }

        public SinkConfigBuilder timeoutMs(Long timeoutMs) {
            this.timeoutMs = timeoutMs;
            return this;
        }

        public SinkConfigBuilder archive(String archive) {
            this.archive = archive;
            return this;
        }

        public SinkConfigBuilder cleanupSubscription(Boolean cleanupSubscription) {
            this.cleanupSubscription = cleanupSubscription;
            return this;
        }

        public SinkConfigBuilder runtimeFlags(String runtimeFlags) {
            this.runtimeFlags = runtimeFlags;
            return this;
        }

        public SinkConfig build() {
            return new SinkConfig(this.tenant, this.namespace, this.name, this.className, this.sourceSubscriptionName, this.inputs, this.topicToSerdeClassName, this.topicsPattern, this.topicToSchemaType, this.inputSpecs, this.configs, this.secrets, this.parallelism, this.processingGuarantees, this.retainOrdering, this.resources, this.autoAck, this.timeoutMs, this.archive, this.cleanupSubscription, this.runtimeFlags);
        }

        public String toString() {
            return "SinkConfig.SinkConfigBuilder(tenant=" + this.tenant + ", namespace=" + this.namespace + ", name=" + this.name + ", className=" + this.className + ", sourceSubscriptionName=" + this.sourceSubscriptionName + ", inputs=" + this.inputs + ", topicToSerdeClassName=" + this.topicToSerdeClassName + ", topicsPattern=" + this.topicsPattern + ", topicToSchemaType=" + this.topicToSchemaType + ", inputSpecs=" + this.inputSpecs + ", configs=" + this.configs + ", secrets=" + this.secrets + ", parallelism=" + this.parallelism + ", processingGuarantees=" + (Object)((Object)this.processingGuarantees) + ", retainOrdering=" + this.retainOrdering + ", resources=" + this.resources + ", autoAck=" + this.autoAck + ", timeoutMs=" + this.timeoutMs + ", archive=" + this.archive + ", cleanupSubscription=" + this.cleanupSubscription + ", runtimeFlags=" + this.runtimeFlags + ")";
        }
    }
}

