/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util.collections;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.StampedLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.common.collect.Lists;

public class ConcurrentOpenHashMap<K, V> {
    private static final Object EmptyKey = null;
    private static final Object DeletedKey = new Object();
    private static final float MapFillFactor = 0.66f;
    private static final int DefaultExpectedItems = 256;
    private static final int DefaultConcurrencyLevel = 16;
    private final Section<K, V>[] sections;
    private static final long HashMixer = -4132994306676758123L;
    private static final int R = 47;

    public ConcurrentOpenHashMap() {
        this(256);
    }

    public ConcurrentOpenHashMap(int expectedItems) {
        this(expectedItems, 16);
    }

    public ConcurrentOpenHashMap(int expectedItems, int concurrencyLevel) {
        Preconditions.checkArgument(expectedItems > 0);
        Preconditions.checkArgument(concurrencyLevel > 0);
        Preconditions.checkArgument(expectedItems >= concurrencyLevel);
        int numSections = concurrencyLevel;
        int perSectionExpectedItems = expectedItems / numSections;
        int perSectionCapacity = (int)((float)perSectionExpectedItems / 0.66f);
        this.sections = new Section[numSections];
        for (int i = 0; i < numSections; ++i) {
            this.sections[i] = new Section(perSectionCapacity);
        }
    }

    public long size() {
        long size = 0L;
        for (Section<K, V> s : this.sections) {
            size += (long)((Section)s).size;
        }
        return size;
    }

    public long capacity() {
        long capacity = 0L;
        for (Section<K, V> s : this.sections) {
            capacity += (long)((Section)s).capacity;
        }
        return capacity;
    }

    public boolean isEmpty() {
        for (Section<K, V> s : this.sections) {
            if (((Section)s).size == 0) continue;
            return false;
        }
        return true;
    }

    public V get(K key) {
        Preconditions.checkNotNull(key);
        long h = ConcurrentOpenHashMap.hash(key);
        return this.getSection(h).get(key, (int)h);
    }

    public boolean containsKey(K key) {
        return this.get(key) != null;
    }

    public V put(K key, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashMap.hash(key);
        return this.getSection(h).put(key, value, (int)h, false, null);
    }

    public V putIfAbsent(K key, V value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashMap.hash(key);
        return this.getSection(h).put(key, value, (int)h, true, null);
    }

    public V computeIfAbsent(K key, Function<K, V> provider) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(provider);
        long h = ConcurrentOpenHashMap.hash(key);
        return this.getSection(h).put(key, null, (int)h, true, provider);
    }

    public V remove(K key) {
        Preconditions.checkNotNull(key);
        long h = ConcurrentOpenHashMap.hash(key);
        return (V)((Section)this.getSection(h)).remove(key, null, (int)h);
    }

    public boolean remove(K key, Object value) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        long h = ConcurrentOpenHashMap.hash(key);
        return ((Section)this.getSection(h)).remove(key, value, (int)h) != null;
    }

    private Section<K, V> getSection(long hash) {
        int sectionIdx = (int)(hash >>> 32) & this.sections.length - 1;
        return this.sections[sectionIdx];
    }

    public void clear() {
        for (Section<K, V> s : this.sections) {
            s.clear();
        }
    }

    public void forEach(BiConsumer<? super K, ? super V> processor) {
        for (Section<? super K, ? super V> section : this.sections) {
            section.forEach(processor);
        }
    }

    public List<K> keys() {
        ArrayList keys = Lists.newArrayList();
        this.forEach((key, value) -> keys.add(key));
        return keys;
    }

    public List<V> values() {
        ArrayList values = Lists.newArrayList();
        this.forEach((key, value) -> values.add(value));
        return values;
    }

    static final <K> long hash(K key) {
        long hash = (long)key.hashCode() * -4132994306676758123L;
        hash ^= hash >>> 47;
        return hash *= -4132994306676758123L;
    }

    static final int signSafeMod(long n, int Max) {
        return (int)(n & (long)(Max - 1)) << 1;
    }

    private static final int alignToPowerOfTwo(int n) {
        return (int)Math.pow(2.0, 32 - Integer.numberOfLeadingZeros(n - 1));
    }

    private static final class Section<K, V>
    extends StampedLock {
        private volatile Object[] table;
        private volatile int capacity;
        private volatile int size;
        private int usedBuckets;
        private int resizeThreshold;

        Section(int capacity) {
            this.capacity = ConcurrentOpenHashMap.alignToPowerOfTwo(capacity);
            this.table = new Object[2 * this.capacity];
            this.size = 0;
            this.usedBuckets = 0;
            this.resizeThreshold = (int)((float)this.capacity * 0.66f);
        }

        V get(K key, int keyHash) {
            long stamp = this.tryOptimisticRead();
            boolean acquiredLock = false;
            int bucket = ConcurrentOpenHashMap.signSafeMod(keyHash, this.capacity);
            try {
                while (true) {
                    Object storedKey = this.table[bucket];
                    Object storedValue = this.table[bucket + 1];
                    if (!acquiredLock && this.validate(stamp)) {
                        if (key.equals(storedKey)) {
                            Object object = storedValue;
                            return (V)object;
                        }
                        if (storedKey == EmptyKey) {
                            V v = null;
                            return v;
                        }
                    } else {
                        if (!acquiredLock) {
                            stamp = this.readLock();
                            acquiredLock = true;
                            bucket = ConcurrentOpenHashMap.signSafeMod(keyHash, this.capacity);
                            storedKey = this.table[bucket];
                            storedValue = this.table[bucket + 1];
                        }
                        if (key.equals(storedKey)) {
                            Object object = storedValue;
                            return (V)object;
                        }
                        if (storedKey == EmptyKey) {
                            V v = null;
                            return v;
                        }
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (acquiredLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        V put(K key, V value, int keyHash, boolean onlyIfAbsent, Function<K, V> valueProvider) {
            long stamp = this.writeLock();
            int bucket = ConcurrentOpenHashMap.signSafeMod(keyHash, this.capacity);
            int firstDeletedKey = -1;
            try {
                while (true) {
                    Object storedKey = this.table[bucket];
                    Object storedValue = this.table[bucket + 1];
                    if (key.equals(storedKey)) {
                        if (!onlyIfAbsent) {
                            this.table[bucket + 1] = value;
                            Object object = storedValue;
                            return (V)object;
                        }
                        Object object = storedValue;
                        return (V)object;
                    }
                    if (storedKey == EmptyKey) {
                        if (firstDeletedKey != -1) {
                            bucket = firstDeletedKey;
                        } else {
                            ++this.usedBuckets;
                        }
                        if (value == null) {
                            value = valueProvider.apply(key);
                        }
                        this.table[bucket] = key;
                        this.table[bucket + 1] = value;
                        ++this.size;
                        V v = valueProvider != null ? value : null;
                        return v;
                    }
                    if (storedKey == DeletedKey && firstDeletedKey == -1) {
                        firstDeletedKey = bucket;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                if (this.usedBuckets > this.resizeThreshold) {
                    try {
                        this.rehash();
                    }
                    finally {
                        this.unlockWrite(stamp);
                    }
                } else {
                    this.unlockWrite(stamp);
                }
            }
        }

        private V remove(K key, Object value, int keyHash) {
            long stamp = this.writeLock();
            int bucket = ConcurrentOpenHashMap.signSafeMod(keyHash, this.capacity);
            try {
                while (true) {
                    Object storedKey = this.table[bucket];
                    Object storedValue = this.table[bucket + 1];
                    if (key.equals(storedKey)) {
                        if (value == null || value.equals(storedValue)) {
                            --this.size;
                            int nextInArray = bucket + 2 & this.table.length - 1;
                            if (this.table[nextInArray] == EmptyKey) {
                                this.table[bucket] = EmptyKey;
                                this.table[bucket + 1] = null;
                                --this.usedBuckets;
                            } else {
                                this.table[bucket] = DeletedKey;
                                this.table[bucket + 1] = null;
                            }
                            Object object = storedValue;
                            return (V)object;
                        }
                        V v = null;
                        return v;
                    }
                    if (storedKey == EmptyKey) {
                        V v = null;
                        return v;
                    }
                    bucket = bucket + 2 & this.table.length - 1;
                }
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        void clear() {
            long stamp = this.writeLock();
            try {
                Arrays.fill(this.table, EmptyKey);
                this.size = 0;
                this.usedBuckets = 0;
            }
            finally {
                this.unlockWrite(stamp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void forEach(BiConsumer<? super K, ? super V> processor) {
            long stamp = this.tryOptimisticRead();
            Object[] table = this.table;
            boolean acquiredReadLock = false;
            try {
                if (!this.validate(stamp)) {
                    stamp = this.readLock();
                    acquiredReadLock = true;
                    table = this.table;
                }
                for (int bucket = 0; bucket < table.length; bucket += 2) {
                    Object storedKey = table[bucket];
                    Object storedValue = table[bucket + 1];
                    if (!acquiredReadLock && !this.validate(stamp)) {
                        stamp = this.readLock();
                        acquiredReadLock = true;
                        storedKey = table[bucket];
                        storedValue = table[bucket + 1];
                    }
                    if (storedKey == DeletedKey || storedKey == EmptyKey) continue;
                    processor.accept(storedKey, storedValue);
                }
            }
            finally {
                if (acquiredReadLock) {
                    this.unlockRead(stamp);
                }
            }
        }

        private void rehash() {
            int newCapacity = this.capacity * 2;
            Object[] newTable = new Object[2 * newCapacity];
            for (int i = 0; i < this.table.length; i += 2) {
                Object storedKey = this.table[i];
                Object storedValue = this.table[i + 1];
                if (storedKey == EmptyKey || storedKey == DeletedKey) continue;
                Section.insertKeyValueNoLock(newTable, newCapacity, storedKey, storedValue);
            }
            this.table = newTable;
            this.capacity = newCapacity;
            this.usedBuckets = this.size;
            this.resizeThreshold = (int)((float)this.capacity * 0.66f);
        }

        private static <K, V> void insertKeyValueNoLock(Object[] table, int capacity, K key, V value) {
            int bucket = ConcurrentOpenHashMap.signSafeMod(ConcurrentOpenHashMap.hash(key), capacity);
            while (true) {
                Object storedKey;
                if ((storedKey = table[bucket]) == EmptyKey) {
                    table[bucket] = key;
                    table[bucket + 1] = value;
                    return;
                }
                bucket = bucket + 2 & table.length - 1;
            }
        }
    }
}

