/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.PulsarVersion;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.PulsarServiceNameResolver;
import org.apache.pulsar.client.impl.ServiceNameResolver;
import org.apache.pulsar.common.util.ObjectMapperFactory;
import org.apache.pulsar.common.util.SecurityUtility;
import org.apache.pulsar.shade.com.google.common.util.concurrent.MoreExecutors;
import org.apache.pulsar.shade.io.netty.channel.EventLoopGroup;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpRequest;
import org.apache.pulsar.shade.io.netty.handler.codec.http.HttpResponse;
import org.apache.pulsar.shade.io.netty.handler.ssl.SslContext;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncCompletionHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.BoundRequestBuilder;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClient;
import org.apache.pulsar.shade.org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.ListenableFuture;
import org.apache.pulsar.shade.org.asynchttpclient.Request;
import org.apache.pulsar.shade.org.asynchttpclient.Response;
import org.apache.pulsar.shade.org.asynchttpclient.channel.DefaultKeepAliveStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable {
    protected static final int DEFAULT_CONNECT_TIMEOUT_IN_SECONDS = 10;
    protected static final int DEFAULT_READ_TIMEOUT_IN_SECONDS = 30;
    protected final AsyncHttpClient httpClient;
    protected final ServiceNameResolver serviceNameResolver;
    protected final Authentication authentication;
    private static final Logger log = LoggerFactory.getLogger(HttpClient.class);

    protected HttpClient(String serviceUrl, Authentication authentication, EventLoopGroup eventLoopGroup, boolean tlsAllowInsecureConnection, String tlsTrustCertsFilePath) throws PulsarClientException {
        this(serviceUrl, authentication, eventLoopGroup, tlsAllowInsecureConnection, tlsTrustCertsFilePath, 10, 30);
    }

    protected HttpClient(String serviceUrl, Authentication authentication, EventLoopGroup eventLoopGroup, boolean tlsAllowInsecureConnection, String tlsTrustCertsFilePath, int connectTimeoutInSeconds, int readTimeoutInSeconds) throws PulsarClientException {
        this.authentication = authentication;
        this.serviceNameResolver = new PulsarServiceNameResolver();
        this.serviceNameResolver.updateServiceUrl(serviceUrl);
        DefaultAsyncHttpClientConfig.Builder confBuilder = new DefaultAsyncHttpClientConfig.Builder();
        confBuilder.setFollowRedirect(true);
        confBuilder.setConnectTimeout(connectTimeoutInSeconds * 1000);
        confBuilder.setReadTimeout(readTimeoutInSeconds * 1000);
        confBuilder.setUserAgent(String.format("Pulsar-Java-v%s", PulsarVersion.getVersion()));
        confBuilder.setKeepAliveStrategy(new DefaultKeepAliveStrategy(){

            @Override
            public boolean keepAlive(Request ahcRequest, HttpRequest request, HttpResponse response) {
                return response.status().code() / 100 != 5 && super.keepAlive(ahcRequest, request, response);
            }
        });
        if ("https".equals(this.serviceNameResolver.getServiceUri().getServiceName())) {
            try {
                SslContext sslCtx = null;
                AuthenticationDataProvider authData = authentication.getAuthData();
                sslCtx = authData.hasDataForTls() ? SecurityUtility.createNettySslContextForClient(tlsAllowInsecureConnection, tlsTrustCertsFilePath, authData.getTlsCertificates(), authData.getTlsPrivateKey()) : SecurityUtility.createNettySslContextForClient(tlsAllowInsecureConnection, tlsTrustCertsFilePath);
                confBuilder.setSslContext(sslCtx);
                confBuilder.setUseInsecureTrustManager(tlsAllowInsecureConnection);
            }
            catch (Exception e) {
                throw new PulsarClientException.InvalidConfigurationException(e);
            }
        }
        confBuilder.setEventLoopGroup(eventLoopGroup);
        DefaultAsyncHttpClientConfig config = confBuilder.build();
        this.httpClient = new DefaultAsyncHttpClient(config);
        log.debug("Using HTTP url: {}", (Object)serviceUrl);
    }

    String getServiceUrl() {
        return this.serviceNameResolver.getServiceUrl();
    }

    void setServiceUrl(String serviceUrl) throws PulsarClientException {
        this.serviceNameResolver.updateServiceUrl(serviceUrl);
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    public <T> CompletableFuture<T> get(String path, Class<T> clazz) {
        final CompletableFuture future = new CompletableFuture();
        try {
            final String requestUrl = new URL(this.serviceNameResolver.resolveHostUri().toURL(), path).toString();
            AuthenticationDataProvider authData = this.authentication.getAuthData();
            BoundRequestBuilder builder = this.httpClient.prepareGet(requestUrl);
            if (authData.hasDataForHttp()) {
                for (Map.Entry<String, String> header : authData.getHttpHeaders()) {
                    builder.setHeader((CharSequence)header.getKey(), header.getValue());
                }
            }
            ListenableFuture<Response> responseFuture = ((BoundRequestBuilder)builder.setHeader((CharSequence)"Accept", "application/json")).execute(new AsyncCompletionHandler<Response>(){

                @Override
                public Response onCompleted(Response response) throws Exception {
                    return response;
                }

                @Override
                public void onThrowable(Throwable t) {
                    log.warn("[{}] Failed to perform http request: {}", (Object)requestUrl, (Object)t.getMessage());
                    future.completeExceptionally(new PulsarClientException(t));
                }
            });
            responseFuture.addListener(() -> {
                try {
                    Response response = (Response)responseFuture.get();
                    if (response.getStatusCode() != 200) {
                        log.warn("[{}] HTTP get request failed: {}", (Object)requestUrl, (Object)response.getStatusText());
                        PulsarClientException e = response.getStatusCode() == 404 ? new PulsarClientException.NotFoundException("Not found: " + response.getStatusText()) : new PulsarClientException("HTTP get request failed: " + response.getStatusText());
                        future.completeExceptionally(e);
                        return;
                    }
                    Object data = ObjectMapperFactory.getThreadLocal().readValue(response.getResponseBodyAsBytes(), clazz);
                    future.complete(data);
                }
                catch (Exception e) {
                    log.warn("[{}] Error during HTTP get request: {}", (Object)requestUrl, (Object)e.getMessage());
                    future.completeExceptionally(new PulsarClientException(e));
                }
            }, MoreExecutors.directExecutor());
        }
        catch (Exception e) {
            log.warn("[{}] Failed to get authentication data for lookup: {}", (Object)path, (Object)e.getMessage());
            if (e instanceof PulsarClientException) {
                future.completeExceptionally(e);
            }
            future.completeExceptionally(new PulsarClientException(e));
        }
        return future;
    }
}

