/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.TypedMessageBuilder;
import org.apache.pulsar.client.impl.HandlerState;
import org.apache.pulsar.client.impl.ProducerInterceptors;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.TypedMessageBuilderImpl;
import org.apache.pulsar.client.impl.conf.ProducerConfigurationData;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.shade.client.api.v2.Producer;

public abstract class ProducerBase<T>
extends HandlerState
implements Producer<T> {
    protected final CompletableFuture<Producer<T>> producerCreatedFuture;
    protected final ProducerConfigurationData conf;
    protected final Schema<T> schema;
    protected final ProducerInterceptors<T> interceptors;

    protected ProducerBase(PulsarClientImpl client, String topic, ProducerConfigurationData conf, CompletableFuture<Producer<T>> producerCreatedFuture, Schema<T> schema, ProducerInterceptors<T> interceptors) {
        super(client, topic);
        this.producerCreatedFuture = producerCreatedFuture;
        this.conf = conf;
        this.schema = schema;
        this.interceptors = interceptors;
    }

    @Override
    public MessageId send(T message) throws PulsarClientException {
        return this.newMessage().value(message).send();
    }

    @Override
    public CompletableFuture<MessageId> sendAsync(T message) {
        try {
            return this.newMessage().value(message).sendAsync();
        }
        catch (SchemaSerializationException e) {
            return FutureUtil.failedFuture(e);
        }
    }

    @Override
    public CompletableFuture<MessageId> sendAsync(Message<T> message) {
        return this.internalSendAsync(message);
    }

    @Override
    public TypedMessageBuilder<T> newMessage() {
        return new TypedMessageBuilderImpl<T>(this, this.schema);
    }

    abstract CompletableFuture<MessageId> internalSendAsync(Message<T> var1);

    @Override
    public MessageId send(Message<T> message) throws PulsarClientException {
        try {
            CompletableFuture<MessageId> sendFuture = this.internalSendAsync(message);
            if (!sendFuture.isDone()) {
                this.triggerFlush();
            }
            return sendFuture.get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public void flush() throws PulsarClientException {
        try {
            this.flushAsync().get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PulsarClientException) {
                throw (PulsarClientException)cause;
            }
            throw new PulsarClientException(cause);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    abstract void triggerFlush();

    @Override
    public void close() throws PulsarClientException {
        try {
            this.closeAsync().get();
        }
        catch (ExecutionException e) {
            Throwable t = e.getCause();
            if (t instanceof PulsarClientException) {
                throw (PulsarClientException)t;
            }
            throw new PulsarClientException(t);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new PulsarClientException(e);
        }
    }

    @Override
    public abstract CompletableFuture<Void> closeAsync();

    @Override
    public String getTopic() {
        return this.topic;
    }

    public ProducerConfigurationData getConfiguration() {
        return this.conf;
    }

    public CompletableFuture<Producer<T>> producerCreatedFuture() {
        return this.producerCreatedFuture;
    }

    protected Message<T> beforeSend(Message<T> message) {
        if (this.interceptors != null) {
            return this.interceptors.beforeSend(this, message);
        }
        return message;
    }

    protected void onSendAcknowledgement(Message<T> message, MessageId msgId, Throwable exception) {
        if (this.interceptors != null) {
            this.interceptors.onSendAcknowledgement(this, message, msgId, exception);
        }
    }

    public String toString() {
        return "ProducerBase{topic='" + this.topic + '\'' + '}';
    }
}

