/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.auth;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.AuthenticationDataProvider;
import org.apache.pulsar.client.api.EncodedAuthenticationParameterSupport;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.impl.auth.AuthenticationDataToken;
import org.apache.pulsar.shade.com.google.common.base.Charsets;

public class AuthenticationToken
implements Authentication,
EncodedAuthenticationParameterSupport {
    private Supplier<String> tokenSupplier;

    public AuthenticationToken() {
    }

    public AuthenticationToken(String token) {
        this(() -> token);
    }

    public AuthenticationToken(Supplier<String> tokenSupplier) {
        this.tokenSupplier = tokenSupplier;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public String getAuthMethodName() {
        return "token";
    }

    @Override
    public AuthenticationDataProvider getAuthData() throws PulsarClientException {
        return new AuthenticationDataToken(this.tokenSupplier);
    }

    @Override
    public void configure(String encodedAuthParamString) {
        if (encodedAuthParamString.startsWith("token:")) {
            this.tokenSupplier = () -> encodedAuthParamString.substring("token:".length());
        } else if (encodedAuthParamString.startsWith("file:")) {
            URI filePath = URI.create(encodedAuthParamString);
            this.tokenSupplier = () -> {
                try {
                    return new String(Files.readAllBytes(Paths.get(filePath)), Charsets.UTF_8).trim();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read token from file", e);
                }
            };
        } else {
            this.tokenSupplier = () -> encodedAuthParamString;
        }
    }

    @Override
    public void configure(Map<String, String> authParams) {
    }

    @Override
    public void start() throws PulsarClientException {
    }
}

