/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;

public class ClientConfigurationData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String serviceUrl;
    @JsonIgnore
    private ServiceUrlProvider serviceUrlProvider;
    @JsonIgnore
    private Authentication authentication = new AuthenticationDisabled();
    private long operationTimeoutMs = 30000L;
    private long statsIntervalSeconds = 60L;
    private int numIoThreads = 1;
    private int numListenerThreads = 1;
    private int connectionsPerBroker = 1;
    private boolean useTcpNoDelay = true;
    private boolean useTls = false;
    private String tlsTrustCertsFilePath = "";
    private boolean tlsAllowInsecureConnection = false;
    private boolean tlsHostnameVerificationEnable = false;
    private int concurrentLookupRequest = 5000;
    private int maxLookupRequest = 50000;
    private int maxNumberOfRejectedRequestPerConnection = 50;
    private int keepAliveIntervalSeconds = 30;
    private int connectionTimeoutMs = 10000;

    public ClientConfigurationData clone() {
        try {
            return (ClientConfigurationData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ClientConfigurationData");
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public long getOperationTimeoutMs() {
        return this.operationTimeoutMs;
    }

    public long getStatsIntervalSeconds() {
        return this.statsIntervalSeconds;
    }

    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    public int getNumListenerThreads() {
        return this.numListenerThreads;
    }

    public int getConnectionsPerBroker() {
        return this.connectionsPerBroker;
    }

    public boolean isUseTcpNoDelay() {
        return this.useTcpNoDelay;
    }

    public boolean isUseTls() {
        return this.useTls;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isTlsHostnameVerificationEnable() {
        return this.tlsHostnameVerificationEnable;
    }

    public int getConcurrentLookupRequest() {
        return this.concurrentLookupRequest;
    }

    public int getMaxLookupRequest() {
        return this.maxLookupRequest;
    }

    public int getMaxNumberOfRejectedRequestPerConnection() {
        return this.maxNumberOfRejectedRequestPerConnection;
    }

    public int getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.serviceUrlProvider = serviceUrlProvider;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setOperationTimeoutMs(long operationTimeoutMs) {
        this.operationTimeoutMs = operationTimeoutMs;
    }

    public void setStatsIntervalSeconds(long statsIntervalSeconds) {
        this.statsIntervalSeconds = statsIntervalSeconds;
    }

    public void setNumIoThreads(int numIoThreads) {
        this.numIoThreads = numIoThreads;
    }

    public void setNumListenerThreads(int numListenerThreads) {
        this.numListenerThreads = numListenerThreads;
    }

    public void setConnectionsPerBroker(int connectionsPerBroker) {
        this.connectionsPerBroker = connectionsPerBroker;
    }

    public void setUseTcpNoDelay(boolean useTcpNoDelay) {
        this.useTcpNoDelay = useTcpNoDelay;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsHostnameVerificationEnable(boolean tlsHostnameVerificationEnable) {
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
    }

    public void setConcurrentLookupRequest(int concurrentLookupRequest) {
        this.concurrentLookupRequest = concurrentLookupRequest;
    }

    public void setMaxLookupRequest(int maxLookupRequest) {
        this.maxLookupRequest = maxLookupRequest;
    }

    public void setMaxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
    }

    public void setKeepAliveIntervalSeconds(int keepAliveIntervalSeconds) {
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfigurationData)) {
            return false;
        }
        ClientConfigurationData other = (ClientConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        ServiceUrlProvider this$serviceUrlProvider = this.getServiceUrlProvider();
        ServiceUrlProvider other$serviceUrlProvider = other.getServiceUrlProvider();
        if (this$serviceUrlProvider == null ? other$serviceUrlProvider != null : !this$serviceUrlProvider.equals(other$serviceUrlProvider)) {
            return false;
        }
        Authentication this$authentication = this.getAuthentication();
        Authentication other$authentication = other.getAuthentication();
        if (this$authentication == null ? other$authentication != null : !this$authentication.equals(other$authentication)) {
            return false;
        }
        if (this.getOperationTimeoutMs() != other.getOperationTimeoutMs()) {
            return false;
        }
        if (this.getStatsIntervalSeconds() != other.getStatsIntervalSeconds()) {
            return false;
        }
        if (this.getNumIoThreads() != other.getNumIoThreads()) {
            return false;
        }
        if (this.getNumListenerThreads() != other.getNumListenerThreads()) {
            return false;
        }
        if (this.getConnectionsPerBroker() != other.getConnectionsPerBroker()) {
            return false;
        }
        if (this.isUseTcpNoDelay() != other.isUseTcpNoDelay()) {
            return false;
        }
        if (this.isUseTls() != other.isUseTls()) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isTlsHostnameVerificationEnable() != other.isTlsHostnameVerificationEnable()) {
            return false;
        }
        if (this.getConcurrentLookupRequest() != other.getConcurrentLookupRequest()) {
            return false;
        }
        if (this.getMaxLookupRequest() != other.getMaxLookupRequest()) {
            return false;
        }
        if (this.getMaxNumberOfRejectedRequestPerConnection() != other.getMaxNumberOfRejectedRequestPerConnection()) {
            return false;
        }
        if (this.getKeepAliveIntervalSeconds() != other.getKeepAliveIntervalSeconds()) {
            return false;
        }
        return this.getConnectionTimeoutMs() == other.getConnectionTimeoutMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        ServiceUrlProvider $serviceUrlProvider = this.getServiceUrlProvider();
        result = result * 59 + ($serviceUrlProvider == null ? 43 : $serviceUrlProvider.hashCode());
        Authentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : $authentication.hashCode());
        long $operationTimeoutMs = this.getOperationTimeoutMs();
        result = result * 59 + (int)($operationTimeoutMs >>> 32 ^ $operationTimeoutMs);
        long $statsIntervalSeconds = this.getStatsIntervalSeconds();
        result = result * 59 + (int)($statsIntervalSeconds >>> 32 ^ $statsIntervalSeconds);
        result = result * 59 + this.getNumIoThreads();
        result = result * 59 + this.getNumListenerThreads();
        result = result * 59 + this.getConnectionsPerBroker();
        result = result * 59 + (this.isUseTcpNoDelay() ? 79 : 97);
        result = result * 59 + (this.isUseTls() ? 79 : 97);
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isTlsHostnameVerificationEnable() ? 79 : 97);
        result = result * 59 + this.getConcurrentLookupRequest();
        result = result * 59 + this.getMaxLookupRequest();
        result = result * 59 + this.getMaxNumberOfRejectedRequestPerConnection();
        result = result * 59 + this.getKeepAliveIntervalSeconds();
        result = result * 59 + this.getConnectionTimeoutMs();
        return result;
    }

    public String toString() {
        return "ClientConfigurationData(serviceUrl=" + this.getServiceUrl() + ", serviceUrlProvider=" + this.getServiceUrlProvider() + ", authentication=" + this.getAuthentication() + ", operationTimeoutMs=" + this.getOperationTimeoutMs() + ", statsIntervalSeconds=" + this.getStatsIntervalSeconds() + ", numIoThreads=" + this.getNumIoThreads() + ", numListenerThreads=" + this.getNumListenerThreads() + ", connectionsPerBroker=" + this.getConnectionsPerBroker() + ", useTcpNoDelay=" + this.isUseTcpNoDelay() + ", useTls=" + this.isUseTls() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", tlsHostnameVerificationEnable=" + this.isTlsHostnameVerificationEnable() + ", concurrentLookupRequest=" + this.getConcurrentLookupRequest() + ", maxLookupRequest=" + this.getMaxLookupRequest() + ", maxNumberOfRejectedRequestPerConnection=" + this.getMaxNumberOfRejectedRequestPerConnection() + ", keepAliveIntervalSeconds=" + this.getKeepAliveIntervalSeconds() + ", connectionTimeoutMs=" + this.getConnectionTimeoutMs() + ")";
    }
}

