/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.ByteBuffer;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class ByteBufferSchema
implements Schema<ByteBuffer> {
    private static final ByteBufferSchema INSTANCE = new ByteBufferSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("ByteBuffer").setType(SchemaType.BYTES).setSchema(new byte[0]);

    public static ByteBufferSchema of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(ByteBuffer data) {
        if (data == null) {
            return null;
        }
        data.rewind();
        if (data.hasArray()) {
            byte[] arr = data.array();
            if (data.arrayOffset() == 0 && arr.length == data.remaining()) {
                return arr;
            }
        }
        byte[] ret = new byte[data.remaining()];
        data.get(ret, 0, ret.length);
        data.rewind();
        return ret;
    }

    @Override
    public ByteBuffer decode(byte[] data) {
        if (null == data) {
            return null;
        }
        return ByteBuffer.wrap(data);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

