/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Parser;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.impl.schema.StructSchema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.protobuf.ProtobufDatumReader;

public class ProtobufSchema<T extends GeneratedMessageV3>
extends StructSchema<T> {
    private Parser<T> tParser;
    public static final String PARSING_INFO_PROPERTY = "__PARSING_INFO__";

    private static <T> Schema createProtobufAvroSchema(Class<T> pojo) {
        ProtobufDatumReader<T> datumReader = new ProtobufDatumReader<T>(pojo);
        return datumReader.getSchema();
    }

    private ProtobufSchema(Map<String, String> properties, Class<T> pojo) {
        super(SchemaType.PROTOBUF, ProtobufSchema.createProtobufAvroSchema(pojo), properties);
        try {
            GeneratedMessageV3 protoMessageInstance = (GeneratedMessageV3)pojo.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
            this.tParser = protoMessageInstance.getParserForType();
            HashMap<String, String> allProperties = new HashMap<String, String>();
            allProperties.putAll(this.schemaInfo.getProperties());
            allProperties.put(PARSING_INFO_PROPERTY, this.getParsingInfo(protoMessageInstance));
            this.schemaInfo.setProperties(allProperties);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private String getParsingInfo(T protoMessageInstance) {
        final LinkedList protoBufParsingInfos = new LinkedList();
        protoMessageInstance.getDescriptorForType().getFields().forEach(new Consumer<Descriptors.FieldDescriptor>(){

            @Override
            public void accept(Descriptors.FieldDescriptor fieldDescriptor) {
                protoBufParsingInfos.add(new ProtoBufParsingInfo(fieldDescriptor.getNumber(), fieldDescriptor.getName(), fieldDescriptor.getType().name(), fieldDescriptor.toProto().getLabel().name(), null));
            }
        });
        try {
            return new ObjectMapper().writeValueAsString(protoBufParsingInfos);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] encode(T message) {
        return message.toByteArray();
    }

    @Override
    public T decode(byte[] bytes) {
        try {
            return (T)((GeneratedMessageV3)this.tParser.parseFrom(bytes));
        }
        catch (Exception e) {
            throw new RuntimeException(new SchemaSerializationException(e));
        }
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public static <T extends GeneratedMessageV3> ProtobufSchema<T> of(Class<T> pojo) {
        return ProtobufSchema.of(pojo, Collections.emptyMap());
    }

    public static ProtobufSchema ofGenericClass(Class pojo, Map<String, String> properties) {
        if (!GeneratedMessageV3.class.isAssignableFrom(pojo)) {
            throw new IllegalArgumentException(GeneratedMessageV3.class.getName() + " is not assignable from " + pojo.getName());
        }
        return new ProtobufSchema(properties, pojo);
    }

    public static <T extends GeneratedMessageV3> ProtobufSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        return ProtobufSchema.ofGenericClass(pojo, properties);
    }

    public static class ProtoBufParsingInfo {
        private final int number;
        private final String name;
        private final String type;
        private final String label;
        private final Map<String, Object> definition;

        public int getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getLabel() {
            return this.label;
        }

        public Map<String, Object> getDefinition() {
            return this.definition;
        }

        public ProtoBufParsingInfo(int number, String name, String type, String label, Map<String, Object> definition) {
            this.number = number;
            this.name = name;
            this.type = type;
            this.label = label;
            this.definition = definition;
        }
    }
}

