/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class ShortSchema
implements Schema<Short> {
    private static final ShortSchema INSTANCE = new ShortSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("INT16").setType(SchemaType.INT16).setSchema(new byte[0]);

    public static ShortSchema of() {
        return INSTANCE;
    }

    @Override
    public void validate(byte[] message) {
        if (message.length != 2) {
            throw new SchemaSerializationException("Size of data received by ShortSchema is not 2");
        }
    }

    @Override
    public byte[] encode(Short message) {
        if (null == message) {
            return null;
        }
        return new byte[]{(byte)(message >>> 8), message.byteValue()};
    }

    @Override
    public Short decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        short value = 0;
        for (byte b : bytes) {
            value = (short)(value << 8);
            value = (short)(value | b & 0xFF);
        }
        return value;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

