/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class StringSchema
implements Schema<String> {
    private static final StringSchema UTF8 = new StringSchema(StandardCharsets.UTF_8);
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("String").setType(SchemaType.STRING).setSchema(new byte[0]);
    private final Charset charset;
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    public static StringSchema utf8() {
        return UTF8;
    }

    public StringSchema() {
        this.charset = DEFAULT_CHARSET;
    }

    public StringSchema(Charset charset) {
        this.charset = charset;
    }

    @Override
    public byte[] encode(String message) {
        if (null == message) {
            return null;
        }
        return message.getBytes(this.charset);
    }

    @Override
    public String decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        return new String(bytes, this.charset);
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

