/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;

abstract class StructSchema<T>
implements org.apache.pulsar.client.api.Schema<T> {
    protected final Schema schema;
    protected final SchemaInfo schemaInfo;

    protected StructSchema(SchemaType schemaType, Schema schema, Map<String, String> properties) {
        this.schema = schema;
        this.schemaInfo = new SchemaInfo();
        this.schemaInfo.setName("");
        this.schemaInfo.setType(schemaType);
        this.schemaInfo.setSchema(this.schema.toString().getBytes(StandardCharsets.UTF_8));
        this.schemaInfo.setProperties(properties);
    }

    protected Schema getAvroSchema() {
        return this.schema;
    }

    @Override
    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    protected static Schema createAvroSchema(SchemaDefinition schemaDefinition) {
        Class pojo = schemaDefinition.getPojo();
        return schemaDefinition.getAlwaysAllowNull() ? ReflectData.AllowNull.get().getSchema(pojo) : ReflectData.get().getSchema(pojo);
    }

    protected static Schema parseAvroSchema(String jsonDef) {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(jsonDef);
    }
}

