/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.policies.data;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.pulsar.common.policies.data.AuthPolicies;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.BundlesData;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SchemaAutoUpdateCompatibilityStrategy;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.SubscriptionAuthMode;
import org.apache.pulsar.shade.com.google.common.base.MoreObjects;
import org.apache.pulsar.shade.com.google.common.collect.Lists;
import org.apache.pulsar.shade.com.google.common.collect.Maps;
import org.apache.pulsar.shade.com.google.common.collect.Sets;

public class Policies {
    public final AuthPolicies auth_policies = new AuthPolicies();
    public Set<String> replication_clusters = Sets.newHashSet();
    public BundlesData bundles;
    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> backlog_quota_map = Maps.newHashMap();
    public Map<String, DispatchRate> clusterDispatchRate = Maps.newHashMap();
    public Map<String, DispatchRate> subscriptionDispatchRate = Maps.newHashMap();
    public Map<String, SubscribeRate> clusterSubscribeRate = Maps.newHashMap();
    public PersistencePolicies persistence = null;
    public Boolean deduplicationEnabled = null;
    public Map<String, Integer> latency_stats_sample_rate = Maps.newHashMap();
    public int message_ttl_in_seconds = 0;
    public RetentionPolicies retention_policies = null;
    public boolean deleted = false;
    public String antiAffinityGroup;
    public static final String FIRST_BOUNDARY = "0x00000000";
    public static final String LAST_BOUNDARY = "0xffffffff";
    public boolean encryption_required = false;
    public SubscriptionAuthMode subscription_auth_mode = SubscriptionAuthMode.None;
    public int max_producers_per_topic = 0;
    public int max_consumers_per_topic = 0;
    public int max_consumers_per_subscription = 0;
    public long compaction_threshold = 0L;
    public long offload_threshold = -1L;
    public Long offload_deletion_lag_ms = null;
    public SchemaAutoUpdateCompatibilityStrategy schema_auto_update_compatibility_strategy = SchemaAutoUpdateCompatibilityStrategy.Full;

    public boolean equals(Object obj) {
        if (obj instanceof Policies) {
            Policies other = (Policies)obj;
            return Objects.equals(this.auth_policies, other.auth_policies) && Objects.equals(this.replication_clusters, other.replication_clusters) && Objects.equals(this.backlog_quota_map, other.backlog_quota_map) && Objects.equals(this.clusterDispatchRate, other.clusterDispatchRate) && Objects.equals(this.clusterSubscribeRate, other.clusterSubscribeRate) && Objects.equals(this.deduplicationEnabled, other.deduplicationEnabled) && Objects.equals(this.persistence, other.persistence) && Objects.equals(this.bundles, other.bundles) && Objects.equals(this.latency_stats_sample_rate, other.latency_stats_sample_rate) && this.message_ttl_in_seconds == other.message_ttl_in_seconds && Objects.equals(this.retention_policies, other.retention_policies) && Objects.equals(this.encryption_required, other.encryption_required) && Objects.equals((Object)this.subscription_auth_mode, (Object)other.subscription_auth_mode) && Objects.equals(this.antiAffinityGroup, other.antiAffinityGroup) && this.max_producers_per_topic == other.max_producers_per_topic && this.max_consumers_per_topic == other.max_consumers_per_topic && this.max_consumers_per_subscription == other.max_consumers_per_subscription && this.compaction_threshold == other.compaction_threshold && this.offload_threshold == other.offload_threshold && this.offload_deletion_lag_ms == other.offload_deletion_lag_ms && this.schema_auto_update_compatibility_strategy == other.schema_auto_update_compatibility_strategy;
        }
        return false;
    }

    public static BundlesData defaultBundle() {
        BundlesData bundle = new BundlesData(1);
        ArrayList<String> boundaries = Lists.newArrayList();
        boundaries.add(FIRST_BOUNDARY);
        boundaries.add(LAST_BOUNDARY);
        bundle.setBoundaries(boundaries);
        return bundle;
    }

    public static void setStorageQuota(Policies polices, BacklogQuota quota) {
        if (polices == null) {
            return;
        }
        polices.backlog_quota_map.put(BacklogQuota.BacklogQuotaType.destination_storage, quota);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("auth_policies", this.auth_policies).add("replication_clusters", this.replication_clusters).add("bundles", this.bundles).add("backlog_quota_map", this.backlog_quota_map).add("persistence", this.persistence).add("deduplicationEnabled", this.deduplicationEnabled).add("clusterDispatchRate", this.clusterDispatchRate).add("clusterSubscribeRate", this.clusterSubscribeRate).add("latency_stats_sample_rate", this.latency_stats_sample_rate).add("antiAffinityGroup", this.antiAffinityGroup).add("message_ttl_in_seconds", this.message_ttl_in_seconds).add("retention_policies", this.retention_policies).add("deleted", this.deleted).add("encryption_required", this.encryption_required).add("subscription_auth_mode", (Object)this.subscription_auth_mode).add("max_producers_per_topic", this.max_producers_per_topic).add("max_consumers_per_topic", this.max_consumers_per_topic).add("max_consumers_per_subscription", this.max_consumers_per_topic).add("compaction_threshold", this.compaction_threshold).add("offload_threshold", this.offload_threshold).add("offload_deletion_lag_ms", this.offload_deletion_lag_ms).add("schema_auto_update_compatibility_strategy", (Object)this.schema_auto_update_compatibility_strategy).toString();
    }
}

