/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.apache.avro.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.generic.GenericDatumReader;
import org.apache.pulsar.shade.org.apache.avro.io.Decoder;
import org.apache.pulsar.shade.org.apache.avro.io.ResolvingDecoder;
import org.apache.pulsar.shade.org.apache.avro.protobuf.ProtobufData;
import org.apache.pulsar.shade.org.apache.avro.specific.SpecificData;
import org.apache.pulsar.shade.org.apache.avro.util.ClassUtils;

public class ProtobufDatumReader<T>
extends GenericDatumReader<T> {
    public ProtobufDatumReader() {
        this(null, null, ProtobufData.get());
    }

    public ProtobufDatumReader(Class<T> c) {
        this(ProtobufData.get().getSchema(c));
    }

    public ProtobufDatumReader(Schema schema) {
        this(schema, schema, ProtobufData.get());
    }

    public ProtobufDatumReader(Schema writer, Schema reader) {
        this(writer, reader, ProtobufData.get());
    }

    protected ProtobufDatumReader(Schema writer, Schema reader, ProtobufData data) {
        super(writer, reader, data);
    }

    @Override
    protected Object readRecord(Object old, Schema expected, ResolvingDecoder in) throws IOException {
        Message.Builder b = (Message.Builder)super.readRecord(old, expected, in);
        return b.build();
    }

    @Override
    protected Object createEnum(String symbol, Schema schema) {
        try {
            Class<?> c = ClassUtils.forName(SpecificData.getClassName(schema));
            if (c == null) {
                return super.createEnum(symbol, schema);
            }
            return ((ProtocolMessageEnum)Enum.valueOf(c, symbol)).getValueDescriptor();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected Object readBytes(Object old, Decoder in) throws IOException {
        return ByteString.copyFrom((byte[])((ByteBuffer)super.readBytes(old, in)).array());
    }
}

