/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.nio.charset.StandardCharsets;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Schemas;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.protocol.schema.DeleteSchemaResponse;
import org.apache.pulsar.common.protocol.schema.GetSchemaResponse;
import org.apache.pulsar.common.protocol.schema.PostSchemaPayload;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;

public class SchemasImpl
extends BaseResource
implements Schemas {
    private final WebTarget target;

    public SchemasImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.target = web.path("/admin/v2/schemas");
    }

    @Override
    public SchemaInfo getSchemaInfo(String topic) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            GetSchemaResponse response = this.request(this.schemaPath(tn)).get(GetSchemaResponse.class);
            return SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public SchemaInfo getSchemaInfo(String topic, long version) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            GetSchemaResponse response = this.request(this.schemaPath(tn).path(Long.toString(version))).get(GetSchemaResponse.class);
            return SchemasImpl.convertGetSchemaResponseToSchemaInfo(tn, response);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void deleteSchema(String topic) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            this.request(this.schemaPath(tn)).delete(DeleteSchemaResponse.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    @Override
    public void createSchema(String topic, SchemaInfo schemaInfo) throws PulsarAdminException {
        PostSchemaPayload payload = new PostSchemaPayload();
        payload.setType(schemaInfo.getType().name());
        payload.setProperties(schemaInfo.getProperties());
        payload.setSchema(SchemasImpl.convertSchemaDataToStringLegacy(schemaInfo.getSchema()));
        this.createSchema(topic, payload);
    }

    @Override
    public void createSchema(String topic, PostSchemaPayload payload) throws PulsarAdminException {
        try {
            TopicName tn = TopicName.get(topic);
            this.request(this.schemaPath(tn)).post(Entity.json(payload), ErrorData.class);
        }
        catch (Exception e) {
            throw this.getApiException(e);
        }
    }

    private WebTarget schemaPath(TopicName topicName) {
        return this.target.path(topicName.getTenant()).path(topicName.getNamespacePortion()).path(topicName.getEncodedLocalName()).path("schema");
    }

    static SchemaInfo convertGetSchemaResponseToSchemaInfo(TopicName tn, GetSchemaResponse response) {
        SchemaInfo info = new SchemaInfo();
        info.setSchema(response.getData().getBytes(StandardCharsets.UTF_8));
        info.setType(response.getType());
        info.setProperties(response.getProperties());
        info.setName(tn.getLocalName());
        return info;
    }

    static String convertSchemaDataToStringLegacy(byte[] schemaData) {
        if (null == schemaData) {
            return "";
        }
        return new String(schemaData, StandardCharsets.UTF_8);
    }
}

