/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.time.Clock;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.shade.com.google.common.annotations.VisibleForTesting;

public class Backoff {
    public static final long DEFAULT_INTERVAL_IN_NANOSECONDS = TimeUnit.MILLISECONDS.toNanos(100L);
    public static final long MAX_BACKOFF_INTERVAL_NANOSECONDS = TimeUnit.SECONDS.toNanos(30L);
    private final long backoffIntervalNanos;
    private final long maxBackoffIntervalNanos;
    private final long initial;
    private final long max;
    private final Clock clock;
    private long next;
    private long mandatoryStop;
    private long firstBackoffTimeInMillis;
    private boolean mandatoryStopMade = false;
    private static final Random random = new Random();

    @VisibleForTesting
    Backoff(long initial, TimeUnit unitInitial, long max, TimeUnit unitMax, long mandatoryStop, TimeUnit unitMandatoryStop, Clock clock, long backoffIntervalNanos, long maxBackoffIntervalNanos) {
        this.initial = unitInitial.toMillis(initial);
        this.max = unitMax.toMillis(max);
        this.next = this.initial;
        this.mandatoryStop = unitMandatoryStop.toMillis(mandatoryStop);
        this.clock = clock;
        this.backoffIntervalNanos = backoffIntervalNanos;
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
    }

    @VisibleForTesting
    Backoff(long initial, TimeUnit unitInitial, long max, TimeUnit unitMax, long mandatoryStop, TimeUnit unitMandatoryStop, Clock clock) {
        this(initial, unitInitial, max, unitMax, mandatoryStop, unitMandatoryStop, clock, DEFAULT_INTERVAL_IN_NANOSECONDS, MAX_BACKOFF_INTERVAL_NANOSECONDS);
    }

    public Backoff(long initial, TimeUnit unitInitial, long max, TimeUnit unitMax, long mandatoryStop, TimeUnit unitMandatoryStop) {
        this(initial, unitInitial, max, unitMax, mandatoryStop, unitMandatoryStop, Clock.systemDefaultZone());
    }

    public Backoff(long initial, TimeUnit unitInitial, long max, TimeUnit unitMax, long mandatoryStop, TimeUnit unitMandatoryStop, long backoffIntervalMs, long maxBackoffIntervalMs) {
        this(initial, unitInitial, max, unitMax, mandatoryStop, unitMandatoryStop, Clock.systemDefaultZone(), backoffIntervalMs, maxBackoffIntervalMs);
    }

    public long next() {
        long current = this.next;
        if (current < this.max) {
            this.next = Math.min(this.next * 2L, this.max);
        }
        if (!this.mandatoryStopMade) {
            long now = this.clock.millis();
            long timeElapsedSinceFirstBackoff = 0L;
            if (this.initial == current) {
                this.firstBackoffTimeInMillis = now;
            } else {
                timeElapsedSinceFirstBackoff = now - this.firstBackoffTimeInMillis;
            }
            if (timeElapsedSinceFirstBackoff + current > this.mandatoryStop) {
                current = Math.max(this.initial, this.mandatoryStop - timeElapsedSinceFirstBackoff);
                this.mandatoryStopMade = true;
            }
        }
        if (current > 10L) {
            current -= (long)random.nextInt((int)current / 10);
        }
        return Math.max(this.initial, current);
    }

    public void reduceToHalf() {
        if (this.next > this.initial) {
            this.next = Math.max(this.next / 2L, this.initial);
        }
    }

    public void reset() {
        this.next = this.initial;
        this.mandatoryStopMade = false;
    }

    @VisibleForTesting
    long getFirstBackoffTimeInMillis() {
        return this.firstBackoffTimeInMillis;
    }

    @VisibleForTesting
    long backoffIntervalNanos() {
        return this.backoffIntervalNanos;
    }

    @VisibleForTesting
    long maxBackoffIntervalNanos() {
        return this.maxBackoffIntervalNanos;
    }

    public static boolean shouldBackoff(long initialTimestamp, TimeUnit unitInitial, int failedAttempts, long defaultInterval, long maxBackoffInterval) {
        long initialTimestampInNano = unitInitial.toNanos(initialTimestamp);
        long currentTime = System.nanoTime();
        long interval = defaultInterval;
        for (int i = 1; i < failedAttempts; ++i) {
            if ((interval *= 2L) <= maxBackoffInterval) continue;
            interval = maxBackoffInterval;
            break;
        }
        return currentTime < initialTimestampInNano + interval;
    }

    public static boolean shouldBackoff(long initialTimestamp, TimeUnit unitInitial, int failedAttempts) {
        return Backoff.shouldBackoff(initialTimestamp, unitInitial, failedAttempts, DEFAULT_INTERVAL_IN_NANOSECONDS, MAX_BACKOFF_INTERVAL_NANOSECONDS);
    }
}

