/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.conf;

import java.io.Serializable;
import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.ServiceUrlProvider;
import org.apache.pulsar.client.impl.auth.AuthenticationDisabled;
import org.apache.pulsar.shade.com.fasterxml.jackson.annotation.JsonIgnore;

public class ClientConfigurationData
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private String serviceUrl;
    @JsonIgnore
    private transient ServiceUrlProvider serviceUrlProvider;
    @JsonIgnore
    private transient Authentication authentication = new AuthenticationDisabled();
    private String authPluginClassName;
    private String authParams;
    private long operationTimeoutMs = 30000L;
    private long statsIntervalSeconds = 60L;
    private int numIoThreads = 1;
    private int numListenerThreads = 1;
    private int connectionsPerBroker = 1;
    private boolean useTcpNoDelay = true;
    private boolean useTls = false;
    private String tlsTrustCertsFilePath = "";
    private boolean tlsAllowInsecureConnection = false;
    private boolean tlsHostnameVerificationEnable = false;
    private int concurrentLookupRequest = 5000;
    private int maxLookupRequest = 50000;
    private int maxNumberOfRejectedRequestPerConnection = 50;
    private int keepAliveIntervalSeconds = 30;
    private int connectionTimeoutMs = 10000;
    private int requestTimeoutMs = 60000;
    private long defaultBackoffIntervalNanos = TimeUnit.MILLISECONDS.toNanos(100L);
    private long maxBackoffIntervalNanos = TimeUnit.SECONDS.toNanos(30L);
    @JsonIgnore
    private Clock clock = Clock.systemDefaultZone();

    public Authentication getAuthentication() {
        if (this.authentication == null) {
            this.authentication = new AuthenticationDisabled();
        }
        return this.authentication;
    }

    public boolean isUseTls() {
        if (this.useTls) {
            return true;
        }
        if (this.getServiceUrl() != null && (this.getServiceUrl().startsWith("pulsar+ssl") || this.getServiceUrl().startsWith("https"))) {
            this.useTls = true;
            return true;
        }
        return false;
    }

    public ClientConfigurationData clone() {
        try {
            return (ClientConfigurationData)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Failed to clone ClientConfigurationData");
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public ServiceUrlProvider getServiceUrlProvider() {
        return this.serviceUrlProvider;
    }

    public String getAuthPluginClassName() {
        return this.authPluginClassName;
    }

    public String getAuthParams() {
        return this.authParams;
    }

    public long getOperationTimeoutMs() {
        return this.operationTimeoutMs;
    }

    public long getStatsIntervalSeconds() {
        return this.statsIntervalSeconds;
    }

    public int getNumIoThreads() {
        return this.numIoThreads;
    }

    public int getNumListenerThreads() {
        return this.numListenerThreads;
    }

    public int getConnectionsPerBroker() {
        return this.connectionsPerBroker;
    }

    public boolean isUseTcpNoDelay() {
        return this.useTcpNoDelay;
    }

    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    public boolean isTlsHostnameVerificationEnable() {
        return this.tlsHostnameVerificationEnable;
    }

    public int getConcurrentLookupRequest() {
        return this.concurrentLookupRequest;
    }

    public int getMaxLookupRequest() {
        return this.maxLookupRequest;
    }

    public int getMaxNumberOfRejectedRequestPerConnection() {
        return this.maxNumberOfRejectedRequestPerConnection;
    }

    public int getKeepAliveIntervalSeconds() {
        return this.keepAliveIntervalSeconds;
    }

    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public long getDefaultBackoffIntervalNanos() {
        return this.defaultBackoffIntervalNanos;
    }

    public long getMaxBackoffIntervalNanos() {
        return this.maxBackoffIntervalNanos;
    }

    public Clock getClock() {
        return this.clock;
    }

    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    public void setServiceUrlProvider(ServiceUrlProvider serviceUrlProvider) {
        this.serviceUrlProvider = serviceUrlProvider;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setAuthPluginClassName(String authPluginClassName) {
        this.authPluginClassName = authPluginClassName;
    }

    public void setAuthParams(String authParams) {
        this.authParams = authParams;
    }

    public void setOperationTimeoutMs(long operationTimeoutMs) {
        this.operationTimeoutMs = operationTimeoutMs;
    }

    public void setStatsIntervalSeconds(long statsIntervalSeconds) {
        this.statsIntervalSeconds = statsIntervalSeconds;
    }

    public void setNumIoThreads(int numIoThreads) {
        this.numIoThreads = numIoThreads;
    }

    public void setNumListenerThreads(int numListenerThreads) {
        this.numListenerThreads = numListenerThreads;
    }

    public void setConnectionsPerBroker(int connectionsPerBroker) {
        this.connectionsPerBroker = connectionsPerBroker;
    }

    public void setUseTcpNoDelay(boolean useTcpNoDelay) {
        this.useTcpNoDelay = useTcpNoDelay;
    }

    public void setUseTls(boolean useTls) {
        this.useTls = useTls;
    }

    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    public void setTlsHostnameVerificationEnable(boolean tlsHostnameVerificationEnable) {
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
    }

    public void setConcurrentLookupRequest(int concurrentLookupRequest) {
        this.concurrentLookupRequest = concurrentLookupRequest;
    }

    public void setMaxLookupRequest(int maxLookupRequest) {
        this.maxLookupRequest = maxLookupRequest;
    }

    public void setMaxNumberOfRejectedRequestPerConnection(int maxNumberOfRejectedRequestPerConnection) {
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
    }

    public void setKeepAliveIntervalSeconds(int keepAliveIntervalSeconds) {
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
    }

    public void setConnectionTimeoutMs(int connectionTimeoutMs) {
        this.connectionTimeoutMs = connectionTimeoutMs;
    }

    public void setRequestTimeoutMs(int requestTimeoutMs) {
        this.requestTimeoutMs = requestTimeoutMs;
    }

    public void setDefaultBackoffIntervalNanos(long defaultBackoffIntervalNanos) {
        this.defaultBackoffIntervalNanos = defaultBackoffIntervalNanos;
    }

    public void setMaxBackoffIntervalNanos(long maxBackoffIntervalNanos) {
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfigurationData)) {
            return false;
        }
        ClientConfigurationData other = (ClientConfigurationData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceUrl = this.getServiceUrl();
        String other$serviceUrl = other.getServiceUrl();
        if (this$serviceUrl == null ? other$serviceUrl != null : !this$serviceUrl.equals(other$serviceUrl)) {
            return false;
        }
        String this$authPluginClassName = this.getAuthPluginClassName();
        String other$authPluginClassName = other.getAuthPluginClassName();
        if (this$authPluginClassName == null ? other$authPluginClassName != null : !this$authPluginClassName.equals(other$authPluginClassName)) {
            return false;
        }
        String this$authParams = this.getAuthParams();
        String other$authParams = other.getAuthParams();
        if (this$authParams == null ? other$authParams != null : !this$authParams.equals(other$authParams)) {
            return false;
        }
        if (this.getOperationTimeoutMs() != other.getOperationTimeoutMs()) {
            return false;
        }
        if (this.getStatsIntervalSeconds() != other.getStatsIntervalSeconds()) {
            return false;
        }
        if (this.getNumIoThreads() != other.getNumIoThreads()) {
            return false;
        }
        if (this.getNumListenerThreads() != other.getNumListenerThreads()) {
            return false;
        }
        if (this.getConnectionsPerBroker() != other.getConnectionsPerBroker()) {
            return false;
        }
        if (this.isUseTcpNoDelay() != other.isUseTcpNoDelay()) {
            return false;
        }
        if (this.isUseTls() != other.isUseTls()) {
            return false;
        }
        String this$tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        String other$tlsTrustCertsFilePath = other.getTlsTrustCertsFilePath();
        if (this$tlsTrustCertsFilePath == null ? other$tlsTrustCertsFilePath != null : !this$tlsTrustCertsFilePath.equals(other$tlsTrustCertsFilePath)) {
            return false;
        }
        if (this.isTlsAllowInsecureConnection() != other.isTlsAllowInsecureConnection()) {
            return false;
        }
        if (this.isTlsHostnameVerificationEnable() != other.isTlsHostnameVerificationEnable()) {
            return false;
        }
        if (this.getConcurrentLookupRequest() != other.getConcurrentLookupRequest()) {
            return false;
        }
        if (this.getMaxLookupRequest() != other.getMaxLookupRequest()) {
            return false;
        }
        if (this.getMaxNumberOfRejectedRequestPerConnection() != other.getMaxNumberOfRejectedRequestPerConnection()) {
            return false;
        }
        if (this.getKeepAliveIntervalSeconds() != other.getKeepAliveIntervalSeconds()) {
            return false;
        }
        if (this.getConnectionTimeoutMs() != other.getConnectionTimeoutMs()) {
            return false;
        }
        if (this.getRequestTimeoutMs() != other.getRequestTimeoutMs()) {
            return false;
        }
        if (this.getDefaultBackoffIntervalNanos() != other.getDefaultBackoffIntervalNanos()) {
            return false;
        }
        if (this.getMaxBackoffIntervalNanos() != other.getMaxBackoffIntervalNanos()) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        return !(this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfigurationData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceUrl = this.getServiceUrl();
        result = result * 59 + ($serviceUrl == null ? 43 : $serviceUrl.hashCode());
        String $authPluginClassName = this.getAuthPluginClassName();
        result = result * 59 + ($authPluginClassName == null ? 43 : $authPluginClassName.hashCode());
        String $authParams = this.getAuthParams();
        result = result * 59 + ($authParams == null ? 43 : $authParams.hashCode());
        long $operationTimeoutMs = this.getOperationTimeoutMs();
        result = result * 59 + (int)($operationTimeoutMs >>> 32 ^ $operationTimeoutMs);
        long $statsIntervalSeconds = this.getStatsIntervalSeconds();
        result = result * 59 + (int)($statsIntervalSeconds >>> 32 ^ $statsIntervalSeconds);
        result = result * 59 + this.getNumIoThreads();
        result = result * 59 + this.getNumListenerThreads();
        result = result * 59 + this.getConnectionsPerBroker();
        result = result * 59 + (this.isUseTcpNoDelay() ? 79 : 97);
        result = result * 59 + (this.isUseTls() ? 79 : 97);
        String $tlsTrustCertsFilePath = this.getTlsTrustCertsFilePath();
        result = result * 59 + ($tlsTrustCertsFilePath == null ? 43 : $tlsTrustCertsFilePath.hashCode());
        result = result * 59 + (this.isTlsAllowInsecureConnection() ? 79 : 97);
        result = result * 59 + (this.isTlsHostnameVerificationEnable() ? 79 : 97);
        result = result * 59 + this.getConcurrentLookupRequest();
        result = result * 59 + this.getMaxLookupRequest();
        result = result * 59 + this.getMaxNumberOfRejectedRequestPerConnection();
        result = result * 59 + this.getKeepAliveIntervalSeconds();
        result = result * 59 + this.getConnectionTimeoutMs();
        result = result * 59 + this.getRequestTimeoutMs();
        long $defaultBackoffIntervalNanos = this.getDefaultBackoffIntervalNanos();
        result = result * 59 + (int)($defaultBackoffIntervalNanos >>> 32 ^ $defaultBackoffIntervalNanos);
        long $maxBackoffIntervalNanos = this.getMaxBackoffIntervalNanos();
        result = result * 59 + (int)($maxBackoffIntervalNanos >>> 32 ^ $maxBackoffIntervalNanos);
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        return result;
    }

    public String toString() {
        return "ClientConfigurationData(serviceUrl=" + this.getServiceUrl() + ", serviceUrlProvider=" + this.getServiceUrlProvider() + ", authentication=" + this.getAuthentication() + ", authPluginClassName=" + this.getAuthPluginClassName() + ", authParams=" + this.getAuthParams() + ", operationTimeoutMs=" + this.getOperationTimeoutMs() + ", statsIntervalSeconds=" + this.getStatsIntervalSeconds() + ", numIoThreads=" + this.getNumIoThreads() + ", numListenerThreads=" + this.getNumListenerThreads() + ", connectionsPerBroker=" + this.getConnectionsPerBroker() + ", useTcpNoDelay=" + this.isUseTcpNoDelay() + ", useTls=" + this.isUseTls() + ", tlsTrustCertsFilePath=" + this.getTlsTrustCertsFilePath() + ", tlsAllowInsecureConnection=" + this.isTlsAllowInsecureConnection() + ", tlsHostnameVerificationEnable=" + this.isTlsHostnameVerificationEnable() + ", concurrentLookupRequest=" + this.getConcurrentLookupRequest() + ", maxLookupRequest=" + this.getMaxLookupRequest() + ", maxNumberOfRejectedRequestPerConnection=" + this.getMaxNumberOfRejectedRequestPerConnection() + ", keepAliveIntervalSeconds=" + this.getKeepAliveIntervalSeconds() + ", connectionTimeoutMs=" + this.getConnectionTimeoutMs() + ", requestTimeoutMs=" + this.getRequestTimeoutMs() + ", defaultBackoffIntervalNanos=" + this.getDefaultBackoffIntervalNanos() + ", maxBackoffIntervalNanos=" + this.getMaxBackoffIntervalNanos() + ", clock=" + this.getClock() + ")";
    }

    public ClientConfigurationData() {
    }

    public ClientConfigurationData(String serviceUrl, ServiceUrlProvider serviceUrlProvider, Authentication authentication, String authPluginClassName, String authParams, long operationTimeoutMs, long statsIntervalSeconds, int numIoThreads, int numListenerThreads, int connectionsPerBroker, boolean useTcpNoDelay, boolean useTls, String tlsTrustCertsFilePath, boolean tlsAllowInsecureConnection, boolean tlsHostnameVerificationEnable, int concurrentLookupRequest, int maxLookupRequest, int maxNumberOfRejectedRequestPerConnection, int keepAliveIntervalSeconds, int connectionTimeoutMs, int requestTimeoutMs, long defaultBackoffIntervalNanos, long maxBackoffIntervalNanos, Clock clock) {
        this.serviceUrl = serviceUrl;
        this.serviceUrlProvider = serviceUrlProvider;
        this.authentication = authentication;
        this.authPluginClassName = authPluginClassName;
        this.authParams = authParams;
        this.operationTimeoutMs = operationTimeoutMs;
        this.statsIntervalSeconds = statsIntervalSeconds;
        this.numIoThreads = numIoThreads;
        this.numListenerThreads = numListenerThreads;
        this.connectionsPerBroker = connectionsPerBroker;
        this.useTcpNoDelay = useTcpNoDelay;
        this.useTls = useTls;
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
        this.tlsHostnameVerificationEnable = tlsHostnameVerificationEnable;
        this.concurrentLookupRequest = concurrentLookupRequest;
        this.maxLookupRequest = maxLookupRequest;
        this.maxNumberOfRejectedRequestPerConnection = maxNumberOfRejectedRequestPerConnection;
        this.keepAliveIntervalSeconds = keepAliveIntervalSeconds;
        this.connectionTimeoutMs = connectionTimeoutMs;
        this.requestTimeoutMs = requestTimeoutMs;
        this.defaultBackoffIntervalNanos = defaultBackoffIntervalNanos;
        this.maxBackoffIntervalNanos = maxBackoffIntervalNanos;
        this.clock = clock;
    }
}

