/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.Conversions;
import org.apache.avro.data.TimeConversions;
import org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.client.impl.schema.StructSchema;
import org.apache.pulsar.client.impl.schema.reader.AvroReader;
import org.apache.pulsar.client.impl.schema.writer.AvroWriter;
import org.apache.pulsar.common.protocol.schema.BytesSchemaVersion;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema<T>
extends StructSchema<T> {
    private static final Logger log;
    private static final Logger LOG;

    private AvroSchema(SchemaInfo schemaInfo) {
        super(schemaInfo);
        this.setReader(new AvroReader(this.schema));
        this.setWriter(new AvroWriter(this.schema));
    }

    public boolean supportSchemaVersioning() {
        return true;
    }

    public static <T> AvroSchema<T> of(SchemaDefinition<T> schemaDefinition) {
        return new AvroSchema<T>(AvroSchema.parseSchemaInfo(schemaDefinition, SchemaType.AVRO));
    }

    public static <T> AvroSchema<T> of(Class<T> pojo) {
        return AvroSchema.of(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> AvroSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        SchemaDefinition schemaDefinition = SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build();
        return new AvroSchema<T>(AvroSchema.parseSchemaInfo(schemaDefinition, SchemaType.AVRO));
    }

    @Override
    protected SchemaReader<T> loadReader(BytesSchemaVersion schemaVersion) {
        SchemaInfo schemaInfo = this.getSchemaInfoByVersion(schemaVersion.get());
        if (schemaInfo != null) {
            log.info("Load schema reader for version({}), schema is : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)schemaInfo.getSchemaDefinition());
            return new AvroReader(AvroSchema.parseAvroSchema(schemaInfo.getSchemaDefinition()), this.schema);
        }
        log.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion.get()), (Object)this.schemaInfo.getSchemaDefinition());
        return this.reader;
    }

    static {
        block2: {
            log = LoggerFactory.getLogger(AvroSchema.class);
            LOG = LoggerFactory.getLogger(AvroSchema.class);
            try {
                ReflectData.AllowNull reflectDataAllowNull = ReflectData.AllowNull.get();
                reflectDataAllowNull.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
                reflectDataAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.DateConversion());
                reflectDataAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.LossyTimeMicrosConversion());
                reflectDataAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.LossyTimestampMicrosConversion());
                reflectDataAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMicrosConversion());
                reflectDataAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMicrosConversion());
                reflectDataAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampConversion());
                reflectDataAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.TimeConversion());
                ReflectData reflectDataNotAllowNull = ReflectData.get();
                reflectDataNotAllowNull.addLogicalTypeConversion((Conversion)new Conversions.DecimalConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.DateConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.LossyTimeMicrosConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.LossyTimestampMicrosConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.TimeMicrosConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.TimestampMicrosConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion((Conversion)new TimeConversions.TimeConversion());
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Avro logical types are not available. If you are going to use avro logical types, you can include `joda-time` in your dependency.");
            }
        }
    }
}

