/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.asynchttpclient.netty.request.body;

import org.apache.pulsar.shade.io.netty.channel.Channel;
import org.apache.pulsar.shade.io.netty.channel.ChannelProgressiveFuture;
import org.apache.pulsar.shade.io.netty.handler.codec.http.LastHttpContent;
import org.apache.pulsar.shade.io.netty.handler.stream.ChunkedWriteHandler;
import org.apache.pulsar.shade.org.asynchttpclient.AsyncHttpClientConfig;
import org.apache.pulsar.shade.org.asynchttpclient.netty.NettyResponseFuture;
import org.apache.pulsar.shade.org.asynchttpclient.netty.channel.ChannelManager;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.WriteProgressListener;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.body.BodyChunkedInput;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.body.BodyFileRegion;
import org.apache.pulsar.shade.org.asynchttpclient.netty.request.body.NettyBody;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.Body;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.RandomAccessBody;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.generator.BodyGenerator;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.generator.FeedListener;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.generator.FeedableBodyGenerator;
import org.apache.pulsar.shade.org.asynchttpclient.request.body.generator.ReactiveStreamsBodyGenerator;
import org.apache.pulsar.shade.org.asynchttpclient.util.MiscUtils;

public class NettyBodyBody
implements NettyBody {
    private final Body body;
    private final AsyncHttpClientConfig config;

    public NettyBodyBody(Body body, AsyncHttpClientConfig config) {
        this.body = body;
        this.config = config;
    }

    public Body getBody() {
        return this.body;
    }

    @Override
    public long getContentLength() {
        return this.body.getContentLength();
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) {
        Object msg;
        if (this.body instanceof RandomAccessBody && !ChannelManager.isSslHandlerConfigured(channel.pipeline()) && !this.config.isDisableZeroCopy() && this.getContentLength() > 0L) {
            msg = new BodyFileRegion((RandomAccessBody)this.body);
        } else {
            msg = new BodyChunkedInput(this.body);
            BodyGenerator bg = future.getTargetRequest().getBodyGenerator();
            if (bg instanceof FeedableBodyGenerator && !(bg instanceof ReactiveStreamsBodyGenerator)) {
                final ChunkedWriteHandler chunkedWriteHandler = channel.pipeline().get(ChunkedWriteHandler.class);
                ((FeedableBodyGenerator)FeedableBodyGenerator.class.cast(bg)).setListener(new FeedListener(){

                    @Override
                    public void onContentAdded() {
                        chunkedWriteHandler.resumeTransfer();
                    }

                    @Override
                    public void onError(Throwable t) {
                    }
                });
            }
        }
        channel.write(msg, channel.newProgressivePromise()).addListener(new WriteProgressListener(future, false, this.getContentLength()){

            @Override
            public void operationComplete(ChannelProgressiveFuture cf) {
                MiscUtils.closeSilently(NettyBodyBody.this.body);
                super.operationComplete(cf);
            }
        });
        channel.writeAndFlush(LastHttpContent.EMPTY_LAST_CONTENT, channel.voidPromise());
    }
}

