/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.glassfish.jersey.inject.hk2;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.pulsar.shade.org.glassfish.hk2.api.Factory;
import org.apache.pulsar.shade.org.glassfish.hk2.api.ServiceLocator;
import org.apache.pulsar.shade.org.glassfish.hk2.utilities.reflection.ParameterizedTypeImpl;
import org.apache.pulsar.shade.org.glassfish.jersey.internal.inject.DisposableSupplier;

public class SupplierFactoryBridge<T>
implements Factory<T> {
    private ServiceLocator locator;
    private ParameterizedType beanType;
    private String beanName;
    private boolean disposable;
    private Map<Object, DisposableSupplier<T>> disposableSuppliers = new IdentityHashMap<Object, DisposableSupplier<T>>();

    SupplierFactoryBridge(ServiceLocator locator, Type beanType, String beanName, boolean disposable) {
        this.locator = locator;
        this.beanType = new ParameterizedTypeImpl((Type)((Object)Supplier.class), beanType);
        this.beanName = beanName;
        this.disposable = disposable;
    }

    @Override
    public T provide() {
        if (this.beanType != null) {
            Supplier supplier = (Supplier)this.locator.getService((Type)this.beanType, this.beanName, new Annotation[0]);
            Object instance = supplier.get();
            if (this.disposable) {
                this.disposableSuppliers.put(instance, (DisposableSupplier)supplier);
            }
            return instance;
        }
        return null;
    }

    @Override
    public void dispose(T instance) {
        if (this.disposable) {
            DisposableSupplier<T> disposableSupplier = this.disposableSuppliers.get(instance);
            disposableSupplier.dispose(instance);
            this.disposableSuppliers.remove(instance);
        }
    }
}

