/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json;

import java.lang.annotation.Annotation;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectReader;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.ObjectWriter;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.util.JSONPObject;
import org.apache.pulsar.shade.com.fasterxml.jackson.databind.util.JSONWrappedObject;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal.jackson.jaxrs.cfg.EndpointConfigBase;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.annotation.JSONP;
import org.apache.pulsar.shade.org.glassfish.jersey.jackson.internal.jackson.jaxrs.json.annotation.JacksonFeatures;

public class JsonEndpointConfig
extends EndpointConfigBase<JsonEndpointConfig> {
    protected JSONP.Def _jsonp;

    protected JsonEndpointConfig(MapperConfig<?> config) {
        super(config);
    }

    public static JsonEndpointConfig forReading(ObjectReader reader, Annotation[] annotations) {
        return (JsonEndpointConfig)((JsonEndpointConfig)new JsonEndpointConfig(reader.getConfig()).add(annotations, false)).initReader(reader);
    }

    public static JsonEndpointConfig forWriting(ObjectWriter writer, Annotation[] annotations, String defaultJsonpMethod) {
        JsonEndpointConfig config = new JsonEndpointConfig(writer.getConfig());
        if (defaultJsonpMethod != null) {
            config._jsonp = new JSONP.Def(defaultJsonpMethod);
        }
        return (JsonEndpointConfig)((JsonEndpointConfig)config.add(annotations, true)).initWriter(writer);
    }

    @Override
    protected void addAnnotation(Class<? extends Annotation> type, Annotation annotation, boolean forWriting) {
        if (type == JSONP.class) {
            if (forWriting) {
                this._jsonp = new JSONP.Def((JSONP)annotation);
            }
        } else if (type == JacksonFeatures.class) {
            JacksonFeatures feats = (JacksonFeatures)annotation;
            if (forWriting) {
                this._serEnable = JsonEndpointConfig.nullIfEmpty(feats.serializationEnable());
                this._serDisable = JsonEndpointConfig.nullIfEmpty(feats.serializationDisable());
            } else {
                this._deserEnable = JsonEndpointConfig.nullIfEmpty(feats.deserializationEnable());
                this._deserDisable = JsonEndpointConfig.nullIfEmpty(feats.deserializationDisable());
            }
        } else {
            super.addAnnotation(type, annotation, forWriting);
        }
    }

    @Override
    public Object modifyBeforeWrite(Object value) {
        return this.applyJSONP(value);
    }

    public Object applyJSONP(Object value) {
        if (this._jsonp != null) {
            if (this._jsonp.prefix != null || this._jsonp.suffix != null) {
                return new JSONWrappedObject(this._jsonp.prefix, this._jsonp.suffix, value);
            }
            if (this._jsonp.method != null) {
                return new JSONPObject(this._jsonp.method, value);
            }
        }
        return value;
    }
}

