/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.shade.org.objenesis.strategy;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.pulsar.shade.org.objenesis.ObjenesisException;
import org.apache.pulsar.shade.org.objenesis.instantiator.ObjectInstantiator;
import org.apache.pulsar.shade.org.objenesis.instantiator.android.AndroidSerializationInstantiator;
import org.apache.pulsar.shade.org.objenesis.instantiator.basic.ObjectInputStreamInstantiator;
import org.apache.pulsar.shade.org.objenesis.instantiator.basic.ObjectStreamClassInstantiator;
import org.apache.pulsar.shade.org.objenesis.instantiator.gcj.GCJSerializationInstantiator;
import org.apache.pulsar.shade.org.objenesis.instantiator.perc.PercSerializationInstantiator;
import org.apache.pulsar.shade.org.objenesis.instantiator.sun.SunReflectionFactorySerializationInstantiator;
import org.apache.pulsar.shade.org.objenesis.strategy.BaseInstantiatorStrategy;
import org.apache.pulsar.shade.org.objenesis.strategy.PlatformDescription;

public class SerializingInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (!Serializable.class.isAssignableFrom(type)) {
            throw new ObjenesisException(new NotSerializableException(type + " not serializable"));
        }
        if (PlatformDescription.JVM_NAME.startsWith("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            if (PlatformDescription.isGoogleAppEngine() && PlatformDescription.SPECIFICATION_VERSION.equals("1.7")) {
                return new ObjectInputStreamInstantiator<T>(type);
            }
            return new SunReflectionFactorySerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new ObjectStreamClassInstantiator<T>(type);
            }
            return new AndroidSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("GNU libgcj")) {
            return new GCJSerializationInstantiator<T>(type);
        }
        if (PlatformDescription.JVM_NAME.startsWith("PERC")) {
            return new PercSerializationInstantiator<T>(type);
        }
        return new SunReflectionFactorySerializationInstantiator<T>(type);
    }
}

