/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.admin.internal;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.pulsar.client.admin.GetStatsOptions;
import org.apache.pulsar.client.admin.ListTopicsOptions;
import org.apache.pulsar.client.admin.LongRunningProcessStatus;
import org.apache.pulsar.client.admin.OffloadProcessStatus;
import org.apache.pulsar.client.admin.PulsarAdminException;
import org.apache.pulsar.client.admin.Topics;
import org.apache.pulsar.client.admin.internal.BaseResource;
import org.apache.pulsar.client.admin.internal.WebTargets;
import org.apache.pulsar.client.api.Authentication;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SubscriptionType;
import org.apache.pulsar.client.impl.BatchMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.ResetCursorData;
import org.apache.pulsar.common.api.proto.BrokerEntryMetadata;
import org.apache.pulsar.common.api.proto.CompressionType;
import org.apache.pulsar.common.api.proto.EncryptionKeys;
import org.apache.pulsar.common.api.proto.KeyValue;
import org.apache.pulsar.common.api.proto.MessageMetadata;
import org.apache.pulsar.common.api.proto.SingleMessageMetadata;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.TopicDomain;
import org.apache.pulsar.common.naming.TopicName;
import org.apache.pulsar.common.partition.PartitionedTopicMetadata;
import org.apache.pulsar.common.policies.data.AuthAction;
import org.apache.pulsar.common.policies.data.BacklogQuota;
import org.apache.pulsar.common.policies.data.DelayedDeliveryPolicies;
import org.apache.pulsar.common.policies.data.DispatchRate;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.InactiveTopicPolicies;
import org.apache.pulsar.common.policies.data.NonPersistentPartitionedTopicStats;
import org.apache.pulsar.common.policies.data.NonPersistentTopicStats;
import org.apache.pulsar.common.policies.data.OffloadPolicies;
import org.apache.pulsar.common.policies.data.OffloadPoliciesImpl;
import org.apache.pulsar.common.policies.data.PartitionedTopicInternalStats;
import org.apache.pulsar.common.policies.data.PartitionedTopicStats;
import org.apache.pulsar.common.policies.data.PersistencePolicies;
import org.apache.pulsar.common.policies.data.PersistentTopicInternalStats;
import org.apache.pulsar.common.policies.data.PublishRate;
import org.apache.pulsar.common.policies.data.RetentionPolicies;
import org.apache.pulsar.common.policies.data.SubscribeRate;
import org.apache.pulsar.common.policies.data.TopicStats;
import org.apache.pulsar.common.protocol.Commands;
import org.apache.pulsar.common.stats.AnalyzeSubscriptionBacklogResult;
import org.apache.pulsar.common.util.Codec;
import org.apache.pulsar.common.util.DateFormatter;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;
import org.apache.pulsar.shade.com.google.gson.Gson;
import org.apache.pulsar.shade.io.netty.buffer.ByteBuf;
import org.apache.pulsar.shade.io.netty.buffer.Unpooled;
import org.apache.pulsar.shade.javax.ws.rs.client.Entity;
import org.apache.pulsar.shade.javax.ws.rs.client.InvocationCallback;
import org.apache.pulsar.shade.javax.ws.rs.client.WebTarget;
import org.apache.pulsar.shade.javax.ws.rs.core.GenericType;
import org.apache.pulsar.shade.javax.ws.rs.core.MediaType;
import org.apache.pulsar.shade.javax.ws.rs.core.MultivaluedMap;
import org.apache.pulsar.shade.javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicsImpl
extends BaseResource
implements Topics {
    private final WebTarget adminTopics;
    private final WebTarget adminV2Topics;
    private static final String BATCH_HEADER = "X-Pulsar-num-batch-message";
    private static final String BATCH_SIZE_HEADER = "X-Pulsar-batch-size";
    private static final String MESSAGE_ID = "X-Pulsar-Message-ID";
    private static final String PUBLISH_TIME = "X-Pulsar-publish-time";
    private static final String EVENT_TIME = "X-Pulsar-event-time";
    private static final String DELIVER_AT_TIME = "X-Pulsar-deliver-at-time";
    private static final String BROKER_ENTRY_TIMESTAMP = "X-Pulsar-Broker-Entry-METADATA-timestamp";
    private static final String BROKER_ENTRY_INDEX = "X-Pulsar-Broker-Entry-METADATA-index";
    private static final String PRODUCER_NAME = "X-Pulsar-producer-name";
    private static final String SEQUENCE_ID = "X-Pulsar-sequence-id";
    private static final String REPLICATED_FROM = "X-Pulsar-replicated-from";
    private static final String PARTITION_KEY = "X-Pulsar-partition-key";
    private static final String COMPRESSION = "X-Pulsar-compression";
    private static final String UNCOMPRESSED_SIZE = "X-Pulsar-uncompressed-size";
    private static final String ENCRYPTION_ALGO = "X-Pulsar-encryption-algo";
    private static final String MARKER_TYPE = "X-Pulsar-marker-type";
    private static final String TXNID_LEAST_BITS = "X-Pulsar-txnid-least-bits";
    private static final String TXNID_MOST_BITS = "X-Pulsar-txnid-most-bits";
    private static final String HIGHEST_SEQUENCE_ID = "X-Pulsar-highest-sequence-id";
    private static final String UUID = "X-Pulsar-uuid";
    private static final String NUM_CHUNKS_FROM_MSG = "X-Pulsar-num-chunks-from-msg";
    private static final String TOTAL_CHUNK_MSG_SIZE = "X-Pulsar-total-chunk-msg-size";
    private static final String CHUNK_ID = "X-Pulsar-chunk-id";
    private static final String PARTITION_KEY_B64_ENCODED = "X-Pulsar-partition-key-b64-encoded";
    private static final String NULL_PARTITION_KEY = "X-Pulsar-null-partition-key";
    private static final String REPLICATED_TO = "X-Pulsar-replicated-to";
    private static final String ORDERING_KEY = "X-Pulsar-Base64-ordering-key";
    private static final String SCHEMA_VERSION = "X-Pulsar-Base64-schema-version-b64encoded";
    private static final String ENCRYPTION_PARAM = "X-Pulsar-Base64-encryption-param";
    private static final String ENCRYPTION_KEYS = "X-Pulsar-Base64-encryption-keys";
    public static final String PROPERTY_SHADOW_SOURCE_KEY = "PULSAR.SHADOW_SOURCE";
    private static final Logger log = LoggerFactory.getLogger(TopicsImpl.class);

    public TopicsImpl(WebTarget web, Authentication auth, long readTimeoutMs) {
        super(auth, readTimeoutMs);
        this.adminTopics = web.path("/admin");
        this.adminV2Topics = web.path("/admin/v2");
    }

    public List<String> getList(String namespace) throws PulsarAdminException {
        return this.getList(namespace, null);
    }

    public List<String> getList(String namespace, TopicDomain topicDomain) throws PulsarAdminException {
        return this.getList(namespace, topicDomain, ListTopicsOptions.EMPTY);
    }

    public List<String> getList(String namespace, TopicDomain topicDomain, Map<Topics.QueryParam, Object> params) throws PulsarAdminException {
        ListTopicsOptions options = ListTopicsOptions.builder().bundle((String)params.get(Topics.QueryParam.Bundle)).build();
        return this.getList(namespace, topicDomain, options);
    }

    public List<String> getList(String namespace, TopicDomain topicDomain, ListTopicsOptions options) throws PulsarAdminException {
        return (List)this.sync(() -> this.getListAsync(namespace, topicDomain, options));
    }

    public CompletableFuture<List<String>> getListAsync(String namespace) {
        return this.getListAsync(namespace, null);
    }

    public CompletableFuture<List<String>> getListAsync(String namespace, TopicDomain topicDomain) {
        return this.getListAsync(namespace, topicDomain, ListTopicsOptions.EMPTY);
    }

    public CompletableFuture<List<String>> getListAsync(String namespace, TopicDomain topicDomain, Map<Topics.QueryParam, Object> params) {
        ListTopicsOptions options = ListTopicsOptions.builder().bundle((String)params.get(Topics.QueryParam.Bundle.value)).build();
        return this.getListAsync(namespace, topicDomain, options);
    }

    public CompletableFuture<List<String>> getListAsync(String namespace, TopicDomain topicDomain, ListTopicsOptions options) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget persistentPath = this.namespacePath("persistent", ns, new String[0]);
        WebTarget nonPersistentPath = this.namespacePath("non-persistent", ns, new String[0]);
        persistentPath = persistentPath.queryParam("bundle", options.getBundle()).queryParam("includeSystemTopic", options.isIncludeSystemTopic());
        nonPersistentPath = nonPersistentPath.queryParam("bundle", options.getBundle()).queryParam("includeSystemTopic", options.isIncludeSystemTopic());
        CompletableFuture<List<Object>> persistentList = topicDomain == null || TopicDomain.persistent.equals((Object)topicDomain) ? this.asyncGetRequest(persistentPath, new BaseResource.FutureCallback<List<String>>(){}) : CompletableFuture.completedFuture(Collections.emptyList());
        CompletableFuture<List<Object>> nonPersistentList = topicDomain == null || TopicDomain.non_persistent.equals((Object)topicDomain) ? this.asyncGetRequest(nonPersistentPath, new BaseResource.FutureCallback<List<String>>(){}) : CompletableFuture.completedFuture(Collections.emptyList());
        return persistentList.thenCombine(nonPersistentList, (l1, l2) -> new ArrayList(Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toSet())));
    }

    public List<String> getPartitionedTopicList(String namespace) throws PulsarAdminException {
        return this.getPartitionedTopicList(namespace, ListTopicsOptions.EMPTY);
    }

    public List<String> getPartitionedTopicList(String namespace, ListTopicsOptions options) throws PulsarAdminException {
        return (List)this.sync(() -> this.getPartitionedTopicListAsync(namespace, options));
    }

    public CompletableFuture<List<String>> getPartitionedTopicListAsync(String namespace) {
        return this.getPartitionedTopicListAsync(namespace, ListTopicsOptions.EMPTY);
    }

    public CompletableFuture<List<String>> getPartitionedTopicListAsync(String namespace, ListTopicsOptions options) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget persistentPath = this.namespacePath("persistent", ns, "partitioned");
        WebTarget nonPersistentPath = this.namespacePath("non-persistent", ns, "partitioned");
        persistentPath = persistentPath.queryParam("includeSystemTopic", options.isIncludeSystemTopic());
        nonPersistentPath = nonPersistentPath.queryParam("includeSystemTopic", options.isIncludeSystemTopic());
        CompletableFuture<List<String>> persistentList = this.asyncGetRequest(persistentPath, new BaseResource.FutureCallback<List<String>>(){});
        CompletableFuture<List<String>> nonPersistentList = this.asyncGetRequest(nonPersistentPath, new BaseResource.FutureCallback<List<String>>(){});
        return persistentList.thenCombine(nonPersistentList, (l1, l2) -> new ArrayList(Stream.concat(l1.stream(), l2.stream()).collect(Collectors.toSet())));
    }

    public List<String> getListInBundle(String namespace, String bundleRange) throws PulsarAdminException {
        return (List)this.sync(() -> this.getListInBundleAsync(namespace, bundleRange));
    }

    public CompletableFuture<List<String>> getListInBundleAsync(String namespace, String bundleRange) {
        NamespaceName ns = NamespaceName.get(namespace);
        WebTarget path = this.namespacePath("non-persistent", ns, bundleRange);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public Map<String, Set<AuthAction>> getPermissions(String topic) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getPermissionsAsync(topic));
    }

    public CompletableFuture<Map<String, Set<AuthAction>>> getPermissionsAsync(String topic) {
        TopicName tn = TopicName.get(topic);
        WebTarget path = this.topicPath(tn, "permissions");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, Set<AuthAction>>>(){});
    }

    public void grantPermission(String topic, String role, Set<AuthAction> actions) throws PulsarAdminException {
        this.sync(() -> this.grantPermissionAsync(topic, role, actions));
    }

    public CompletableFuture<Void> grantPermissionAsync(String topic, String role, Set<AuthAction> actions) {
        TopicName tn = TopicName.get(topic);
        WebTarget path = this.topicPath(tn, "permissions", role);
        return this.asyncPostRequest(path, Entity.entity(actions, "application/json"));
    }

    public void revokePermissions(String topic, String role) throws PulsarAdminException {
        this.sync(() -> this.revokePermissionsAsync(topic, role));
    }

    public CompletableFuture<Void> revokePermissionsAsync(String topic, String role) {
        TopicName tn = TopicName.get(topic);
        WebTarget path = this.topicPath(tn, "permissions", role);
        return this.asyncDeleteRequest(path);
    }

    public void createPartitionedTopic(String topic, int numPartitions, Map<String, String> metadata) throws PulsarAdminException {
        this.sync(() -> this.createPartitionedTopicAsync(topic, numPartitions, metadata));
    }

    public void createNonPartitionedTopic(String topic, Map<String, String> metadata) throws PulsarAdminException {
        this.sync(() -> this.createNonPartitionedTopicAsync(topic, metadata));
    }

    public void createMissedPartitions(String topic) throws PulsarAdminException {
        this.sync(() -> this.createMissedPartitionsAsync(topic));
    }

    public CompletableFuture<Void> createNonPartitionedTopicAsync(String topic, Map<String, String> properties) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, new String[0]);
        properties = properties == null ? new HashMap() : properties;
        return this.asyncPutRequest(path, Entity.entity(properties, "application/json"));
    }

    public CompletableFuture<Void> createPartitionedTopicAsync(String topic, int numPartitions, Map<String, String> properties) {
        return this.createPartitionedTopicAsync(topic, numPartitions, false, properties);
    }

    public CompletableFuture<Void> createPartitionedTopicAsync(String topic, int numPartitions, boolean createLocalTopicOnly, Map<String, String> properties) {
        Entity<Integer> entity;
        Preconditions.checkArgument(numPartitions > 0, "Number of partitions should be more than 0");
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "partitions").queryParam("createLocalTopicOnly", Boolean.toString(createLocalTopicOnly));
        if (properties != null && !properties.isEmpty()) {
            PartitionedTopicMetadata metadata = new PartitionedTopicMetadata(numPartitions, properties);
            entity = Entity.entity(metadata, MediaType.valueOf("application/vnd.partitioned-topic-metadata+json"));
        } else {
            entity = Entity.entity(Integer.valueOf(numPartitions), "application/json");
        }
        return this.asyncPutRequest(path, entity);
    }

    public CompletableFuture<Void> createMissedPartitionsAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "createMissedPartitions");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void updatePartitionedTopic(String topic, int numPartitions) throws PulsarAdminException {
        this.sync(() -> this.updatePartitionedTopicAsync(topic, numPartitions));
    }

    public CompletableFuture<Void> updatePartitionedTopicAsync(String topic, int numPartitions) {
        return this.updatePartitionedTopicAsync(topic, numPartitions, false, false);
    }

    public void updatePartitionedTopic(String topic, int numPartitions, boolean updateLocalTopicOnly) throws PulsarAdminException {
        this.updatePartitionedTopic(topic, numPartitions, updateLocalTopicOnly, false);
    }

    public void updatePartitionedTopic(String topic, int numPartitions, boolean updateLocalTopicOnly, boolean force) throws PulsarAdminException {
        this.sync(() -> this.updatePartitionedTopicAsync(topic, numPartitions, updateLocalTopicOnly, force));
    }

    public CompletableFuture<Void> updatePartitionedTopicAsync(String topic, int numPartitions, boolean updateLocalTopicOnly) {
        return this.updatePartitionedTopicAsync(topic, numPartitions, updateLocalTopicOnly, false);
    }

    public CompletableFuture<Void> updatePartitionedTopicAsync(String topic, int numPartitions, boolean updateLocalTopicOnly, boolean force) {
        Preconditions.checkArgument(numPartitions > 0, "Number of partitions must be more than 0");
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "partitions");
        path = path.queryParam("updateLocalTopicOnly", Boolean.toString(updateLocalTopicOnly)).queryParam("force", force);
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(numPartitions), "application/json"));
    }

    public PartitionedTopicMetadata getPartitionedTopicMetadata(String topic) throws PulsarAdminException {
        return (PartitionedTopicMetadata)this.sync(() -> this.getPartitionedTopicMetadataAsync(topic));
    }

    public CompletableFuture<PartitionedTopicMetadata> getPartitionedTopicMetadataAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "partitions");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PartitionedTopicMetadata>(){});
    }

    public Map<String, String> getProperties(String topic) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getPropertiesAsync(topic));
    }

    public CompletableFuture<Map<String, String>> getPropertiesAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "properties");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, String>>(){});
    }

    public void updateProperties(String topic, Map<String, String> properties) throws PulsarAdminException {
        this.sync(() -> this.updatePropertiesAsync(topic, properties));
    }

    public CompletableFuture<Void> updatePropertiesAsync(String topic, Map<String, String> properties) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "properties");
        if (properties == null) {
            properties = new HashMap<String, String>();
        }
        return this.asyncPutRequest(path, Entity.entity(properties, "application/json"));
    }

    public void deletePartitionedTopic(String topic) throws PulsarAdminException {
        this.deletePartitionedTopic(topic, false);
    }

    public void removeProperties(String topic, String key) throws PulsarAdminException {
        this.sync(() -> this.removePropertiesAsync(topic, key));
    }

    public CompletableFuture<Void> removePropertiesAsync(String topic, String key) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "properties").queryParam("key", key);
        return this.asyncDeleteRequest(path);
    }

    public CompletableFuture<Void> deletePartitionedTopicAsync(String topic) {
        return this.deletePartitionedTopicAsync(topic, false);
    }

    public void deletePartitionedTopic(String topic, boolean force, boolean deleteSchema) throws PulsarAdminException {
        this.sync(() -> this.deletePartitionedTopicAsync(topic, force, true));
    }

    public CompletableFuture<Void> deletePartitionedTopicAsync(String topic, boolean force, boolean deleteSchema) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "partitions").queryParam("force", Boolean.toString(force)).queryParam("deleteSchema", "true");
        return this.asyncDeleteRequest(path);
    }

    public void delete(String topic) throws PulsarAdminException {
        this.delete(topic, false);
    }

    public CompletableFuture<Void> deleteAsync(String topic) {
        return this.deleteAsync(topic, false);
    }

    public void delete(String topic, boolean force, boolean deleteSchema) throws PulsarAdminException {
        this.sync(() -> this.deleteAsync(topic, force, true));
    }

    public CompletableFuture<Void> deleteAsync(String topic, boolean force, boolean deleteSchema) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, new String[0]).queryParam("force", Boolean.toString(force)).queryParam("deleteSchema", "true");
        return this.asyncDeleteRequest(path);
    }

    public void unload(String topic) throws PulsarAdminException {
        this.sync(() -> this.unloadAsync(topic));
    }

    public CompletableFuture<Void> unloadAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "unload");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public MessageId terminateTopic(String topic) throws PulsarAdminException {
        return (MessageId)this.sync(() -> this.terminateTopicAsync(topic));
    }

    public CompletableFuture<MessageId> terminateTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        final CompletableFuture<MessageId> future = new CompletableFuture<MessageId>();
        try {
            final WebTarget path = this.topicPath(tn, "terminate");
            this.request(path).async().post(Entity.entity("", "application/json"), new InvocationCallback<MessageIdImpl>(){

                @Override
                public void completed(MessageIdImpl messageId) {
                    future.complete(messageId);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)path.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public Map<Integer, MessageId> terminatePartitionedTopic(String topic) throws PulsarAdminException {
        return (Map)this.sync(() -> this.terminatePartitionedTopicAsync(topic));
    }

    public CompletableFuture<Map<Integer, MessageId>> terminatePartitionedTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        final CompletableFuture<Map<Integer, MessageId>> future = new CompletableFuture<Map<Integer, MessageId>>();
        try {
            final WebTarget path = this.topicPath(tn, "terminate", "partitions");
            this.request(path).async().post(Entity.entity("", "application/json"), new InvocationCallback<Map<Integer, MessageIdImpl>>(){

                @Override
                public void completed(Map<Integer, MessageIdImpl> messageId) {
                    HashMap<Integer, MessageId> messageIdImpl = new HashMap<Integer, MessageId>();
                    for (Map.Entry<Integer, MessageIdImpl> entry : messageId.entrySet()) {
                        messageIdImpl.put(entry.getKey(), entry.getValue());
                    }
                    future.complete(messageIdImpl);
                }

                @Override
                public void failed(Throwable throwable) {
                    log.warn("[{}] Failed to perform http post request: {}", (Object)path.getUri(), (Object)throwable.getMessage());
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public List<String> getSubscriptions(String topic) throws PulsarAdminException {
        return (List)this.sync(() -> this.getSubscriptionsAsync(topic));
    }

    public CompletableFuture<List<String>> getSubscriptionsAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "subscriptions");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public TopicStats getStats(String topic, GetStatsOptions getStatsOptions) throws PulsarAdminException {
        return (TopicStats)this.sync(() -> this.getStatsAsync(topic, getStatsOptions));
    }

    public CompletableFuture<TopicStats> getStatsAsync(String topic, boolean getPreciseBacklog, boolean subscriptionBacklogSize, boolean getEarliestTimeInBacklog) {
        GetStatsOptions getStatsOptions = new GetStatsOptions(getPreciseBacklog, subscriptionBacklogSize, getEarliestTimeInBacklog, false, false);
        return this.getStatsAsync(topic, getStatsOptions);
    }

    public CompletableFuture<TopicStats> getStatsAsync(String topic, GetStatsOptions getStatsOptions) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "stats").queryParam("getPreciseBacklog", getStatsOptions.isGetPreciseBacklog()).queryParam("subscriptionBacklogSize", getStatsOptions.isSubscriptionBacklogSize()).queryParam("getEarliestTimeInBacklog", getStatsOptions.isGetEarliestTimeInBacklog()).queryParam("excludePublishers", getStatsOptions.isExcludePublishers()).queryParam("excludeConsumers", getStatsOptions.isExcludeConsumers());
        final CompletableFuture<TopicStats> future = new CompletableFuture<TopicStats>();
        InvocationCallback<TopicStats> persistentCB = new InvocationCallback<TopicStats>(){

            @Override
            public void completed(TopicStats response) {
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        };
        InvocationCallback<NonPersistentTopicStats> nonpersistentCB = new InvocationCallback<NonPersistentTopicStats>(){

            @Override
            public void completed(NonPersistentTopicStats response) {
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        };
        if (topic.startsWith(TopicDomain.non_persistent.value())) {
            this.asyncGetRequest(path, nonpersistentCB);
        } else {
            this.asyncGetRequest(path, persistentCB);
        }
        return future;
    }

    public PersistentTopicInternalStats getInternalStats(String topic) throws PulsarAdminException {
        return this.getInternalStats(topic, false);
    }

    public PersistentTopicInternalStats getInternalStats(String topic, boolean metadata) throws PulsarAdminException {
        return (PersistentTopicInternalStats)this.sync(() -> this.getInternalStatsAsync(topic, metadata));
    }

    public CompletableFuture<PersistentTopicInternalStats> getInternalStatsAsync(String topic) {
        return this.getInternalStatsAsync(topic, false);
    }

    public CompletableFuture<PersistentTopicInternalStats> getInternalStatsAsync(String topic, boolean metadata) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "internalStats");
        path = path.queryParam("metadata", metadata);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PersistentTopicInternalStats>(){});
    }

    public String getInternalInfo(String topic) throws PulsarAdminException {
        return (String)this.sync(() -> this.getInternalInfoAsync(topic));
    }

    public CompletableFuture<String> getInternalInfoAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "internal-info");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<String>(){});
    }

    public PartitionedTopicStats getPartitionedStats(String topic, boolean perPartition, boolean getPreciseBacklog, boolean subscriptionBacklogSize, boolean getEarliestTimeInBacklog) throws PulsarAdminException {
        return (PartitionedTopicStats)this.sync(() -> this.getPartitionedStatsAsync(topic, perPartition, getPreciseBacklog, subscriptionBacklogSize, getEarliestTimeInBacklog));
    }

    public PartitionedTopicStats getPartitionedStats(String topic, boolean perPartition, GetStatsOptions getStatsOptions) throws PulsarAdminException {
        return (PartitionedTopicStats)this.sync(() -> this.getPartitionedStatsAsync(topic, perPartition, getStatsOptions));
    }

    public CompletableFuture<PartitionedTopicStats> getPartitionedStatsAsync(String topic, boolean perPartition, boolean getPreciseBacklog, boolean subscriptionBacklogSize, boolean getEarliestTimeInBacklog) {
        GetStatsOptions getStatsOptions = new GetStatsOptions(getPreciseBacklog, subscriptionBacklogSize, getEarliestTimeInBacklog, false, false);
        return this.getPartitionedStatsAsync(topic, perPartition, getStatsOptions);
    }

    public CompletableFuture<PartitionedTopicStats> getPartitionedStatsAsync(String topic, final boolean perPartition, GetStatsOptions getStatsOptions) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "partitioned-stats");
        path = path.queryParam("perPartition", perPartition).queryParam("getPreciseBacklog", getStatsOptions.isGetPreciseBacklog()).queryParam("subscriptionBacklogSize", getStatsOptions.isSubscriptionBacklogSize()).queryParam("getEarliestTimeInBacklog", getStatsOptions.isGetEarliestTimeInBacklog()).queryParam("excludePublishers", getStatsOptions.isExcludePublishers()).queryParam("excludeConsumers", getStatsOptions.isExcludeConsumers());
        final CompletableFuture<PartitionedTopicStats> future = new CompletableFuture<PartitionedTopicStats>();
        InvocationCallback<NonPersistentPartitionedTopicStats> nonpersistentCB = new InvocationCallback<NonPersistentPartitionedTopicStats>(){

            @Override
            public void completed(NonPersistentPartitionedTopicStats response) {
                if (!perPartition) {
                    response.getPartitions().clear();
                }
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        };
        InvocationCallback<PartitionedTopicStats> persistentCB = new InvocationCallback<PartitionedTopicStats>(){

            @Override
            public void completed(PartitionedTopicStats response) {
                if (!perPartition) {
                    response.getPartitions().clear();
                }
                future.complete(response);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        };
        if (topic.startsWith(TopicDomain.non_persistent.value())) {
            this.asyncGetRequest(path, nonpersistentCB);
        } else {
            this.asyncGetRequest(path, persistentCB);
        }
        return future;
    }

    public PartitionedTopicInternalStats getPartitionedInternalStats(String topic) throws PulsarAdminException {
        return (PartitionedTopicInternalStats)this.sync(() -> this.getPartitionedInternalStatsAsync(topic));
    }

    public CompletableFuture<PartitionedTopicInternalStats> getPartitionedInternalStatsAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "partitioned-internalStats");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PartitionedTopicInternalStats>(){});
    }

    public void deleteSubscription(String topic, String subName) throws PulsarAdminException {
        this.sync(() -> this.deleteSubscriptionAsync(topic, subName));
    }

    public void deleteSubscription(String topic, String subName, boolean force) throws PulsarAdminException {
        this.sync(() -> this.deleteSubscriptionAsync(topic, subName, force));
    }

    public CompletableFuture<Void> deleteSubscriptionAsync(String topic, String subName) {
        return this.deleteSubscriptionAsync(topic, subName, false);
    }

    public CompletableFuture<Void> deleteSubscriptionAsync(String topic, String subName, boolean force) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName);
        path = path.queryParam("force", force);
        return this.asyncDeleteRequest(path);
    }

    public void skipAllMessages(String topic, String subName) throws PulsarAdminException {
        this.sync(() -> this.skipAllMessagesAsync(topic, subName));
    }

    public CompletableFuture<Void> skipAllMessagesAsync(String topic, String subName) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "skip_all");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void skipMessages(String topic, String subName, long numMessages) throws PulsarAdminException {
        this.sync(() -> this.skipMessagesAsync(topic, subName, numMessages));
    }

    public CompletableFuture<Void> skipMessagesAsync(String topic, String subName, long numMessages) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "skip", String.valueOf(numMessages));
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void expireMessages(String topic, String subName, long expireTimeInSeconds) throws PulsarAdminException {
        this.sync(() -> this.expireMessagesAsync(topic, subName, expireTimeInSeconds));
    }

    public CompletableFuture<Void> expireMessagesAsync(String topic, String subName, long expireTimeInSeconds) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "expireMessages", String.valueOf(expireTimeInSeconds));
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void expireMessages(String topic, String subscriptionName, MessageId messageId, boolean isExcluded) throws PulsarAdminException {
        this.sync(() -> this.expireMessagesAsync(topic, subscriptionName, messageId, isExcluded));
    }

    public CompletableFuture<Void> expireMessagesAsync(String topic, String subscriptionName, MessageId messageId, boolean isExcluded) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subscriptionName);
        ResetCursorData resetCursorData = new ResetCursorData(messageId);
        resetCursorData.setExcluded(isExcluded);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "expireMessages");
        return this.asyncPostRequest(path, Entity.entity(resetCursorData, "application/json"));
    }

    public void expireMessagesForAllSubscriptions(String topic, long expireTimeInSeconds) throws PulsarAdminException {
        this.sync(() -> this.expireMessagesForAllSubscriptionsAsync(topic, expireTimeInSeconds));
    }

    public CompletableFuture<Void> expireMessagesForAllSubscriptionsAsync(String topic, long expireTimeInSeconds) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "all_subscription", "expireMessages", String.valueOf(expireTimeInSeconds));
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    private CompletableFuture<List<Message<byte[]>>> peekNthMessage(String topic, String subName, int messagePosition) {
        final TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "position", String.valueOf(messagePosition));
        final CompletableFuture<List<Message<byte[]>>> future = new CompletableFuture<List<Message<byte[]>>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                try {
                    future.complete(TopicsImpl.this.getMessagesFromHttpResponse(tn.toString(), response));
                }
                catch (Exception e) {
                    future.completeExceptionally(BaseResource.getApiException(e));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public List<Message<byte[]>> peekMessages(String topic, String subName, int numMessages) throws PulsarAdminException {
        return (List)this.sync(() -> this.peekMessagesAsync(topic, subName, numMessages));
    }

    public CompletableFuture<List<Message<byte[]>>> peekMessagesAsync(String topic, String subName, int numMessages) {
        Preconditions.checkArgument(numMessages > 0);
        CompletableFuture<List<Message<byte[]>>> future = new CompletableFuture<List<Message<byte[]>>>();
        this.peekMessagesAsync(topic, subName, numMessages, new ArrayList<Message<byte[]>>(), future, 1);
        return future;
    }

    private void peekMessagesAsync(String topic, String subName, int numMessages, List<Message<byte[]>> messages, CompletableFuture<List<Message<byte[]>>> future, int nthMessage) {
        if (numMessages <= 0) {
            future.complete(messages);
            return;
        }
        this.peekNthMessage(topic, subName, nthMessage).handle((r, ex) -> {
            if (ex != null) {
                if (ex instanceof PulsarAdminException.NotFoundException) {
                    log.warn("Exception '{}' occurred while trying to peek Messages.", (Object)ex.getMessage());
                    future.complete(messages);
                } else {
                    future.completeExceptionally((Throwable)ex);
                }
                return null;
            }
            for (int i = 0; i < Math.min(r.size(), numMessages); ++i) {
                messages.add((Message)r.get(i));
            }
            this.peekMessagesAsync(topic, subName, numMessages - r.size(), messages, future, nthMessage + 1);
            return null;
        });
    }

    public Message<byte[]> examineMessage(String topic, String initialPosition, long messagePosition) throws PulsarAdminException {
        return (Message)this.sync(() -> this.examineMessageAsync(topic, initialPosition, messagePosition));
    }

    public CompletableFuture<Message<byte[]>> examineMessageAsync(String topic, String initialPosition, long messagePosition) {
        final TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "examinemessage").queryParam("initialPosition", initialPosition).queryParam("messagePosition", messagePosition);
        final CompletableFuture<Message<byte[]>> future = new CompletableFuture<Message<byte[]>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                try {
                    List messages = TopicsImpl.this.getMessagesFromHttpResponse(tn.toString(), response);
                    if (messages.size() > 0) {
                        future.complete((Message)messages.get(0));
                    } else {
                        future.complete(null);
                    }
                }
                catch (Exception e) {
                    future.completeExceptionally(BaseResource.getApiException(e));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public void truncate(String topic) throws PulsarAdminException {
        this.sync(() -> this.truncateAsync(topic));
    }

    public CompletableFuture<Void> truncateAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "truncate");
        return this.asyncDeleteRequest(path);
    }

    public CompletableFuture<Message<byte[]>> getMessageByIdAsync(String topic, long ledgerId, long entryId) {
        return this.getRemoteMessageById(topic, ledgerId, entryId);
    }

    private CompletableFuture<Message<byte[]>> getRemoteMessageById(String topic, long ledgerId, long entryId) {
        final TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "ledger", Long.toString(ledgerId), "entry", Long.toString(entryId));
        final CompletableFuture<Message<byte[]>> future = new CompletableFuture<Message<byte[]>>();
        this.asyncGetRequest(path, new InvocationCallback<Response>(){

            @Override
            public void completed(Response response) {
                try {
                    future.complete((Message)TopicsImpl.this.getMessagesFromHttpResponse(topicName.toString(), response).get(0));
                }
                catch (Exception e) {
                    future.completeExceptionally(BaseResource.getApiException(e));
                }
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Message<byte[]> getMessageById(String topic, long ledgerId, long entryId) throws PulsarAdminException {
        return (Message)this.sync(() -> this.getMessageByIdAsync(topic, ledgerId, entryId));
    }

    public CompletableFuture<MessageId> getMessageIdByTimestampAsync(String topic, long timestamp) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "messageid", Long.toString(timestamp));
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<MessageIdImpl>(){}).thenApply(messageIdImpl -> messageIdImpl);
    }

    public MessageId getMessageIdByTimestamp(String topic, long timestamp) throws PulsarAdminException {
        return (MessageId)this.sync(() -> this.getMessageIdByTimestampAsync(topic, timestamp));
    }

    public void createSubscription(String topic, String subscriptionName, MessageId messageId, boolean replicated, Map<String, String> properties) throws PulsarAdminException {
        this.sync(() -> this.createSubscriptionAsync(topic, subscriptionName, messageId, replicated, properties));
    }

    public CompletableFuture<Void> createSubscriptionAsync(String topic, String subscriptionName, MessageId messageId, boolean replicated, Map<String, String> properties) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subscriptionName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName);
        path = path.queryParam("replicated", replicated);
        Object payload = messageId;
        if (properties != null && !properties.isEmpty()) {
            ResetCursorData resetCursorData = messageId != null ? new ResetCursorData(messageId) : new ResetCursorData(MessageId.latest);
            resetCursorData.setProperties(properties);
            payload = resetCursorData;
        }
        return this.asyncPutRequest(path, Entity.entity(payload, "application/json"));
    }

    public void resetCursor(String topic, String subName, long timestamp) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            String encodedSubName = Codec.encode(subName);
            WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "resetcursor", String.valueOf(timestamp));
            this.request(path).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw TopicsImpl.getApiException(e);
        }
    }

    public CompletableFuture<Void> resetCursorAsync(String topic, String subName, long timestamp) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "resetcursor", String.valueOf(timestamp));
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public void resetCursor(String topic, String subName, MessageId messageId) throws PulsarAdminException {
        this.sync(() -> this.resetCursorAsync(topic, subName, messageId));
    }

    public void updateSubscriptionProperties(String topic, String subName, Map<String, String> subscriptionProperties) throws PulsarAdminException {
        this.sync(() -> this.updateSubscriptionPropertiesAsync(topic, subName, subscriptionProperties));
    }

    public Map<String, String> getSubscriptionProperties(String topic, String subName) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getSubscriptionPropertiesAsync(topic, subName));
    }

    public CompletableFuture<Void> updateSubscriptionPropertiesAsync(String topic, String subName, Map<String, String> subscriptionProperties) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "properties");
        if (subscriptionProperties == null) {
            subscriptionProperties = new HashMap<String, String>();
        }
        return this.asyncPutRequest(path, Entity.entity(subscriptionProperties, "application/json"));
    }

    public CompletableFuture<Map<String, String>> getSubscriptionPropertiesAsync(String topic, String subName) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "properties");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, String>>(){});
    }

    public void resetCursor(String topic, String subName, MessageId messageId, boolean isExcluded) throws PulsarAdminException {
        this.sync(() -> this.resetCursorAsync(topic, subName, messageId, isExcluded));
    }

    public CompletableFuture<Void> resetCursorAsync(String topic, String subName, MessageId messageId) {
        return this.resetCursorAsync(topic, subName, messageId, false);
    }

    public CompletableFuture<Void> resetCursorAsync(String topic, String subName, MessageId messageId, boolean isExcluded) {
        TopicName tn = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(tn, "subscription", encodedSubName, "resetcursor");
        ResetCursorData resetCursorData = new ResetCursorData(messageId);
        resetCursorData.setExcluded(isExcluded);
        return this.asyncPostRequest(path, Entity.entity(resetCursorData, "application/json"));
    }

    public void triggerCompaction(String topic) throws PulsarAdminException {
        this.sync(() -> this.triggerCompactionAsync(topic));
    }

    public CompletableFuture<Void> triggerCompactionAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "compaction");
        return this.asyncPutRequest(path, Entity.entity("", "application/json"));
    }

    public void trimTopic(String topic) throws PulsarAdminException {
        this.sync(() -> this.trimTopicAsync(topic));
    }

    public CompletableFuture<Void> trimTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "trim");
        return this.asyncPostRequest(path, Entity.entity("", "application/json"));
    }

    public LongRunningProcessStatus compactionStatus(String topic) throws PulsarAdminException {
        return (LongRunningProcessStatus)this.sync(() -> this.compactionStatusAsync(topic));
    }

    public CompletableFuture<LongRunningProcessStatus> compactionStatusAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "compaction");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<LongRunningProcessStatus>(){});
    }

    public void triggerOffload(String topic, MessageId messageId) throws PulsarAdminException {
        this.sync(() -> this.triggerOffloadAsync(topic, messageId));
    }

    public CompletableFuture<Void> triggerOffloadAsync(String topic, MessageId messageId) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "offload");
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        try {
            this.request(path).async().put(Entity.entity(messageId, "application/json"), new InvocationCallback<MessageIdImpl>(){

                @Override
                public void completed(MessageIdImpl response) {
                    future.complete(null);
                }

                @Override
                public void failed(Throwable throwable) {
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public OffloadProcessStatus offloadStatus(String topic) throws PulsarAdminException {
        return (OffloadProcessStatus)this.sync(() -> this.offloadStatusAsync(topic));
    }

    public CompletableFuture<OffloadProcessStatus> offloadStatusAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "offload");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<OffloadProcessStatus>(){});
    }

    private WebTarget namespacePath(String domain, NamespaceName namespace, String ... parts) {
        WebTarget base = namespace.isV2() ? this.adminV2Topics : this.adminTopics;
        WebTarget namespacePath = base.path(domain).path(namespace.toString());
        namespacePath = WebTargets.addParts(namespacePath, parts);
        return namespacePath;
    }

    private WebTarget topicPath(TopicName topic, String ... parts) {
        WebTarget base = topic.isV2() ? this.adminV2Topics : this.adminTopics;
        WebTarget topicPath = base.path(topic.getRestPath());
        topicPath = WebTargets.addParts(topicPath, parts);
        return topicPath;
    }

    private TopicName validateTopic(String topic) {
        return TopicName.get(topic);
    }

    private List<Message<byte[]>> getMessagesFromHttpResponse(String topic, Response response) throws Exception {
        BrokerEntryMetadata brokerEntryMetadata;
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            throw this.getApiException(response);
        }
        String msgId = response.getHeaderString(MESSAGE_ID);
        String brokerEntryTimestamp = response.getHeaderString(BROKER_ENTRY_TIMESTAMP);
        String brokerEntryIndex = response.getHeaderString(BROKER_ENTRY_INDEX);
        if (brokerEntryTimestamp == null && brokerEntryIndex == null) {
            brokerEntryMetadata = null;
        } else {
            brokerEntryMetadata = new BrokerEntryMetadata();
            if (brokerEntryTimestamp != null) {
                brokerEntryMetadata.setBrokerTimestamp(DateFormatter.parse(brokerEntryTimestamp));
            }
            if (brokerEntryIndex != null) {
                brokerEntryMetadata.setIndex(Long.parseLong(brokerEntryIndex));
            }
        }
        MessageMetadata messageMetadata = new MessageMetadata();
        try (InputStream stream = (InputStream)response.getEntity();){
            List tmpList;
            byte[] data = new byte[stream.available()];
            stream.read(data);
            TreeMap<String, String> properties = new TreeMap<String, String>();
            MultivaluedMap<String, Object> headers = response.getHeaders();
            Object tmp = headers.getFirst(PUBLISH_TIME);
            if (tmp != null) {
                messageMetadata.setPublishTime(DateFormatter.parse(tmp.toString()));
            }
            if ((tmp = headers.getFirst(EVENT_TIME)) != null) {
                messageMetadata.setEventTime(DateFormatter.parse(tmp.toString()));
            }
            if ((tmp = headers.getFirst(DELIVER_AT_TIME)) != null) {
                messageMetadata.setDeliverAtTime(DateFormatter.parse(tmp.toString()));
            }
            if ((tmp = headers.getFirst("X-Pulsar-null-value")) != null) {
                messageMetadata.setNullValue(Boolean.parseBoolean(tmp.toString()));
            }
            if ((tmp = headers.getFirst(PRODUCER_NAME)) != null) {
                messageMetadata.setProducerName(tmp.toString());
            }
            if ((tmp = headers.getFirst(SEQUENCE_ID)) != null) {
                messageMetadata.setSequenceId(Long.parseLong(tmp.toString()));
            }
            if ((tmp = headers.getFirst(REPLICATED_FROM)) != null) {
                messageMetadata.setReplicatedFrom(tmp.toString());
            }
            if ((tmp = headers.getFirst(PARTITION_KEY)) != null) {
                messageMetadata.setPartitionKey(tmp.toString());
            }
            if ((tmp = headers.getFirst(COMPRESSION)) != null) {
                messageMetadata.setCompression(CompressionType.valueOf(tmp.toString()));
            }
            if ((tmp = headers.getFirst(UNCOMPRESSED_SIZE)) != null) {
                messageMetadata.setUncompressedSize(Integer.parseInt(tmp.toString()));
            }
            if ((tmp = headers.getFirst(ENCRYPTION_ALGO)) != null) {
                messageMetadata.setEncryptionAlgo(tmp.toString());
            }
            if ((tmp = headers.getFirst(PARTITION_KEY_B64_ENCODED)) != null) {
                messageMetadata.setPartitionKeyB64Encoded(Boolean.parseBoolean(tmp.toString()));
            }
            if ((tmp = headers.getFirst(MARKER_TYPE)) != null) {
                messageMetadata.setMarkerType(Integer.parseInt(tmp.toString()));
            }
            if ((tmp = headers.getFirst(TXNID_LEAST_BITS)) != null) {
                messageMetadata.setTxnidLeastBits(Long.parseLong(tmp.toString()));
            }
            if ((tmp = headers.getFirst(TXNID_MOST_BITS)) != null) {
                messageMetadata.setTxnidMostBits(Long.parseLong(tmp.toString()));
            }
            if ((tmp = headers.getFirst(HIGHEST_SEQUENCE_ID)) != null) {
                messageMetadata.setHighestSequenceId(Long.parseLong(tmp.toString()));
            }
            if ((tmp = headers.getFirst(UUID)) != null) {
                messageMetadata.setUuid(tmp.toString());
            }
            if ((tmp = headers.getFirst(NUM_CHUNKS_FROM_MSG)) != null) {
                messageMetadata.setNumChunksFromMsg(Integer.parseInt(tmp.toString()));
            }
            if ((tmp = headers.getFirst(TOTAL_CHUNK_MSG_SIZE)) != null) {
                messageMetadata.setTotalChunkMsgSize(Integer.parseInt(tmp.toString()));
            }
            if ((tmp = headers.getFirst(CHUNK_ID)) != null) {
                messageMetadata.setChunkId(Integer.parseInt(tmp.toString()));
            }
            if ((tmp = headers.getFirst(NULL_PARTITION_KEY)) != null) {
                messageMetadata.setNullPartitionKey(Boolean.parseBoolean(tmp.toString()));
            }
            if ((tmp = headers.getFirst(ENCRYPTION_PARAM)) != null) {
                messageMetadata.setEncryptionParam(Base64.getDecoder().decode(tmp.toString()));
            }
            if ((tmp = headers.getFirst(ORDERING_KEY)) != null) {
                messageMetadata.setOrderingKey(Base64.getDecoder().decode(tmp.toString()));
            }
            if ((tmp = headers.getFirst(SCHEMA_VERSION)) != null) {
                messageMetadata.setSchemaVersion(Base64.getDecoder().decode(tmp.toString()));
            }
            if ((tmp = headers.getFirst(ENCRYPTION_PARAM)) != null) {
                messageMetadata.setEncryptionParam(Base64.getDecoder().decode(tmp.toString()));
            }
            if ((tmpList = (List)headers.get(REPLICATED_TO)) != null) {
                for (Object e : tmpList) {
                    messageMetadata.addReplicateTo(e.toString());
                }
            }
            if ((tmpList = (List)headers.get(ENCRYPTION_KEYS)) != null) {
                for (Object e : tmpList) {
                    EncryptionKeys encryptionKey = messageMetadata.addEncryptionKey();
                    encryptionKey.parseFrom(Base64.getDecoder().decode(e.toString()));
                }
            }
            if ((tmp = headers.getFirst(BATCH_SIZE_HEADER)) != null) {
                properties.put(BATCH_SIZE_HEADER, (String)tmp);
            }
            for (Map.Entry entry : headers.entrySet()) {
                String header = (String)entry.getKey();
                if (!"X-Pulsar-PROPERTY".equals(header)) continue;
                Map msgPropsTmp = new Gson().fromJson((String)((List)entry.getValue()).get(0), Map.class);
                properties.putAll(msgPropsTmp);
                break;
            }
            if ((tmp = headers.getFirst(BATCH_HEADER)) != null) {
                properties.put(BATCH_HEADER, (String)tmp);
            }
            boolean isEncrypted = false;
            tmp = headers.getFirst("X-Pulsar-Is-Encrypted");
            if (tmp != null) {
                isEncrypted = Boolean.parseBoolean(tmp.toString());
            }
            if (!isEncrypted && response.getHeaderString(BATCH_HEADER) != null) {
                List<Message<byte[]>> list = this.getIndividualMsgsFromBatch(topic, msgId, data, properties, messageMetadata, brokerEntryMetadata);
                return list;
            }
            MessageImpl messageImpl = new MessageImpl(topic, msgId, properties, Unpooled.wrappedBuffer(data), Schema.BYTES, messageMetadata);
            if (brokerEntryMetadata != null) {
                messageImpl.setBrokerEntryMetadata(brokerEntryMetadata);
            }
            List<Message<byte[]>> list = Collections.singletonList(messageImpl);
            return list;
        }
    }

    private List<Message<byte[]>> getIndividualMsgsFromBatch(String topic, String msgId, byte[] data, Map<String, String> properties, MessageMetadata msgMetadataBuilder, BrokerEntryMetadata brokerEntryMetadata) {
        ArrayList<Message<byte[]>> ret = new ArrayList<Message<byte[]>>();
        int batchSize = Integer.parseInt(properties.get(BATCH_HEADER));
        ByteBuf buf = Unpooled.wrappedBuffer(data);
        for (int i = 0; i < batchSize; ++i) {
            String batchMsgId = msgId + ":" + i;
            SingleMessageMetadata singleMessageMetadata = new SingleMessageMetadata();
            try {
                ByteBuf singleMessagePayload = Commands.deSerializeSingleMessageInBatch(buf, singleMessageMetadata, i, batchSize);
                if (singleMessageMetadata.getPropertiesCount() > 0) {
                    for (KeyValue entry : singleMessageMetadata.getPropertiesList()) {
                        properties.put(entry.getKey(), entry.getValue());
                    }
                }
                MessageImpl message = new MessageImpl(topic, batchMsgId, properties, singleMessagePayload, Schema.BYTES, msgMetadataBuilder);
                if (brokerEntryMetadata != null) {
                    message.setBrokerEntryMetadata(brokerEntryMetadata);
                }
                ret.add(message);
                continue;
            }
            catch (Exception ex) {
                log.error("Exception occurred while trying to get BatchMsgId: {}", (Object)batchMsgId, (Object)ex);
            }
        }
        buf.release();
        return ret;
    }

    public MessageId getLastMessageId(String topic) throws PulsarAdminException {
        return (MessageId)this.sync(() -> this.getLastMessageIdAsync(topic));
    }

    public CompletableFuture<MessageId> getLastMessageIdAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "lastMessageId");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<BatchMessageIdImpl>(){}).thenApply(response -> {
            if (response.getBatchIndex() == -1) {
                return new MessageIdImpl(response.getLedgerId(), response.getEntryId(), response.getPartitionIndex());
            }
            return response;
        });
    }

    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String topic) throws PulsarAdminException {
        return this.getBacklogQuotaMap(topic, false);
    }

    public Map<BacklogQuota.BacklogQuotaType, BacklogQuota> getBacklogQuotaMap(String topic, boolean applied) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuotaMap");
            path = path.queryParam("applied", applied);
            return this.request(path).get(new GenericType<Map<BacklogQuota.BacklogQuotaType, BacklogQuota>>(){});
        }
        catch (Exception e) {
            throw TopicsImpl.getApiException(e);
        }
    }

    public AnalyzeSubscriptionBacklogResult analyzeSubscriptionBacklog(String topic, String subscriptionName, Optional<MessageId> startPosition) throws PulsarAdminException {
        return (AnalyzeSubscriptionBacklogResult)this.sync(() -> this.analyzeSubscriptionBacklogAsync(topic, subscriptionName, startPosition));
    }

    public CompletableFuture<AnalyzeSubscriptionBacklogResult> analyzeSubscriptionBacklogAsync(String topic, String subscriptionName, Optional<MessageId> startPosition) {
        TopicName topicName = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subscriptionName);
        WebTarget path = this.topicPath(topicName, "subscription", encodedSubName, "analyzeBacklog");
        final CompletableFuture<AnalyzeSubscriptionBacklogResult> future = new CompletableFuture<AnalyzeSubscriptionBacklogResult>();
        Entity<ResetCursorData> entity = null;
        if (startPosition.isPresent()) {
            ResetCursorData resetCursorData = new ResetCursorData(startPosition.get());
            entity = Entity.entity(resetCursorData, "application/json");
        } else {
            entity = null;
        }
        this.asyncPostRequestWithResponse(path, entity, new InvocationCallback<AnalyzeSubscriptionBacklogResult>(){

            @Override
            public void completed(AnalyzeSubscriptionBacklogResult res) {
                future.complete(res);
            }

            @Override
            public void failed(Throwable throwable) {
                future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
            }
        });
        return future;
    }

    public Long getBacklogSizeByMessageId(String topic, MessageId messageId) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getBacklogSizeByMessageIdAsync(topic, messageId));
    }

    public CompletableFuture<Long> getBacklogSizeByMessageIdAsync(String topic, MessageId messageId) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "backlogSize");
        final CompletableFuture<Long> future = new CompletableFuture<Long>();
        try {
            this.request(path).async().put(Entity.entity(messageId, "application/json"), new InvocationCallback<Long>(){

                @Override
                public void completed(Long backlogSize) {
                    future.complete(backlogSize);
                }

                @Override
                public void failed(Throwable throwable) {
                    future.completeExceptionally(BaseResource.getApiException(throwable.getCause()));
                }
            });
        }
        catch (PulsarAdminException cae) {
            future.completeExceptionally(cae);
        }
        return future;
    }

    public void setBacklogQuota(String topic, BacklogQuota backlogQuota, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuota");
            this.request(path.queryParam("backlogQuotaType", backlogQuotaType.toString())).post(Entity.entity(backlogQuota, "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw TopicsImpl.getApiException(e);
        }
    }

    public void removeBacklogQuota(String topic, BacklogQuota.BacklogQuotaType backlogQuotaType) throws PulsarAdminException {
        try {
            TopicName tn = this.validateTopic(topic);
            WebTarget path = this.topicPath(tn, "backlogQuota");
            this.request(path.queryParam("backlogQuotaType", backlogQuotaType.toString())).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw TopicsImpl.getApiException(e);
        }
    }

    public Integer getMaxUnackedMessagesOnConsumer(String topic) throws PulsarAdminException {
        return this.getMaxUnackedMessagesOnConsumer(topic, false);
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnConsumerAsync(String topic) {
        return this.getMaxUnackedMessagesOnConsumerAsync(topic, false);
    }

    public Integer getMaxUnackedMessagesOnConsumer(String topic, boolean applied) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxUnackedMessagesOnConsumerAsync(topic, applied));
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnConsumerAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Integer>(){});
    }

    public CompletableFuture<Void> setMaxUnackedMessagesOnConsumerAsync(String topic, int maxNum) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxNum), "application/json"));
    }

    public void setMaxUnackedMessagesOnConsumer(String topic, int maxNum) throws PulsarAdminException {
        this.sync(() -> this.setMaxUnackedMessagesOnConsumerAsync(topic, maxNum));
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesOnConsumerAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnConsumer");
        return this.asyncDeleteRequest(path);
    }

    public void removeMaxUnackedMessagesOnConsumer(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxUnackedMessagesOnConsumerAsync(topic));
    }

    public InactiveTopicPolicies getInactiveTopicPolicies(String topic, boolean applied) throws PulsarAdminException {
        return (InactiveTopicPolicies)this.sync(() -> this.getInactiveTopicPoliciesAsync(topic, applied));
    }

    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<InactiveTopicPolicies>(){});
    }

    public InactiveTopicPolicies getInactiveTopicPolicies(String topic) throws PulsarAdminException {
        return this.getInactiveTopicPolicies(topic, false);
    }

    public CompletableFuture<InactiveTopicPolicies> getInactiveTopicPoliciesAsync(String topic) {
        return this.getInactiveTopicPoliciesAsync(topic, false);
    }

    public CompletableFuture<Void> setInactiveTopicPoliciesAsync(String topic, InactiveTopicPolicies inactiveTopicPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        return this.asyncPostRequest(path, Entity.entity(inactiveTopicPolicies, "application/json"));
    }

    public void setInactiveTopicPolicies(String topic, InactiveTopicPolicies inactiveTopicPolicies) throws PulsarAdminException {
        this.sync(() -> this.setInactiveTopicPoliciesAsync(topic, inactiveTopicPolicies));
    }

    public CompletableFuture<Void> removeInactiveTopicPoliciesAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "inactiveTopicPolicies");
        return this.asyncDeleteRequest(path);
    }

    public void removeInactiveTopicPolicies(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeInactiveTopicPoliciesAsync(topic));
    }

    public DelayedDeliveryPolicies getDelayedDeliveryPolicy(String topic, boolean applied) throws PulsarAdminException {
        return (DelayedDeliveryPolicies)this.sync(() -> this.getDelayedDeliveryPolicyAsync(topic, applied));
    }

    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryPolicyAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<DelayedDeliveryPolicies>(){});
    }

    public DelayedDeliveryPolicies getDelayedDeliveryPolicy(String topic) throws PulsarAdminException {
        return this.getDelayedDeliveryPolicy(topic, false);
    }

    public CompletableFuture<DelayedDeliveryPolicies> getDelayedDeliveryPolicyAsync(String topic) {
        return this.getDelayedDeliveryPolicyAsync(topic, false);
    }

    public CompletableFuture<Void> removeDelayedDeliveryPolicyAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        return this.asyncDeleteRequest(path);
    }

    public void removeDelayedDeliveryPolicy(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeDelayedDeliveryPolicyAsync(topic));
    }

    public CompletableFuture<Void> setDelayedDeliveryPolicyAsync(String topic, DelayedDeliveryPolicies delayedDeliveryPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "delayedDelivery");
        return this.asyncPostRequest(path, Entity.entity(delayedDeliveryPolicies, "application/json"));
    }

    public void setDelayedDeliveryPolicy(String topic, DelayedDeliveryPolicies delayedDeliveryPolicies) throws PulsarAdminException {
        this.sync(() -> this.setDelayedDeliveryPolicyAsync(topic, delayedDeliveryPolicies));
    }

    public Boolean getDeduplicationEnabled(String topic) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getDeduplicationEnabledAsync(topic));
    }

    public CompletableFuture<Boolean> getDeduplicationEnabledAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Boolean>(){});
    }

    public Boolean getDeduplicationStatus(String topic) throws PulsarAdminException {
        return this.getDeduplicationStatus(topic, false);
    }

    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String topic) {
        return this.getDeduplicationStatusAsync(topic, false);
    }

    public Boolean getDeduplicationStatus(String topic, boolean applied) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getDeduplicationStatusAsync(topic, applied));
    }

    public CompletableFuture<Boolean> getDeduplicationStatusAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Boolean>(){});
    }

    public void enableDeduplication(String topic, boolean enabled) throws PulsarAdminException {
        this.sync(() -> this.enableDeduplicationAsync(topic, enabled));
    }

    public CompletableFuture<Void> enableDeduplicationAsync(String topic, boolean enabled) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(enabled), "application/json"));
    }

    public void setDeduplicationStatus(String topic, boolean enabled) throws PulsarAdminException {
        this.sync(() -> this.enableDeduplicationAsync(topic, enabled));
    }

    public CompletableFuture<Void> setDeduplicationStatusAsync(String topic, boolean enabled) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(enabled), "application/json"));
    }

    public void disableDeduplication(String topic) throws PulsarAdminException {
        this.sync(() -> this.disableDeduplicationAsync(topic));
    }

    public CompletableFuture<Void> disableDeduplicationAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationEnabled");
        return this.asyncDeleteRequest(path);
    }

    public void removeDeduplicationStatus(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeDeduplicationStatusAsync(topic));
    }

    public CompletableFuture<Void> removeDeduplicationStatusAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationEnabled");
        return this.asyncDeleteRequest(path);
    }

    public OffloadPolicies getOffloadPolicies(String topic) throws PulsarAdminException {
        return this.getOffloadPolicies(topic, false);
    }

    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String topic) {
        return this.getOffloadPoliciesAsync(topic, false);
    }

    public OffloadPolicies getOffloadPolicies(String topic, boolean applied) throws PulsarAdminException {
        return (OffloadPolicies)this.sync(() -> this.getOffloadPoliciesAsync(topic, applied));
    }

    public CompletableFuture<OffloadPolicies> getOffloadPoliciesAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<OffloadPoliciesImpl>(){}).thenApply(offloadPolicies -> offloadPolicies);
    }

    public void setOffloadPolicies(String topic, OffloadPolicies offloadPolicies) throws PulsarAdminException {
        this.sync(() -> this.setOffloadPoliciesAsync(topic, offloadPolicies));
    }

    public CompletableFuture<Void> setOffloadPoliciesAsync(String topic, OffloadPolicies offloadPolicies) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        return this.asyncPostRequest(path, Entity.entity((OffloadPoliciesImpl)offloadPolicies, "application/json"));
    }

    public void removeOffloadPolicies(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeOffloadPoliciesAsync(topic));
    }

    public CompletableFuture<Void> removeOffloadPoliciesAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "offloadPolicies");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxUnackedMessagesOnSubscription(String topic) throws PulsarAdminException {
        return this.getMaxUnackedMessagesOnSubscription(topic, false);
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnSubscriptionAsync(String topic) {
        return this.getMaxUnackedMessagesOnSubscriptionAsync(topic, false);
    }

    public Integer getMaxUnackedMessagesOnSubscription(String topic, boolean applied) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxUnackedMessagesOnSubscriptionAsync(topic, applied));
    }

    public CompletableFuture<Integer> getMaxUnackedMessagesOnSubscriptionAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Integer>(){});
    }

    public void setMaxUnackedMessagesOnSubscription(String topic, int maxNum) throws PulsarAdminException {
        this.sync(() -> this.setMaxUnackedMessagesOnSubscriptionAsync(topic, maxNum));
    }

    public CompletableFuture<Void> setMaxUnackedMessagesOnSubscriptionAsync(String topic, int maxNum) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxNum), "application/json"));
    }

    public void removeMaxUnackedMessagesOnSubscription(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxUnackedMessagesOnSubscriptionAsync(topic));
    }

    public CompletableFuture<Void> removeMaxUnackedMessagesOnSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxUnackedMessagesOnSubscription");
        return this.asyncDeleteRequest(path);
    }

    public void setMessageTTL(String topic, int messageTTLInSecond) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            this.request(path.queryParam("messageTTL", messageTTLInSecond)).post(Entity.entity("", "application/json"), ErrorData.class);
        }
        catch (Exception e) {
            throw TopicsImpl.getApiException(e);
        }
    }

    public Integer getMessageTTL(String topic) throws PulsarAdminException {
        return this.getMessageTTL(topic, false);
    }

    public Integer getMessageTTL(String topic, boolean applied) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            path = path.queryParam("applied", applied);
            return this.request(path).get(new GenericType<Integer>(){});
        }
        catch (Exception e) {
            throw TopicsImpl.getApiException(e);
        }
    }

    public void removeMessageTTL(String topic) throws PulsarAdminException {
        try {
            TopicName topicName = this.validateTopic(topic);
            WebTarget path = this.topicPath(topicName, "messageTTL");
            this.request(path.queryParam("messageTTL", 0)).delete(ErrorData.class);
        }
        catch (Exception e) {
            throw TopicsImpl.getApiException(e);
        }
    }

    public void setRetention(String topic, RetentionPolicies retention) throws PulsarAdminException {
        this.sync(() -> this.setRetentionAsync(topic, retention));
    }

    public CompletableFuture<Void> setRetentionAsync(String topic, RetentionPolicies retention) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        return this.asyncPostRequest(path, Entity.entity(retention, "application/json"));
    }

    public RetentionPolicies getRetention(String topic) throws PulsarAdminException {
        return this.getRetention(topic, false);
    }

    public CompletableFuture<RetentionPolicies> getRetentionAsync(String topic) {
        return this.getRetentionAsync(topic, false);
    }

    public RetentionPolicies getRetention(String topic, boolean applied) throws PulsarAdminException {
        return (RetentionPolicies)this.sync(() -> this.getRetentionAsync(topic, applied));
    }

    public CompletableFuture<RetentionPolicies> getRetentionAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<RetentionPolicies>(){});
    }

    public void removeRetention(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeRetentionAsync(topic));
    }

    public CompletableFuture<Void> removeRetentionAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "retention");
        return this.asyncDeleteRequest(path);
    }

    public void setPersistence(String topic, PersistencePolicies persistencePolicies) throws PulsarAdminException {
        this.sync(() -> this.setPersistenceAsync(topic, persistencePolicies));
    }

    public CompletableFuture<Void> setPersistenceAsync(String topic, PersistencePolicies persistencePolicies) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        return this.asyncPostRequest(path, Entity.entity(persistencePolicies, "application/json"));
    }

    public PersistencePolicies getPersistence(String topic) throws PulsarAdminException {
        return this.getPersistence(topic, false);
    }

    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String topic) {
        return this.getPersistenceAsync(topic, false);
    }

    public PersistencePolicies getPersistence(String topic, boolean applied) throws PulsarAdminException {
        return (PersistencePolicies)this.sync(() -> this.getPersistenceAsync(topic, applied));
    }

    public CompletableFuture<PersistencePolicies> getPersistenceAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PersistencePolicies>(){});
    }

    public void removePersistence(String topic) throws PulsarAdminException {
        this.sync(() -> this.removePersistenceAsync(topic));
    }

    public CompletableFuture<Void> removePersistenceAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "persistence");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getDispatchRateAsync(topic, applied));
    }

    public CompletableFuture<DispatchRate> getDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<DispatchRate>(){});
    }

    public DispatchRate getDispatchRate(String topic) throws PulsarAdminException {
        return this.getDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getDispatchRateAsync(String topic) {
        return this.getDispatchRateAsync(topic, false);
    }

    public void setDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setDispatchRateAsync(topic, dispatchRate));
    }

    public CompletableFuture<Void> setDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public void removeDispatchRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeDispatchRateAsync(topic));
    }

    public CompletableFuture<Void> removeDispatchRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "dispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getSubscriptionDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getSubscriptionDispatchRateAsync(topic, applied));
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<DispatchRate>(){});
    }

    public DispatchRate getSubscriptionDispatchRate(String topic) throws PulsarAdminException {
        return this.getSubscriptionDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getSubscriptionDispatchRateAsync(String topic) {
        return this.getSubscriptionDispatchRateAsync(topic, false);
    }

    public void setSubscriptionDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionDispatchRateAsync(topic, dispatchRate));
    }

    public CompletableFuture<Void> setSubscriptionDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public void removeSubscriptionDispatchRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionDispatchRateAsync(topic));
    }

    public CompletableFuture<Void> removeSubscriptionDispatchRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public Long getCompactionThreshold(String topic) throws PulsarAdminException {
        return this.getCompactionThreshold(topic, false);
    }

    public CompletableFuture<Long> getCompactionThresholdAsync(String topic) {
        return this.getCompactionThresholdAsync(topic, false);
    }

    public Long getCompactionThreshold(String topic, boolean applied) throws PulsarAdminException {
        return (Long)this.sync(() -> this.getCompactionThresholdAsync(topic, applied));
    }

    public CompletableFuture<Long> getCompactionThresholdAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Long>(){});
    }

    public void setCompactionThreshold(String topic, long compactionThreshold) throws PulsarAdminException {
        this.sync(() -> this.setCompactionThresholdAsync(topic, compactionThreshold));
    }

    public CompletableFuture<Void> setCompactionThresholdAsync(String topic, long compactionThreshold) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        return this.asyncPostRequest(path, Entity.entity(Long.valueOf(compactionThreshold), "application/json"));
    }

    public void removeCompactionThreshold(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeCompactionThresholdAsync(topic));
    }

    public CompletableFuture<Void> removeCompactionThresholdAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "compactionThreshold");
        return this.asyncDeleteRequest(path);
    }

    public PublishRate getPublishRate(String topic) throws PulsarAdminException {
        return (PublishRate)this.sync(() -> this.getPublishRateAsync(topic));
    }

    public CompletableFuture<PublishRate> getPublishRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<PublishRate>(){});
    }

    public void setPublishRate(String topic, PublishRate publishRate) throws PulsarAdminException {
        this.sync(() -> this.setPublishRateAsync(topic, publishRate));
    }

    public CompletableFuture<Void> setPublishRateAsync(String topic, PublishRate publishRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        return this.asyncPostRequest(path, Entity.entity(publishRate, "application/json"));
    }

    public void removePublishRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removePublishRateAsync(topic));
    }

    public CompletableFuture<Void> removePublishRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "publishRate");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumersPerSubscription(String topic) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxConsumersPerSubscriptionAsync(topic));
    }

    public CompletableFuture<Integer> getMaxConsumersPerSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Integer>(){});
    }

    public void setMaxConsumersPerSubscription(String topic, int maxConsumersPerSubscription) throws PulsarAdminException {
        this.sync(() -> this.setMaxConsumersPerSubscriptionAsync(topic, maxConsumersPerSubscription));
    }

    public CompletableFuture<Void> setMaxConsumersPerSubscriptionAsync(String topic, int maxConsumersPerSubscription) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumersPerSubscription), "application/json"));
    }

    public void removeMaxConsumersPerSubscription(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxConsumersPerSubscriptionAsync(topic));
    }

    public CompletableFuture<Void> removeMaxConsumersPerSubscriptionAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "maxConsumersPerSubscription");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxProducers(String topic) throws PulsarAdminException {
        return this.getMaxProducers(topic, false);
    }

    public CompletableFuture<Integer> getMaxProducersAsync(String topic) {
        return this.getMaxProducersAsync(topic, false);
    }

    public Integer getMaxProducers(String topic, boolean applied) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxProducersAsync(topic, applied));
    }

    public CompletableFuture<Integer> getMaxProducersAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Integer>(){});
    }

    public void setMaxProducers(String topic, int maxProducers) throws PulsarAdminException {
        this.sync(() -> this.setMaxProducersAsync(topic, maxProducers));
    }

    public CompletableFuture<Void> setMaxProducersAsync(String topic, int maxProducers) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxProducers), "application/json"));
    }

    public void removeMaxProducers(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxProducersAsync(topic));
    }

    public CompletableFuture<Void> removeMaxProducersAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxProducers");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxSubscriptionsPerTopic(String topic) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxSubscriptionsPerTopicAsync(topic));
    }

    public CompletableFuture<Integer> getMaxSubscriptionsPerTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Integer>(){});
    }

    public void setMaxSubscriptionsPerTopic(String topic, int maxSubscriptionsPerTopic) throws PulsarAdminException {
        this.sync(() -> this.setMaxSubscriptionsPerTopicAsync(topic, maxSubscriptionsPerTopic));
    }

    public CompletableFuture<Void> setMaxSubscriptionsPerTopicAsync(String topic, int maxSubscriptionsPerTopic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxSubscriptionsPerTopic), "application/json"));
    }

    public void removeMaxSubscriptionsPerTopic(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxSubscriptionsPerTopicAsync(topic));
    }

    public CompletableFuture<Void> removeMaxSubscriptionsPerTopicAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxSubscriptionsPerTopic");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxMessageSize(String topic) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxMessageSizeAsync(topic));
    }

    public CompletableFuture<Integer> getMaxMessageSizeAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Integer>(){});
    }

    public void setMaxMessageSize(String topic, int maxMessageSize) throws PulsarAdminException {
        this.sync(() -> this.setMaxMessageSizeAsync(topic, maxMessageSize));
    }

    public CompletableFuture<Void> setMaxMessageSizeAsync(String topic, int maxMessageSize) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxMessageSize), "application/json"));
    }

    public void removeMaxMessageSize(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxMessageSizeAsync(topic));
    }

    public CompletableFuture<Void> removeMaxMessageSizeAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxMessageSize");
        return this.asyncDeleteRequest(path);
    }

    public Integer getMaxConsumers(String topic) throws PulsarAdminException {
        return this.getMaxConsumers(topic, false);
    }

    public CompletableFuture<Integer> getMaxConsumersAsync(String topic) {
        return this.getMaxConsumersAsync(topic, false);
    }

    public Integer getMaxConsumers(String topic, boolean applied) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getMaxConsumersAsync(topic, applied));
    }

    public CompletableFuture<Integer> getMaxConsumersAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Integer>(){});
    }

    public void setMaxConsumers(String topic, int maxConsumers) throws PulsarAdminException {
        this.sync(() -> this.setMaxConsumersAsync(topic, maxConsumers));
    }

    public CompletableFuture<Void> setMaxConsumersAsync(String topic, int maxConsumers) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(maxConsumers), "application/json"));
    }

    public void removeMaxConsumers(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeMaxConsumersAsync(topic));
    }

    public CompletableFuture<Void> removeMaxConsumersAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "maxConsumers");
        return this.asyncDeleteRequest(path);
    }

    public Integer getDeduplicationSnapshotInterval(String topic) throws PulsarAdminException {
        return (Integer)this.sync(() -> this.getDeduplicationSnapshotIntervalAsync(topic));
    }

    public CompletableFuture<Integer> getDeduplicationSnapshotIntervalAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "deduplicationSnapshotInterval");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Integer>(){});
    }

    public void setDeduplicationSnapshotInterval(String topic, int interval) throws PulsarAdminException {
        this.sync(() -> this.setDeduplicationSnapshotIntervalAsync(topic, interval));
    }

    public CompletableFuture<Void> setDeduplicationSnapshotIntervalAsync(String topic, int interval) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationSnapshotInterval");
        return this.asyncPostRequest(path, Entity.entity(Integer.valueOf(interval), "application/json"));
    }

    public void removeDeduplicationSnapshotInterval(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeDeduplicationSnapshotIntervalAsync(topic));
    }

    public CompletableFuture<Void> removeDeduplicationSnapshotIntervalAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "deduplicationSnapshotInterval");
        return this.asyncDeleteRequest(path);
    }

    public void setSubscriptionTypesEnabled(String topic, Set<SubscriptionType> subscriptionTypesEnabled) throws PulsarAdminException {
        this.sync(() -> this.setSubscriptionTypesEnabledAsync(topic, subscriptionTypesEnabled));
    }

    public CompletableFuture<Void> setSubscriptionTypesEnabledAsync(String topic, Set<SubscriptionType> subscriptionTypesEnabled) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "subscriptionTypesEnabled");
        return this.asyncPostRequest(path, Entity.entity(subscriptionTypesEnabled, "application/json"));
    }

    public Set<SubscriptionType> getSubscriptionTypesEnabled(String topic) throws PulsarAdminException {
        return (Set)this.sync(() -> this.getSubscriptionTypesEnabledAsync(topic));
    }

    public CompletableFuture<Set<SubscriptionType>> getSubscriptionTypesEnabledAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionTypesEnabled");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Set<SubscriptionType>>(){});
    }

    public void removeSubscriptionTypesEnabled(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeSubscriptionTypesEnabledAsync(topic));
    }

    public CompletableFuture<Void> removeSubscriptionTypesEnabledAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscriptionTypesEnabled");
        return this.asyncDeleteRequest(path);
    }

    public DispatchRate getReplicatorDispatchRate(String topic) throws PulsarAdminException {
        return this.getReplicatorDispatchRate(topic, false);
    }

    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String topic) {
        return this.getReplicatorDispatchRateAsync(topic, false);
    }

    public DispatchRate getReplicatorDispatchRate(String topic, boolean applied) throws PulsarAdminException {
        return (DispatchRate)this.sync(() -> this.getReplicatorDispatchRateAsync(topic, applied));
    }

    public CompletableFuture<DispatchRate> getReplicatorDispatchRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "replicatorDispatchRate");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<DispatchRate>(){});
    }

    public void setReplicatorDispatchRate(String topic, DispatchRate dispatchRate) throws PulsarAdminException {
        this.sync(() -> this.setReplicatorDispatchRateAsync(topic, dispatchRate));
    }

    public CompletableFuture<Void> setReplicatorDispatchRateAsync(String topic, DispatchRate dispatchRate) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replicatorDispatchRate");
        return this.asyncPostRequest(path, Entity.entity(dispatchRate, "application/json"));
    }

    public void removeReplicatorDispatchRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeReplicatorDispatchRateAsync(topic));
    }

    public CompletableFuture<Void> removeReplicatorDispatchRateAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replicatorDispatchRate");
        return this.asyncDeleteRequest(path);
    }

    public SubscribeRate getSubscribeRate(String topic) throws PulsarAdminException {
        return this.getSubscribeRate(topic, false);
    }

    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String topic) {
        return this.getSubscribeRateAsync(topic, false);
    }

    public SubscribeRate getSubscribeRate(String topic, boolean applied) throws PulsarAdminException {
        return (SubscribeRate)this.sync(() -> this.getSubscribeRateAsync(topic, applied));
    }

    public CompletableFuture<SubscribeRate> getSubscribeRateAsync(String topic, boolean applied) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<SubscribeRate>(){});
    }

    public void setSubscribeRate(String topic, SubscribeRate subscribeRate) throws PulsarAdminException {
        this.sync(() -> this.setSubscribeRateAsync(topic, subscribeRate));
    }

    public CompletableFuture<Void> setSubscribeRateAsync(String topic, SubscribeRate subscribeRate) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        return this.asyncPostRequest(path, Entity.entity(subscribeRate, "application/json"));
    }

    public void removeSubscribeRate(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeSubscribeRateAsync(topic));
    }

    public CompletableFuture<Void> removeSubscribeRateAsync(String topic) {
        TopicName topicName = this.validateTopic(topic);
        WebTarget path = this.topicPath(topicName, "subscribeRate");
        return this.asyncDeleteRequest(path);
    }

    public void setReplicatedSubscriptionStatus(String topic, String subName, boolean enabled) throws PulsarAdminException {
        this.sync(() -> this.setReplicatedSubscriptionStatusAsync(topic, subName, enabled));
    }

    public CompletableFuture<Void> setReplicatedSubscriptionStatusAsync(String topic, String subName, boolean enabled) {
        TopicName topicName = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(topicName, "subscription", encodedSubName, "replicatedSubscriptionStatus");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(enabled), "application/json"));
    }

    public Map<String, Boolean> getReplicatedSubscriptionStatus(String topic, String subName) throws PulsarAdminException {
        return (Map)this.sync(() -> this.getReplicatedSubscriptionStatusAsync(topic, subName));
    }

    public CompletableFuture<Map<String, Boolean>> getReplicatedSubscriptionStatusAsync(String topic, String subName) {
        TopicName topicName = this.validateTopic(topic);
        String encodedSubName = Codec.encode(subName);
        WebTarget path = this.topicPath(topicName, "subscription", encodedSubName, "replicatedSubscriptionStatus");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Map<String, Boolean>>(){});
    }

    public boolean getSchemaValidationEnforced(String topic, boolean applied) throws PulsarAdminException {
        return (Boolean)this.sync(() -> this.getSchemaValidationEnforcedAsync(topic, applied));
    }

    public void setSchemaValidationEnforced(String topic, boolean enable) throws PulsarAdminException {
        this.sync(() -> this.setSchemaValidationEnforcedAsync(topic, enable));
    }

    public CompletableFuture<Boolean> getSchemaValidationEnforcedAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "schemaValidationEnforced");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Boolean>(){});
    }

    public CompletableFuture<Void> setSchemaValidationEnforcedAsync(String topic, boolean schemaValidationEnforced) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "schemaValidationEnforced");
        return this.asyncPostRequest(path, Entity.entity(Boolean.valueOf(schemaValidationEnforced), "application/json"));
    }

    public Set<String> getReplicationClusters(String topic, boolean applied) throws PulsarAdminException {
        return (Set)this.sync(() -> this.getReplicationClustersAsync(topic, applied));
    }

    public CompletableFuture<Set<String>> getReplicationClustersAsync(String topic, boolean applied) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replication");
        path = path.queryParam("applied", applied);
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<Set<String>>(){});
    }

    public void setReplicationClusters(String topic, List<String> clusterIds) throws PulsarAdminException {
        this.sync(() -> this.setReplicationClustersAsync(topic, clusterIds));
    }

    public CompletableFuture<Void> setReplicationClustersAsync(String topic, List<String> clusterIds) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replication");
        return this.asyncPostRequest(path, Entity.entity(clusterIds, "application/json"));
    }

    public void removeReplicationClusters(String topic) throws PulsarAdminException {
        this.sync(() -> this.removeReplicationClustersAsync(topic));
    }

    public CompletableFuture<Void> removeReplicationClustersAsync(String topic) {
        TopicName tn = this.validateTopic(topic);
        WebTarget path = this.topicPath(tn, "replication");
        return this.asyncDeleteRequest(path);
    }

    public void setShadowTopics(String sourceTopic, List<String> shadowTopics) throws PulsarAdminException {
        this.sync(() -> this.setShadowTopicsAsync(sourceTopic, shadowTopics));
    }

    public void removeShadowTopics(String sourceTopic) throws PulsarAdminException {
        this.sync(() -> this.removeShadowTopicsAsync(sourceTopic));
    }

    public List<String> getShadowTopics(String sourceTopic) throws PulsarAdminException {
        return (List)this.sync(() -> this.getShadowTopicsAsync(sourceTopic));
    }

    public CompletableFuture<Void> setShadowTopicsAsync(String sourceTopic, List<String> shadowTopics) {
        TopicName tn = this.validateTopic(sourceTopic);
        WebTarget path = this.topicPath(tn, "shadowTopics");
        return this.asyncPutRequest(path, Entity.entity(shadowTopics, "application/json"));
    }

    public CompletableFuture<Void> removeShadowTopicsAsync(String sourceTopic) {
        TopicName tn = this.validateTopic(sourceTopic);
        WebTarget path = this.topicPath(tn, "shadowTopics");
        return this.asyncDeleteRequest(path);
    }

    public CompletableFuture<List<String>> getShadowTopicsAsync(String sourceTopic) {
        TopicName tn = this.validateTopic(sourceTopic);
        WebTarget path = this.topicPath(tn, "shadowTopics");
        return this.asyncGetRequest(path, new BaseResource.FutureCallback<List<String>>(){});
    }

    public String getShadowSource(String shadowTopic) throws PulsarAdminException {
        return (String)this.sync(() -> this.getShadowSourceAsync(shadowTopic));
    }

    public CompletableFuture<String> getShadowSourceAsync(String shadowTopic) {
        return this.getPropertiesAsync(shadowTopic).thenApply(properties -> properties != null ? (String)properties.get(PROPERTY_SHADOW_SOURCE_KEY) : null);
    }

    public void createShadowTopic(String shadowTopic, String sourceTopic, Map<String, String> properties) throws PulsarAdminException {
        this.sync(() -> this.createShadowTopicAsync(shadowTopic, sourceTopic, properties));
    }

    public CompletableFuture<Void> createShadowTopicAsync(String shadowTopic, String sourceTopic, Map<String, String> properties) {
        Preconditions.checkArgument(TopicName.get(shadowTopic).isPersistent(), "Shadow topic must be persistent");
        Preconditions.checkArgument(TopicName.get(sourceTopic).isPersistent(), "Source topic must be persistent");
        return this.getPartitionedTopicMetadataAsync(sourceTopic).thenCompose(sourceTopicMeta -> {
            HashMap<String, String> shadowProperties = new HashMap<String, String>();
            if (properties != null) {
                shadowProperties.putAll(properties);
            }
            shadowProperties.put(PROPERTY_SHADOW_SOURCE_KEY, sourceTopic);
            if (sourceTopicMeta.partitions == 0) {
                return this.createNonPartitionedTopicAsync(shadowTopic, shadowProperties);
            }
            return this.createPartitionedTopicAsync(shadowTopic, sourceTopicMeta.partitions, shadowProperties);
        });
    }
}

