/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.pulsar.client.api;

import org.apache.pulsar.client.internal.DefaultImplementation;

import java.io.Serializable;

/**
 * Batcher builder
 */
public interface BatcherBuilder extends Serializable {

    /**
     * Default batch message container
     *
     * incoming single messages:
     * (k1, v1), (k2, v1), (k3, v1), (k1, v2), (k2, v2), (k3, v2), (k1, v3), (k2, v3), (k3, v3)
     *
     * batched into single batch message:
     * [(k1, v1), (k2, v1), (k3, v1), (k1, v2), (k2, v2), (k3, v2), (k1, v3), (k2, v3), (k3, v3)]
     */
    BatcherBuilder DEFAULT = DefaultImplementation.newDefaultBatcherBuilder();

    /**
     * Key based batch message container
     *
     * incoming single messages:
     * (k1, v1), (k2, v1), (k3, v1), (k1, v2), (k2, v2), (k3, v2), (k1, v3), (k2, v3), (k3, v3)
     *
     * batched into multiple batch messages:
     * [(k1, v1), (k1, v2), (k1, v3)], [(k2, v1), (k2, v2), (k2, v3)], [(k3, v1), (k3, v2), (k3, v3)]
     */
    BatcherBuilder KEY_BASED = DefaultImplementation.newKeyBasedBatcherBuilder();

    /**
     * Build a new batch message container.
     * @return new batch message container
     */
    BatchMessageContainer build();

}
