/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

import java.util.concurrent.TimeUnit;

public class BatchReceivePolicy {
    public static final BatchReceivePolicy DEFAULT_POLICY = new BatchReceivePolicy(-1, 0xA00000, 100, TimeUnit.MILLISECONDS);
    private final int maxNumMessages;
    private final int maxNumBytes;
    private final int timeout;
    private final TimeUnit timeoutUnit;

    private BatchReceivePolicy(int maxNumMessages, int maxNumBytes, int timeout, TimeUnit timeoutUnit) {
        this.maxNumMessages = maxNumMessages;
        this.maxNumBytes = maxNumBytes;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public void verify() {
        if (this.maxNumMessages <= 0 && this.maxNumBytes <= 0 && this.timeout <= 0) {
            throw new IllegalArgumentException("At least one of maxNumMessages, maxNumBytes, timeout must be specified.");
        }
        if (this.timeout > 0 && this.timeoutUnit == null) {
            throw new IllegalArgumentException("Must set timeout unit for timeout.");
        }
    }

    public long getTimeoutMs() {
        return this.timeout > 0 && this.timeoutUnit != null ? this.timeoutUnit.toMillis(this.timeout) : 0L;
    }

    public int getMaxNumMessages() {
        return this.maxNumMessages;
    }

    public long getMaxNumBytes() {
        return this.maxNumBytes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "BatchReceivePolicy{maxNumMessages=" + this.maxNumMessages + ", maxNumBytes=" + this.maxNumBytes + ", timeout=" + this.timeout + ", timeoutUnit=" + (Object)((Object)this.timeoutUnit) + '}';
    }

    public static class Builder {
        private int maxNumMessages;
        private int maxNumBytes;
        private int timeout;
        private TimeUnit timeoutUnit;

        public Builder maxNumMessages(int maxNumMessages) {
            this.maxNumMessages = maxNumMessages;
            return this;
        }

        public Builder maxNumBytes(int maxNumBytes) {
            this.maxNumBytes = maxNumBytes;
            return this;
        }

        public Builder timeout(int timeout, TimeUnit timeoutUnit) {
            this.timeout = timeout;
            this.timeoutUnit = timeoutUnit;
            return this;
        }

        public BatchReceivePolicy build() {
            return new BatchReceivePolicy(this.maxNumMessages, this.maxNumBytes, this.timeout, this.timeoutUnit);
        }
    }
}

