/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.api;

public class Range {
    private final int start;
    private final int end;

    public Range(int start, int end) {
        if (end < start) {
            throw new IllegalArgumentException("Range end must >= range start.");
        }
        this.start = start;
        this.end = end;
    }

    public static Range of(int start, int end) {
        return new Range(start, end);
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public Range intersect(Range range) {
        int end;
        int start = range.getStart() > this.getStart() ? range.getStart() : this.getStart();
        int n = end = range.getEnd() < this.getEnd() ? range.getEnd() : this.getEnd();
        if (end >= start) {
            return Range.of(start, end);
        }
        return null;
    }

    public String toString() {
        return "[" + this.start + ", " + this.end + "]";
    }
}

