/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.util.Map;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.impl.schema.SchemaUtils;
import org.apache.pulsar.client.impl.schema.StructSchema;
import org.apache.pulsar.client.impl.schema.reader.AvroReader;
import org.apache.pulsar.client.impl.schema.writer.AvroWriter;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.org.apache.avro.Conversions;
import org.apache.pulsar.shade.org.apache.avro.data.TimeConversions;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchema<T>
extends StructSchema<T> {
    private static final Logger log;
    private static final Logger LOG;

    private AvroSchema(SchemaInfo schemaInfo) {
        super(schemaInfo);
        this.setReader(new AvroReader(this.schema));
        this.setWriter(new AvroWriter(this.schema));
    }

    public boolean supportSchemaVersioning() {
        return true;
    }

    public static <T> AvroSchema<T> of(SchemaDefinition<T> schemaDefinition) {
        return new AvroSchema<T>(AvroSchema.parseSchemaInfo(schemaDefinition, SchemaType.AVRO));
    }

    public static <T> AvroSchema<T> of(Class<T> pojo) {
        return AvroSchema.of(SchemaDefinition.builder().withPojo(pojo).build());
    }

    public static <T> AvroSchema<T> of(Class<T> pojo, Map<String, String> properties) {
        SchemaDefinition schemaDefinition = SchemaDefinition.builder().withPojo(pojo).withProperties(properties).build();
        return new AvroSchema<T>(AvroSchema.parseSchemaInfo(schemaDefinition, SchemaType.AVRO));
    }

    @Override
    protected SchemaReader<T> loadReader(byte[] schemaVersion) {
        SchemaInfo schemaInfo = this.schemaInfoProvider.getSchemaByVersion(schemaVersion);
        if (schemaInfo != null) {
            log.info("Load schema reader for version({}), schema is : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion), (Object)schemaInfo.getSchemaDefinition());
            return new AvroReader(AvroSchema.parseAvroSchema(schemaInfo.getSchemaDefinition()), this.schema);
        }
        log.warn("No schema found for version({}), use latest schema : {}", (Object)SchemaUtils.getStringSchemaVersion(schemaVersion), (Object)this.schemaInfo.getSchemaDefinition());
        return this.reader;
    }

    static {
        block2: {
            log = LoggerFactory.getLogger(AvroSchema.class);
            LOG = LoggerFactory.getLogger(AvroSchema.class);
            try {
                ReflectData.AllowNull reflectDataAllowNull = ReflectData.AllowNull.get();
                reflectDataAllowNull.addLogicalTypeConversion(new Conversions.DecimalConversion());
                reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.DateConversion());
                reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.LossyTimeMicrosConversion());
                reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.LossyTimestampMicrosConversion());
                reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
                reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.TimestampMicrosConversion());
                reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.TimestampConversion());
                reflectDataAllowNull.addLogicalTypeConversion(new TimeConversions.TimeConversion());
                ReflectData reflectDataNotAllowNull = ReflectData.get();
                reflectDataNotAllowNull.addLogicalTypeConversion(new Conversions.DecimalConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.DateConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.TimestampConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.LossyTimeMicrosConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.LossyTimestampMicrosConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.TimeMicrosConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.TimestampMicrosConversion());
                reflectDataNotAllowNull.addLogicalTypeConversion(new TimeConversions.TimeConversion());
            }
            catch (Throwable t) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Avro logical types are not available. If you are going to use avro logical types, you can include `joda-time` in your dependency.");
            }
        }
    }
}

