/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.impl.schema.AvroSchema;
import org.apache.pulsar.client.impl.schema.BytesSchema;
import org.apache.pulsar.client.impl.schema.JSONSchema;
import org.apache.pulsar.client.impl.schema.KeyValueSchemaInfo;
import org.apache.pulsar.client.impl.schema.StructSchema;
import org.apache.pulsar.common.schema.KeyValue;
import org.apache.pulsar.common.schema.KeyValueEncodingType;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.base.Preconditions;

public class KeyValueSchema<K, V>
implements Schema<KeyValue<K, V>> {
    private final Schema<K> keySchema;
    private final Schema<V> valueSchema;
    private final SchemaInfo schemaInfo;
    private final KeyValueEncodingType keyValueEncodingType;
    protected SchemaInfoProvider schemaInfoProvider;
    private static final Schema<KeyValue<byte[], byte[]>> KV_BYTES = new KeyValueSchema<byte[], byte[]>(BytesSchema.of(), BytesSchema.of());

    public static <K, V> Schema<KeyValue<K, V>> of(Class<K> key, Class<V> value, SchemaType type) {
        Preconditions.checkArgument(SchemaType.JSON == type || SchemaType.AVRO == type);
        if (SchemaType.JSON == type) {
            return new KeyValueSchema<K, V>(JSONSchema.of(key), JSONSchema.of(value), KeyValueEncodingType.INLINE);
        }
        return new KeyValueSchema<K, V>(AvroSchema.of(key), AvroSchema.of(value), KeyValueEncodingType.INLINE);
    }

    public static <K, V> Schema<KeyValue<K, V>> of(Schema<K> keySchema, Schema<V> valueSchema) {
        return new KeyValueSchema<K, V>(keySchema, valueSchema, KeyValueEncodingType.INLINE);
    }

    public static <K, V> Schema<KeyValue<K, V>> of(Schema<K> keySchema, Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        return new KeyValueSchema<K, V>(keySchema, valueSchema, keyValueEncodingType);
    }

    public static Schema<KeyValue<byte[], byte[]>> kvBytes() {
        return KV_BYTES;
    }

    public boolean supportSchemaVersioning() {
        return this.keySchema.supportSchemaVersioning() || this.valueSchema.supportSchemaVersioning();
    }

    private KeyValueSchema(Schema<K> keySchema, Schema<V> valueSchema) {
        this(keySchema, valueSchema, KeyValueEncodingType.INLINE);
    }

    private KeyValueSchema(final Schema<K> keySchema, final Schema<V> valueSchema, KeyValueEncodingType keyValueEncodingType) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
        this.keyValueEncodingType = keyValueEncodingType;
        this.schemaInfo = KeyValueSchemaInfo.encodeKeyValueSchemaInfo(keySchema, valueSchema, keyValueEncodingType);
        if (keySchema instanceof StructSchema) {
            keySchema.setSchemaInfoProvider(new SchemaInfoProvider(){

                public SchemaInfo getSchemaByVersion(byte[] schemaVersion) {
                    SchemaInfo versionSchemaInfo = KeyValueSchema.this.schemaInfoProvider.getSchemaByVersion(schemaVersion);
                    return (SchemaInfo)KeyValueSchemaInfo.decodeKeyValueSchemaInfo(versionSchemaInfo).getKey();
                }

                public SchemaInfo getLatestSchema() {
                    return ((StructSchema)keySchema).schemaInfo;
                }

                public String getTopicName() {
                    return "key-schema";
                }
            });
        }
        if (valueSchema instanceof StructSchema) {
            valueSchema.setSchemaInfoProvider(new SchemaInfoProvider(){

                public SchemaInfo getSchemaByVersion(byte[] schemaVersion) {
                    SchemaInfo versionSchemaInfo = KeyValueSchema.this.schemaInfoProvider.getSchemaByVersion(schemaVersion);
                    return (SchemaInfo)KeyValueSchemaInfo.decodeKeyValueSchemaInfo(versionSchemaInfo).getValue();
                }

                public SchemaInfo getLatestSchema() {
                    return ((StructSchema)valueSchema).schemaInfo;
                }

                public String getTopicName() {
                    return "value-schema";
                }
            });
        }
        this.schemaInfoProvider = new SchemaInfoProvider(){

            public SchemaInfo getSchemaByVersion(byte[] schemaVersion) {
                return KeyValueSchema.this.schemaInfo;
            }

            public SchemaInfo getLatestSchema() {
                return KeyValueSchema.this.schemaInfo;
            }

            public String getTopicName() {
                return "key-value-schema";
            }
        };
    }

    public byte[] encode(KeyValue<K, V> message) {
        if (this.keyValueEncodingType != null && this.keyValueEncodingType == KeyValueEncodingType.INLINE) {
            return KeyValue.encode((Object)message.getKey(), this.keySchema, (Object)message.getValue(), this.valueSchema);
        }
        return this.valueSchema.encode(message.getValue());
    }

    public KeyValue<K, V> decode(byte[] bytes) {
        return this.decode(bytes, null);
    }

    public KeyValue<K, V> decode(byte[] bytes, byte[] schemaVersion) {
        if (this.keyValueEncodingType == KeyValueEncodingType.SEPARATED) {
            throw new SchemaSerializationException("This method cannot be used under this SEPARATED encoding type");
        }
        return KeyValue.decode((byte[])bytes, (keyBytes, valueBytes) -> this.decode(keyBytes, valueBytes, schemaVersion));
    }

    public KeyValue<K, V> decode(byte[] keyBytes, byte[] valueBytes, byte[] schemaVersion) {
        Object k = this.keySchema.supportSchemaVersioning() && schemaVersion != null ? this.keySchema.decode(keyBytes, schemaVersion) : this.keySchema.decode(keyBytes);
        Object v = this.valueSchema.supportSchemaVersioning() && schemaVersion != null ? this.valueSchema.decode(valueBytes, schemaVersion) : this.valueSchema.decode(valueBytes);
        return new KeyValue(k, v);
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
    }

    public Schema<K> getKeySchema() {
        return this.keySchema;
    }

    public Schema<V> getValueSchema() {
        return this.valueSchema;
    }

    public KeyValueEncodingType getKeyValueEncodingType() {
        return this.keyValueEncodingType;
    }
}

