/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.pulsar.client.api.schema.SchemaDefinition;
import org.apache.pulsar.client.api.schema.SchemaInfoProvider;
import org.apache.pulsar.client.api.schema.SchemaReader;
import org.apache.pulsar.client.api.schema.SchemaWriter;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;
import org.apache.pulsar.shade.com.google.common.cache.CacheBuilder;
import org.apache.pulsar.shade.com.google.common.cache.CacheLoader;
import org.apache.pulsar.shade.com.google.common.cache.LoadingCache;
import org.apache.pulsar.shade.org.apache.avro.Schema;
import org.apache.pulsar.shade.org.apache.avro.reflect.ReflectData;
import org.apache.pulsar.shade.org.apache.commons.codec.binary.Hex;
import org.apache.pulsar.shade.org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StructSchema<T>
implements org.apache.pulsar.client.api.Schema<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(StructSchema.class);
    protected final Schema schema;
    protected final SchemaInfo schemaInfo;
    protected SchemaReader<T> reader;
    protected SchemaWriter<T> writer;
    protected SchemaInfoProvider schemaInfoProvider;
    private final LoadingCache<byte[], SchemaReader<T>> readerCache = CacheBuilder.newBuilder().maximumSize(100000L).expireAfterAccess(30L, TimeUnit.MINUTES).build(new CacheLoader<byte[], SchemaReader<T>>(){

        @Override
        public SchemaReader<T> load(byte[] schemaVersion) {
            return StructSchema.this.loadReader(schemaVersion);
        }
    });

    protected StructSchema(SchemaInfo schemaInfo) {
        this.schema = StructSchema.parseAvroSchema(new String(schemaInfo.getSchema(), StandardCharsets.UTF_8));
        this.schemaInfo = schemaInfo;
    }

    public Schema getAvroSchema() {
        return this.schema;
    }

    public byte[] encode(T message) {
        return this.writer.write(message);
    }

    public T decode(byte[] bytes) {
        return (T)this.reader.read(bytes);
    }

    public T decode(byte[] bytes, byte[] schemaVersion) {
        try {
            return (T)this.readerCache.get(schemaVersion).read(bytes);
        }
        catch (ExecutionException e) {
            LOG.error("Can't get generic schema for topic {} schema version {}", new Object[]{this.schemaInfoProvider.getTopicName(), Hex.encodeHexString(schemaVersion), e});
            throw new RuntimeException("Can't get generic schema for topic " + this.schemaInfoProvider.getTopicName());
        }
    }

    public SchemaInfo getSchemaInfo() {
        return this.schemaInfo;
    }

    protected static Schema createAvroSchema(SchemaDefinition schemaDefinition) {
        Class pojo = schemaDefinition.getPojo();
        if (StringUtils.isNotBlank(schemaDefinition.getJsonDef())) {
            return StructSchema.parseAvroSchema(schemaDefinition.getJsonDef());
        }
        if (pojo != null) {
            return schemaDefinition.getAlwaysAllowNull() ? ReflectData.AllowNull.get().getSchema(pojo) : ReflectData.get().getSchema(pojo);
        }
        throw new RuntimeException("Schema definition must specify pojo class or schema json definition");
    }

    protected static Schema parseAvroSchema(String schemaJson) {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(schemaJson);
    }

    protected static <T> SchemaInfo parseSchemaInfo(SchemaDefinition<T> schemaDefinition, SchemaType schemaType) {
        return SchemaInfo.builder().schema(StructSchema.createAvroSchema(schemaDefinition).toString().getBytes(StandardCharsets.UTF_8)).properties(schemaDefinition.getProperties()).name("").type(schemaType).build();
    }

    public void setSchemaInfoProvider(SchemaInfoProvider schemaInfoProvider) {
        this.schemaInfoProvider = schemaInfoProvider;
    }

    protected abstract SchemaReader<T> loadReader(byte[] var1);

    protected void setWriter(SchemaWriter<T> writer) {
        this.writer = writer;
    }

    protected void setReader(SchemaReader<T> reader) {
        this.reader = reader;
    }

    protected SchemaReader<T> getReader() {
        return this.reader;
    }
}

