/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl.schema;

import org.apache.pulsar.client.api.Schema;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.common.schema.SchemaInfo;
import org.apache.pulsar.common.schema.SchemaType;

public class IntSchema
implements Schema<Integer> {
    private static final IntSchema INSTANCE = new IntSchema();
    private static final SchemaInfo SCHEMA_INFO = new SchemaInfo().setName("INT32").setType(SchemaType.INT32).setSchema(new byte[0]);

    public static IntSchema of() {
        return INSTANCE;
    }

    public void validate(byte[] message) {
        if (message.length != 4) {
            throw new SchemaSerializationException("Size of data received by IntSchema is not 4");
        }
    }

    public byte[] encode(Integer message) {
        if (null == message) {
            return null;
        }
        return new byte[]{(byte)(message >>> 24), (byte)(message >>> 16), (byte)(message >>> 8), message.byteValue()};
    }

    public Integer decode(byte[] bytes) {
        if (null == bytes) {
            return null;
        }
        this.validate(bytes);
        int value = 0;
        for (byte b : bytes) {
            value <<= 8;
            value |= b & 0xFF;
        }
        return value;
    }

    public SchemaInfo getSchemaInfo() {
        return SCHEMA_INFO;
    }
}

