/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.docs.tools;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGenerateDocumentation {
    private static final Logger log = LoggerFactory.getLogger(BaseGenerateDocumentation.class);
    JCommander jcommander;
    @Parameter(names={"-c", "--class-names"}, description="List of class names, generate documentation based on the annotations in the Class")
    private List<String> classNames = new ArrayList<String>();
    @Parameter(names={"-h", "--help"}, help=true, description="Show this help.")
    boolean help;
    protected Predicate<Field> isRequiredApiModel = field -> {
        ApiModelProperty modelProperty = field.getAnnotation(ApiModelProperty.class);
        return modelProperty.required();
    };
    protected Predicate<Field> isOptionalApiModel = field -> {
        ApiModelProperty modelProperty = field.getAnnotation(ApiModelProperty.class);
        return !modelProperty.required();
    };

    public BaseGenerateDocumentation() {
        this.jcommander = new JCommander();
        this.jcommander.setProgramName("pulsar-generateDocumentation");
        this.jcommander.addObject((Object)this);
    }

    public boolean run(String[] args) throws Exception {
        if (args.length == 0) {
            this.jcommander.usage();
            return false;
        }
        if (this.help) {
            this.jcommander.usage();
            return true;
        }
        try {
            this.jcommander.parse(Arrays.copyOfRange(args, 0, args.length));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            this.jcommander.usage();
            return false;
        }
        if (this.classNames != null) {
            for (String className : this.classNames) {
                System.out.println(this.generateDocumentByClassName(className));
            }
        }
        return true;
    }

    protected abstract String generateDocumentByClassName(String var1) throws Exception;

    private Annotation getFieldContextAnnotation(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (!annotation.annotationType().getCanonicalName().equals("org.apache.pulsar.common.configuration.FieldContext")) continue;
            return annotation;
        }
        return null;
    }

    protected void writeDocListByFieldContext(List<Pair<Field, FieldContextWrapper>> fieldList, StringBuilder sb, Object obj) throws Exception {
        for (Pair<Field, FieldContextWrapper> fieldPair : fieldList) {
            FieldContextWrapper fieldContext = (FieldContextWrapper)fieldPair.getValue();
            Field field = (Field)fieldPair.getKey();
            field.setAccessible(true);
            sb.append("### ").append(field.getName()).append("\n");
            sb.append(fieldContext.doc().replace(">", "\\>")).append("\n\n");
            sb.append("**Type**: `").append(field.getType().getCanonicalName()).append("`\n\n");
            sb.append("**Default**: `").append(field.get(obj)).append("`\n\n");
            sb.append("**Dynamic**: `").append(fieldContext.dynamic()).append("`\n\n");
            sb.append("**Category**: ").append(fieldContext.category()).append("\n\n");
        }
    }

    protected void writeDocListByApiModel(List<Field> fieldList, StringBuilder sb, Object obj) throws Exception {
        for (Field field : fieldList) {
            ApiModelProperty modelProperty = field.getAnnotation(ApiModelProperty.class);
            field.setAccessible(true);
            String name = StringUtils.isBlank((CharSequence)modelProperty.name()) ? field.getName() : modelProperty.name();
            sb.append("### ").append(name).append("\n");
            sb.append(modelProperty.value().replace(">", "\\>")).append("\n\n");
            sb.append("**Type**: `").append(field.getType().getCanonicalName()).append("`\n\n");
            sb.append("**Default**: `").append(field.get(obj)).append("`\n\n");
        }
    }

    protected String generateDocByFieldContext(String className, String type) throws Exception {
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = Class.forName(className);
        Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Object> fieldList = new ArrayList<Object>(fields.length);
        for (Field field : fields) {
            Annotation fieldContextAnnotation = this.getFieldContextAnnotation(field);
            if (fieldContextAnnotation == null) continue;
            fieldList.add(Pair.of((Object)field, (Object)new FieldContextWrapper(fieldContextAnnotation)));
        }
        fieldList.sort(new CategoryComparator());
        List<Pair<Field, FieldContextWrapper>> requiredFields = fieldList.stream().filter(p -> ((FieldContextWrapper)p.getValue()).required()).collect(Collectors.toList());
        List<Pair<Field, FieldContextWrapper>> optionalFields = fieldList.stream().filter(p -> !((FieldContextWrapper)p.getValue()).required() && !((FieldContextWrapper)p.getValue()).deprecated()).collect(Collectors.toList());
        List<Pair<Field, FieldContextWrapper>> deprecatedFields = fieldList.stream().filter(p -> ((FieldContextWrapper)p.getValue()).deprecated()).collect(Collectors.toList());
        sb.append("# ").append(type).append("\n\n");
        sb.append("## Required\n");
        this.writeDocListByFieldContext(requiredFields, sb, obj);
        sb.append("## Optional\n");
        this.writeDocListByFieldContext(optionalFields, sb, obj);
        sb.append("## Deprecated\n");
        this.writeDocListByFieldContext(deprecatedFields, sb, obj);
        return sb.toString();
    }

    protected String generateDocByApiModelProperty(String className, String type) throws Exception {
        StringBuilder sb = new StringBuilder();
        Class<?> clazz = Class.forName(className);
        Object obj = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        Field[] fields = clazz.getDeclaredFields();
        ArrayList<Field> fieldList = new ArrayList<Field>(Arrays.asList(fields));
        fieldList.removeIf(f -> f.getAnnotation(ApiModelProperty.class) == null);
        fieldList.sort(Comparator.comparing(Field::getName));
        List<Field> requiredFields = fieldList.stream().filter(this.isRequiredApiModel).collect(Collectors.toList());
        List<Field> optionalFields = fieldList.stream().filter(this.isOptionalApiModel).collect(Collectors.toList());
        sb.append("# ").append(type).append("\n\n");
        sb.append("## Required\n");
        this.writeDocListByApiModel(requiredFields, sb, obj);
        sb.append("## Optional\n");
        this.writeDocListByApiModel(optionalFields, sb, obj);
        return sb.toString();
    }

    private static class FieldContextWrapper {
        private final Object fieldContext;

        public FieldContextWrapper(Object fieldContext) {
            this.fieldContext = fieldContext;
        }

        String doc() {
            return (String)MethodUtils.invokeMethod((Object)this.fieldContext, (String)"doc");
        }

        Class type() {
            return (Class)MethodUtils.invokeMethod((Object)this.fieldContext, (String)"type");
        }

        boolean required() {
            return (Boolean)MethodUtils.invokeMethod((Object)this.fieldContext, (String)"required");
        }

        boolean deprecated() {
            return (Boolean)MethodUtils.invokeMethod((Object)this.fieldContext, (String)"deprecated");
        }

        boolean dynamic() {
            return (Boolean)MethodUtils.invokeMethod((Object)this.fieldContext, (String)"dynamic");
        }

        String category() {
            return (String)MethodUtils.invokeMethod((Object)this.fieldContext, (String)"category");
        }
    }

    protected static class CategoryComparator
    implements Comparator<Pair<Field, FieldContextWrapper>>,
    Serializable {
        protected CategoryComparator() {
        }

        @Override
        public int compare(Pair<Field, FieldContextWrapper> o1, Pair<Field, FieldContextWrapper> o2) {
            FieldContextWrapper o1Context = (FieldContextWrapper)o1.getValue();
            FieldContextWrapper o2Context = (FieldContextWrapper)o2.getValue();
            if (o1Context.category().equals(o2Context.category())) {
                return ((Field)o1.getKey()).getName().compareTo(((Field)o2.getKey()).getName());
            }
            return o1Context.category().compareTo(o2Context.category());
        }
    }
}

