/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pulsar.common.functions.WorkerInfo;
import org.apache.pulsar.common.policies.data.ErrorData;
import org.apache.pulsar.common.policies.data.FunctionStats;
import org.apache.pulsar.common.policies.data.WorkerFunctionInstanceStats;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.worker.FunctionRuntimeInfo;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.apache.pulsar.functions.worker.MembershipManager;
import org.apache.pulsar.functions.worker.Utils;
import org.apache.pulsar.functions.worker.WorkerService;
import org.apache.pulsar.functions.worker.rest.RestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerImpl {
    private static final Logger log = LoggerFactory.getLogger(WorkerImpl.class);
    private final Supplier<WorkerService> workerServiceSupplier;

    public WorkerImpl(Supplier<WorkerService> workerServiceSupplier) {
        this.workerServiceSupplier = workerServiceSupplier;
    }

    private WorkerService worker() {
        try {
            return (WorkerService)Preconditions.checkNotNull((Object)this.workerServiceSupplier.get());
        }
        catch (Throwable t) {
            log.info("Failed to get worker service", t);
            throw t;
        }
    }

    private boolean isWorkerServiceAvailable() {
        WorkerService workerService = this.workerServiceSupplier.get();
        if (workerService == null) {
            return false;
        }
        return workerService.isInitialized();
    }

    public List<WorkerInfo> getCluster() {
        if (!this.isWorkerServiceAvailable()) {
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Function worker service is not done initializing. Please try again in a little while.");
        }
        List<WorkerInfo> workers = this.worker().getMembershipManager().getCurrentMembership();
        return workers;
    }

    public WorkerInfo getClusterLeader() {
        if (!this.isWorkerServiceAvailable()) {
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Function worker service is not done initializing. Please try again in a little while.");
        }
        MembershipManager membershipManager = this.worker().getMembershipManager();
        WorkerInfo leader = membershipManager.getLeader();
        if (leader == null) {
            throw new RestException(Response.Status.INTERNAL_SERVER_ERROR, "Leader cannot be determined");
        }
        return leader;
    }

    public Map<String, Collection<String>> getAssignments() {
        if (!this.isWorkerServiceAvailable()) {
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Function worker service is not done initializing. Please try again in a little while.");
        }
        FunctionRuntimeManager functionRuntimeManager = this.worker().getFunctionRuntimeManager();
        Map<String, Map<String, Function.Assignment>> assignments = functionRuntimeManager.getCurrentAssignments();
        HashMap<String, Collection<String>> ret = new HashMap<String, Collection<String>>();
        for (Map.Entry<String, Map<String, Function.Assignment>> entry : assignments.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().keySet());
        }
        return ret;
    }

    public boolean isSuperUser(String clientRole) {
        return clientRole != null && this.worker().getWorkerConfig().getSuperUserRoles().contains(clientRole);
    }

    public List<Metrics> getWorkerMetrics(String clientRole) {
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not admin and authorized to get function-stats", (Object)clientRole);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.UNAUTHORIZED).type("application/json").entity((Object)new ErrorData(clientRole + " is not authorize to get metrics")).build());
        }
        return this.getWorkerMetrics();
    }

    private List<Metrics> getWorkerMetrics() {
        if (!this.isWorkerServiceAvailable()) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).type("application/json").entity((Object)new ErrorData("Function worker service is not available")).build());
        }
        return this.worker().getMetricsGenerator().generate();
    }

    public List<WorkerFunctionInstanceStats> getFunctionsMetrics(String clientRole) throws IOException {
        if (this.worker().getWorkerConfig().isAuthorizationEnabled() && !this.isSuperUser(clientRole)) {
            log.error("Client [{}] is not admin and authorized to get function-stats", (Object)clientRole);
            throw new RestException(Response.Status.UNAUTHORIZED, "client is not authorize to perform operation");
        }
        return this.getFunctionsMetrics();
    }

    private List<WorkerFunctionInstanceStats> getFunctionsMetrics() throws IOException {
        if (!this.isWorkerServiceAvailable()) {
            throw new RestException(Response.Status.SERVICE_UNAVAILABLE, "Function worker service is not done initializing. Please try again in a little while.");
        }
        WorkerService workerService = this.worker();
        Map<String, FunctionRuntimeInfo> functionRuntimes = workerService.getFunctionRuntimeManager().getFunctionRuntimeInfos();
        ArrayList<WorkerFunctionInstanceStats> metricsList = new ArrayList<WorkerFunctionInstanceStats>(functionRuntimes.size());
        for (Map.Entry<String, FunctionRuntimeInfo> entry : functionRuntimes.entrySet()) {
            String fullyQualifiedInstanceName = entry.getKey();
            FunctionRuntimeInfo functionRuntimeInfo = entry.getValue();
            if (workerService.getFunctionRuntimeManager().getRuntimeFactory().externallyManaged()) {
                Function.FunctionDetails functionDetails = functionRuntimeInfo.getFunctionInstance().getFunctionMetaData().getFunctionDetails();
                int parallelism = functionDetails.getParallelism();
                for (int i = 0; i < parallelism; ++i) {
                    FunctionStats.FunctionInstanceStats functionInstanceStats = Utils.getFunctionInstanceStats(fullyQualifiedInstanceName, functionRuntimeInfo, i);
                    WorkerFunctionInstanceStats workerFunctionInstanceStats = new WorkerFunctionInstanceStats();
                    workerFunctionInstanceStats.setName(org.apache.pulsar.functions.utils.Utils.getFullyQualifiedInstanceId((String)functionDetails.getTenant(), (String)functionDetails.getNamespace(), (String)functionDetails.getName(), (int)i));
                    workerFunctionInstanceStats.setMetrics(functionInstanceStats.getMetrics());
                    metricsList.add(workerFunctionInstanceStats);
                }
                continue;
            }
            FunctionStats.FunctionInstanceStats functionInstanceStats = Utils.getFunctionInstanceStats(fullyQualifiedInstanceName, functionRuntimeInfo, functionRuntimeInfo.getFunctionInstance().getInstanceId());
            WorkerFunctionInstanceStats workerFunctionInstanceStats = new WorkerFunctionInstanceStats();
            workerFunctionInstanceStats.setName(fullyQualifiedInstanceName);
            workerFunctionInstanceStats.setMetrics(functionInstanceStats.getMetrics());
            metricsList.add(workerFunctionInstanceStats);
        }
        return metricsList;
    }
}

