/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.rest.api.v3;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.commons.lang.StringUtils;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.common.io.SinkConfig;
import org.apache.pulsar.common.policies.data.SinkStatus;
import org.apache.pulsar.functions.worker.rest.FunctionApiResource;
import org.apache.pulsar.functions.worker.rest.api.SinkImpl;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/sink")
public class SinkApiV3Resource
extends FunctionApiResource {
    private static final Logger log = LoggerFactory.getLogger(SinkApiV3Resource.class);
    protected final SinkImpl sink = new SinkImpl(this);

    @POST
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    @Consumes(value={"multipart/form-data"})
    public void registerSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="sinkConfig") String sinkConfigJson) {
        this.sink.registerFunction(tenant, namespace, sinkName, uploadedInputStream, fileDetail, functionPkgUrl, null, sinkConfigJson, this.clientAppId());
    }

    @PUT
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    @Consumes(value={"multipart/form-data"})
    public void updateSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @FormDataParam(value="data") InputStream uploadedInputStream, @FormDataParam(value="data") FormDataContentDisposition fileDetail, @FormDataParam(value="url") String functionPkgUrl, @FormDataParam(value="sinkConfig") String sinkConfigJson) {
        this.sink.updateFunction(tenant, namespace, sinkName, uploadedInputStream, fileDetail, functionPkgUrl, null, sinkConfigJson, this.clientAppId());
    }

    @DELETE
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    public void deregisterSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) {
        this.sink.deregisterFunction(tenant, namespace, sinkName, this.clientAppId());
    }

    @GET
    @Path(value="/{tenant}/{namespace}/{sinkName}")
    public SinkConfig getSinkInfo(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) throws IOException {
        return this.sink.getSinkInfo(tenant, namespace, sinkName);
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Sink instance", response=SinkStatus.SinkInstanceStatus.SinkInstanceStatusData.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The sink doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/status")
    public SinkStatus.SinkInstanceStatus.SinkInstanceStatusData getSinkInstanceStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @PathParam(value="instanceId") String instanceId) throws IOException {
        return this.sink.getSinkInstanceStatus(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri());
    }

    @GET
    @ApiOperation(value="Displays the status of a Pulsar Sink running in cluster mode", response=SinkStatus.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=403, message="The requester doesn't have admin permissions"), @ApiResponse(code=404, message="The sink doesn't exist")})
    @Produces(value={"application/json"})
    @Path(value="/{tenant}/{namespace}/{sinkName}/status")
    public SinkStatus getSinkStatus(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) throws IOException {
        return this.sink.getSinkStatus(tenant, namespace, sinkName, this.uri.getRequestUri());
    }

    @GET
    @Path(value="/{tenant}/{namespace}")
    public List<String> listSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace) {
        return this.sink.listFunctions(tenant, namespace);
    }

    @POST
    @ApiOperation(value="Restart sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/restart")
    @Consumes(value={"application/json"})
    public void restartSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @PathParam(value="instanceId") String instanceId) {
        this.sink.restartFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri());
    }

    @POST
    @ApiOperation(value="Restart all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/restart")
    @Consumes(value={"application/json"})
    public void restartSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) {
        this.sink.restartFunctionInstances(tenant, namespace, sinkName);
    }

    @POST
    @ApiOperation(value="Stop sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/stop")
    @Consumes(value={"application/json"})
    public void stopSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @PathParam(value="instanceId") String instanceId) {
        this.sink.stopFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri());
    }

    @POST
    @ApiOperation(value="Stop all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/stop")
    @Consumes(value={"application/json"})
    public void stopSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) {
        this.sink.stopFunctionInstances(tenant, namespace, sinkName);
    }

    @POST
    @ApiOperation(value="Start sink instance", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/{instanceId}/start")
    @Consumes(value={"application/json"})
    public void startSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName, @PathParam(value="instanceId") String instanceId) {
        this.sink.startFunctionInstance(tenant, namespace, sinkName, instanceId, this.uri.getRequestUri());
    }

    @POST
    @ApiOperation(value="Start all sink instances", response=Void.class)
    @ApiResponses(value={@ApiResponse(code=400, message="Invalid request"), @ApiResponse(code=404, message="The function does not exist"), @ApiResponse(code=500, message="Internal server error")})
    @Path(value="/{tenant}/{namespace}/{sinkName}/start")
    @Consumes(value={"application/json"})
    public void startSink(@PathParam(value="tenant") String tenant, @PathParam(value="namespace") String namespace, @PathParam(value="sinkName") String sinkName) {
        this.sink.startFunctionInstances(tenant, namespace, sinkName);
    }

    @GET
    @Path(value="/builtinsinks")
    public List<ConnectorDefinition> getSinkList() {
        List<ConnectorDefinition> connectorDefinitions = this.sink.getListOfConnectors();
        ArrayList<ConnectorDefinition> retVal = new ArrayList<ConnectorDefinition>();
        for (ConnectorDefinition connectorDefinition : connectorDefinitions) {
            if (StringUtils.isEmpty((String)connectorDefinition.getSinkClass())) continue;
            retVal.add(connectorDefinition);
        }
        return retVal;
    }
}

