/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.functions.proto.Function;
import org.apache.pulsar.functions.worker.FunctionRuntimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionAssignmentTailer
implements Consumer<Message<byte[]>>,
Function<Throwable, Void>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FunctionAssignmentTailer.class);
    private final FunctionRuntimeManager functionRuntimeManager;
    private final Reader<byte[]> reader;
    private boolean closed = false;

    public FunctionAssignmentTailer(FunctionRuntimeManager functionRuntimeManager, Reader<byte[]> reader) {
        this.functionRuntimeManager = functionRuntimeManager;
        this.reader = reader;
    }

    public void start() {
        this.receiveOne();
    }

    private void receiveOne() {
        ((CompletableFuture)this.reader.readNextAsync().thenAccept((Consumer)this)).exceptionally((Function)this);
    }

    @Override
    public void close() {
        if (this.closed) {
            return;
        }
        log.info("Stopping function state consumer");
        try {
            this.closed = true;
            this.reader.close();
        }
        catch (IOException e) {
            log.error("Failed to stop function state consumer", (Throwable)e);
        }
        log.info("Stopped function state consumer");
    }

    public void processAssignment(Message<byte[]> msg) {
        if (msg.getData() == null || msg.getData().length == 0) {
            log.info("Received assignment delete: {}", (Object)msg.getKey());
            this.functionRuntimeManager.deleteAssignment(msg.getKey());
        } else {
            Function.Assignment assignment;
            try {
                assignment = Function.Assignment.parseFrom((byte[])msg.getData());
            }
            catch (IOException e) {
                log.error("[{}] Received bad assignment update at message {}", new Object[]{this.reader.getTopic(), msg.getMessageId(), e});
                throw new RuntimeException(e);
            }
            log.info("Received assignment update: {}", (Object)assignment);
            this.functionRuntimeManager.processAssignment(assignment);
        }
    }

    @Override
    public void accept(Message<byte[]> msg) {
        this.processAssignment(msg);
        this.receiveOne();
    }

    @Override
    public Void apply(Throwable cause) {
        Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)cause);
        if (realCause instanceof PulsarClientException.AlreadyClosedException) {
            if (this.closed) {
                return null;
            }
            log.error("Reader of assignment update topic is closed unexpectedly", cause);
            throw new RuntimeException("Reader of assignment update topic is closed unexpectedly", cause);
        }
        log.error("Failed to retrieve messages from assignment update topic", cause);
        throw new RuntimeException(cause);
    }
}

