/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.apache.pulsar.common.io.ConnectorDefinition;
import org.apache.pulsar.functions.utils.io.ConnectorUtils;
import org.apache.pulsar.functions.utils.io.Connectors;
import org.apache.pulsar.functions.worker.WorkerConfig;

public class ConnectorsManager {
    private Connectors connectors;

    public ConnectorsManager(WorkerConfig workerConfig) throws IOException {
        this.connectors = ConnectorUtils.searchForConnectors((String)workerConfig.getConnectorsDirectory());
    }

    public List<ConnectorDefinition> getConnectors() {
        return this.connectors.getConnectors();
    }

    public Path getSourceArchive(String sourceType) {
        return (Path)this.connectors.getSources().get(sourceType);
    }

    public Path getSinkArchive(String sinkType) {
        return (Path)this.connectors.getSinks().get(sinkType);
    }

    public void reloadConnectors(WorkerConfig workerConfig) throws IOException {
        this.connectors = ConnectorUtils.searchForConnectors((String)workerConfig.getConnectorsDirectory());
    }
}

