/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker.request;

import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.Producer;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.functions.proto.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceRequestManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(ServiceRequestManager.class);
    private final Producer producer;

    public ServiceRequestManager(Producer producer) throws PulsarClientException {
        this.producer = producer;
    }

    public CompletableFuture<MessageId> submitRequest(Request.ServiceRequest serviceRequest) {
        if (log.isDebugEnabled()) {
            log.debug("Submitting Service Request: {}", (Object)serviceRequest);
        }
        return this.producer.sendAsync((Object)serviceRequest.toByteArray());
    }

    @Override
    public void close() {
        try {
            this.producer.close();
        }
        catch (PulsarClientException e) {
            log.warn("Failed to close producer for service request manager", (Throwable)e);
        }
    }
}

