/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.worker;

import java.io.IOException;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.PulsarClientException;
import org.apache.pulsar.client.api.Reader;
import org.apache.pulsar.client.api.ReaderBuilder;
import org.apache.pulsar.functions.proto.Request;
import org.apache.pulsar.functions.worker.ErrorNotifier;
import org.apache.pulsar.functions.worker.FunctionMetaDataManager;
import org.apache.pulsar.functions.worker.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionMetaDataTopicTailer
implements Runnable,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(FunctionMetaDataTopicTailer.class);
    private final FunctionMetaDataManager functionMetaDataManager;
    private final Reader<byte[]> reader;
    private final Thread readerThread;
    private volatile boolean running;
    private ErrorNotifier errorNotifier;

    public FunctionMetaDataTopicTailer(FunctionMetaDataManager functionMetaDataManager, ReaderBuilder readerBuilder, WorkerConfig workerConfig, ErrorNotifier errorNotifier) throws PulsarClientException {
        this.functionMetaDataManager = functionMetaDataManager;
        this.reader = readerBuilder.topic(workerConfig.getFunctionMetadataTopic()).startMessageId(MessageId.earliest).readerName(workerConfig.getWorkerId() + "-function-metadata-manager").subscriptionRolePrefix(workerConfig.getWorkerId() + "-function-metadata-manager").create();
        this.readerThread = new Thread(this);
        this.readerThread.setName("function-metadata-tailer-thread");
        this.errorNotifier = errorNotifier;
    }

    public void start() {
        this.running = true;
        this.readerThread.start();
    }

    @Override
    public void run() {
        while (this.running) {
            try {
                Message msg = this.reader.readNext();
                this.processRequest((Message<byte[]>)msg);
            }
            catch (Throwable th) {
                if (this.running) {
                    log.error("Encountered error in metadata tailer", th);
                    this.running = false;
                    this.errorNotifier.triggerError(th);
                    continue;
                }
                if (!(th instanceof InterruptedException) && !(th.getCause() instanceof InterruptedException)) {
                    log.warn("Encountered error when metadata tailer is not running", th);
                }
                return;
            }
        }
    }

    @Override
    public void close() {
        log.info("Stopping function metadata tailer");
        try {
            this.running = false;
            if (this.readerThread != null && this.readerThread.isAlive()) {
                this.readerThread.interrupt();
            }
            if (this.reader != null) {
                this.reader.close();
            }
        }
        catch (IOException e) {
            log.error("Failed to stop function metadata tailer", (Throwable)e);
        }
        log.info("Stopped function metadata tailer");
    }

    public void processRequest(Message<byte[]> msg) throws IOException {
        Request.ServiceRequest serviceRequest = Request.ServiceRequest.parseFrom((byte[])msg.getData());
        if (log.isDebugEnabled()) {
            log.debug("Received Service Request: {}", (Object)serviceRequest);
        }
        this.functionMetaDataManager.processRequest(msg.getMessageId(), serviceRequest);
    }

    public Reader<byte[]> getReader() {
        return this.reader;
    }
}

