/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.cassandra;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.apache.pulsar.io.core.annotations.FieldDoc;

public class CassandraSinkConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @FieldDoc(required=true, defaultValue="", help="A comma-separated list of cassandra hosts to connect to")
    private String roots;
    @FieldDoc(required=true, defaultValue="", help="The key space used for writing pulsar messages to")
    private String keyspace;
    @FieldDoc(required=true, defaultValue="", help="The key name of the cassandra column family")
    private String keyname;
    @FieldDoc(required=true, defaultValue="", help="The cassandra column family name")
    private String columnFamily;
    @FieldDoc(required=true, defaultValue="", help="The column name of the cassandra column family")
    private String columnName;

    public static CassandraSinkConfig load(String yamlFile) throws IOException {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        return (CassandraSinkConfig)mapper.readValue(new File(yamlFile), CassandraSinkConfig.class);
    }

    public static CassandraSinkConfig load(Map<String, Object> map) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (CassandraSinkConfig)mapper.readValue(mapper.writeValueAsString(map), CassandraSinkConfig.class);
    }

    public String getRoots() {
        return this.roots;
    }

    public String getKeyspace() {
        return this.keyspace;
    }

    public String getKeyname() {
        return this.keyname;
    }

    public String getColumnFamily() {
        return this.columnFamily;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public CassandraSinkConfig setRoots(String roots) {
        this.roots = roots;
        return this;
    }

    public CassandraSinkConfig setKeyspace(String keyspace) {
        this.keyspace = keyspace;
        return this;
    }

    public CassandraSinkConfig setKeyname(String keyname) {
        this.keyname = keyname;
        return this;
    }

    public CassandraSinkConfig setColumnFamily(String columnFamily) {
        this.columnFamily = columnFamily;
        return this;
    }

    public CassandraSinkConfig setColumnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CassandraSinkConfig)) {
            return false;
        }
        CassandraSinkConfig other = (CassandraSinkConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$roots = this.getRoots();
        String other$roots = other.getRoots();
        if (this$roots == null ? other$roots != null : !this$roots.equals(other$roots)) {
            return false;
        }
        String this$keyspace = this.getKeyspace();
        String other$keyspace = other.getKeyspace();
        if (this$keyspace == null ? other$keyspace != null : !this$keyspace.equals(other$keyspace)) {
            return false;
        }
        String this$keyname = this.getKeyname();
        String other$keyname = other.getKeyname();
        if (this$keyname == null ? other$keyname != null : !this$keyname.equals(other$keyname)) {
            return false;
        }
        String this$columnFamily = this.getColumnFamily();
        String other$columnFamily = other.getColumnFamily();
        if (this$columnFamily == null ? other$columnFamily != null : !this$columnFamily.equals(other$columnFamily)) {
            return false;
        }
        String this$columnName = this.getColumnName();
        String other$columnName = other.getColumnName();
        return !(this$columnName == null ? other$columnName != null : !this$columnName.equals(other$columnName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CassandraSinkConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $roots = this.getRoots();
        result = result * 59 + ($roots == null ? 43 : $roots.hashCode());
        String $keyspace = this.getKeyspace();
        result = result * 59 + ($keyspace == null ? 43 : $keyspace.hashCode());
        String $keyname = this.getKeyname();
        result = result * 59 + ($keyname == null ? 43 : $keyname.hashCode());
        String $columnFamily = this.getColumnFamily();
        result = result * 59 + ($columnFamily == null ? 43 : $columnFamily.hashCode());
        String $columnName = this.getColumnName();
        result = result * 59 + ($columnName == null ? 43 : $columnName.hashCode());
        return result;
    }

    public String toString() {
        return "CassandraSinkConfig(roots=" + this.getRoots() + ", keyspace=" + this.getKeyspace() + ", keyname=" + this.getKeyname() + ", columnFamily=" + this.getColumnFamily() + ", columnName=" + this.getColumnName() + ")";
    }
}

