/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.io.influxdb.v1;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.pulsar.client.api.SchemaSerializationException;
import org.apache.pulsar.client.api.schema.Field;
import org.apache.pulsar.client.api.schema.GenericRecord;
import org.apache.pulsar.functions.api.Record;
import org.apache.pulsar.io.influxdb.v1.InfluxDBAbstractSink;
import org.influxdb.dto.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBGenericRecordSink
extends InfluxDBAbstractSink<GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(InfluxDBGenericRecordSink.class);
    private static final Set<String> FIELDS_TO_SKIP = ImmutableSet.of((Object)"measurement", (Object)"tags");

    @Override
    protected Point buildPoint(Record<GenericRecord> message) throws Exception {
        HashMap fields = Maps.newHashMap();
        GenericRecord record = (GenericRecord)message.getValue();
        Object measurementField = this.getFiled(record, "measurement");
        if (null == measurementField) {
            throw new SchemaSerializationException("measurement is a required field.");
        }
        String measurement = measurementField.toString();
        Object tagsField = this.getFiled(record, "tags");
        Object tags = null == tagsField ? ImmutableMap.of() : (Map.class.isAssignableFrom(tagsField.getClass()) ? ((Map)tagsField).entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString())) : ImmutableMap.of());
        long timestamp = System.currentTimeMillis();
        for (Field field : record.getFields()) {
            Object fieldValue;
            String fieldName = field.getName();
            if (FIELDS_TO_SKIP.contains(fieldName) || null == (fieldValue = record.getField(field))) continue;
            fields.put(fieldName, fieldValue);
        }
        Point.Builder builder = Point.measurement((String)measurement).time(timestamp, TimeUnit.MILLISECONDS).tag((Map)tags).fields((Map)fields);
        return builder.build();
    }
}

